# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetResourceSetResult',
    'AwaitableGetResourceSetResult',
    'get_resource_set',
    'get_resource_set_output',
]

@pulumi.output_type
class GetResourceSetResult:
    def __init__(__self__, resource_set_arn=None, resources=None, tags=None):
        if resource_set_arn and not isinstance(resource_set_arn, str):
            raise TypeError("Expected argument 'resource_set_arn' to be a str")
        pulumi.set(__self__, "resource_set_arn", resource_set_arn)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceSetArn")
    def resource_set_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the resource set.
        """
        return pulumi.get(self, "resource_set_arn")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence['outputs.ResourceSetResource']]:
        """
        A list of resource objects in the resource set.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A tag to associate with the parameters for a resource set.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceSetResult(GetResourceSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceSetResult(
            resource_set_arn=self.resource_set_arn,
            resources=self.resources,
            tags=self.tags)


def get_resource_set(resource_set_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceSetResult:
    """
    Schema for the AWS Route53 Recovery Readiness ResourceSet Resource and API.


    :param str resource_set_name: The name of the resource set to create.
    """
    __args__ = dict()
    __args__['resourceSetName'] = resource_set_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53recoveryreadiness:getResourceSet', __args__, opts=opts, typ=GetResourceSetResult).value

    return AwaitableGetResourceSetResult(
        resource_set_arn=pulumi.get(__ret__, 'resource_set_arn'),
        resources=pulumi.get(__ret__, 'resources'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_set_output(resource_set_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourceSetResult]:
    """
    Schema for the AWS Route53 Recovery Readiness ResourceSet Resource and API.


    :param str resource_set_name: The name of the resource set to create.
    """
    __args__ = dict()
    __args__['resourceSetName'] = resource_set_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:route53recoveryreadiness:getResourceSet', __args__, opts=opts, typ=GetResourceSetResult)
    return __ret__.apply(lambda __response__: GetResourceSetResult(
        resource_set_arn=pulumi.get(__response__, 'resource_set_arn'),
        resources=pulumi.get(__response__, 'resources'),
        tags=pulumi.get(__response__, 'tags')))
