# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetSafetyRuleResult',
    'AwaitableGetSafetyRuleResult',
    'get_safety_rule',
    'get_safety_rule_output',
]

@pulumi.output_type
class GetSafetyRuleResult:
    def __init__(__self__, assertion_rule=None, control_panel_arn=None, gating_rule=None, name=None, rule_config=None, safety_rule_arn=None, status=None):
        if assertion_rule and not isinstance(assertion_rule, dict):
            raise TypeError("Expected argument 'assertion_rule' to be a dict")
        pulumi.set(__self__, "assertion_rule", assertion_rule)
        if control_panel_arn and not isinstance(control_panel_arn, str):
            raise TypeError("Expected argument 'control_panel_arn' to be a str")
        pulumi.set(__self__, "control_panel_arn", control_panel_arn)
        if gating_rule and not isinstance(gating_rule, dict):
            raise TypeError("Expected argument 'gating_rule' to be a dict")
        pulumi.set(__self__, "gating_rule", gating_rule)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rule_config and not isinstance(rule_config, dict):
            raise TypeError("Expected argument 'rule_config' to be a dict")
        pulumi.set(__self__, "rule_config", rule_config)
        if safety_rule_arn and not isinstance(safety_rule_arn, str):
            raise TypeError("Expected argument 'safety_rule_arn' to be a str")
        pulumi.set(__self__, "safety_rule_arn", safety_rule_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="assertionRule")
    def assertion_rule(self) -> Optional['outputs.SafetyRuleAssertionRule']:
        """
        An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met. Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is `On` after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
        """
        return pulumi.get(self, "assertion_rule")

    @property
    @pulumi.getter(name="controlPanelArn")
    def control_panel_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the control panel.
        """
        return pulumi.get(self, "control_panel_arn")

    @property
    @pulumi.getter(name="gatingRule")
    def gating_rule(self) -> Optional['outputs.SafetyRuleGatingRule']:
        """
        A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.

        For example, if you specify one gating routing control and you set the `Type` in the rule configuration to `OR` , that indicates that you must set the gating routing control to `On` for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
        """
        return pulumi.get(self, "gating_rule")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the assertion rule. The name must be unique within a control panel. You can use any non-white space character in the name except the following: & > < ' (single quote) " (double quote) ; (semicolon)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleConfig")
    def rule_config(self) -> Optional['outputs.SafetyRuleRuleConfig']:
        """
        The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be `ON` as the result of a transaction. For example, if you have three assertion controls, you might specify `ATLEAST 2` for your rule configuration. This means that at least two assertion controls must be `ON` , so that at least two AWS Regions have traffic flowing to them.
        """
        return pulumi.get(self, "rule_config")

    @property
    @pulumi.getter(name="safetyRuleArn")
    def safety_rule_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the safety rule.
        """
        return pulumi.get(self, "safety_rule_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional['SafetyRuleStatus']:
        """
        The deployment status of the routing control. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
        """
        return pulumi.get(self, "status")


class AwaitableGetSafetyRuleResult(GetSafetyRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSafetyRuleResult(
            assertion_rule=self.assertion_rule,
            control_panel_arn=self.control_panel_arn,
            gating_rule=self.gating_rule,
            name=self.name,
            rule_config=self.rule_config,
            safety_rule_arn=self.safety_rule_arn,
            status=self.status)


def get_safety_rule(safety_rule_arn: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSafetyRuleResult:
    """
    Resource schema for AWS Route53 Recovery Control basic constructs and validation rules.


    :param str safety_rule_arn: The Amazon Resource Name (ARN) of the safety rule.
    """
    __args__ = dict()
    __args__['safetyRuleArn'] = safety_rule_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53recoverycontrol:getSafetyRule', __args__, opts=opts, typ=GetSafetyRuleResult).value

    return AwaitableGetSafetyRuleResult(
        assertion_rule=pulumi.get(__ret__, 'assertion_rule'),
        control_panel_arn=pulumi.get(__ret__, 'control_panel_arn'),
        gating_rule=pulumi.get(__ret__, 'gating_rule'),
        name=pulumi.get(__ret__, 'name'),
        rule_config=pulumi.get(__ret__, 'rule_config'),
        safety_rule_arn=pulumi.get(__ret__, 'safety_rule_arn'),
        status=pulumi.get(__ret__, 'status'))
def get_safety_rule_output(safety_rule_arn: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSafetyRuleResult]:
    """
    Resource schema for AWS Route53 Recovery Control basic constructs and validation rules.


    :param str safety_rule_arn: The Amazon Resource Name (ARN) of the safety rule.
    """
    __args__ = dict()
    __args__['safetyRuleArn'] = safety_rule_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:route53recoverycontrol:getSafetyRule', __args__, opts=opts, typ=GetSafetyRuleResult)
    return __ret__.apply(lambda __response__: GetSafetyRuleResult(
        assertion_rule=pulumi.get(__response__, 'assertion_rule'),
        control_panel_arn=pulumi.get(__response__, 'control_panel_arn'),
        gating_rule=pulumi.get(__response__, 'gating_rule'),
        name=pulumi.get(__response__, 'name'),
        rule_config=pulumi.get(__response__, 'rule_config'),
        safety_rule_arn=pulumi.get(__response__, 'safety_rule_arn'),
        status=pulumi.get(__response__, 'status')))
