# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'HealthCheckConfigPropertiesInsufficientDataHealthStatus',
    'HealthCheckConfigPropertiesType',
    'KeySigningKeyStatus',
]


class HealthCheckConfigPropertiesInsufficientDataHealthStatus(str, Enum):
    """
    When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:

    - `Healthy` : Route 53 considers the health check to be healthy.
    - `Unhealthy` : Route 53 considers the health check to be unhealthy.
    - `LastKnownStatus` : Route 53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.
    """
    HEALTHY = "Healthy"
    LAST_KNOWN_STATUS = "LastKnownStatus"
    UNHEALTHY = "Unhealthy"


class HealthCheckConfigPropertiesType(str, Enum):
    """
    The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an endpoint is healthy.

    > You can't change the value of `Type` after you create a health check. 

    You can create the following types of health checks:

    - *HTTP* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
    - *HTTPS* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.

    > If you specify `HTTPS` for the value of `Type` , the endpoint must support TLS v1.0 or later.
    - *HTTP_STR_MATCH* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in `SearchString` .
    - *HTTPS_STR_MATCH* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an `HTTPS` request and searches the first 5,120 bytes of the response body for the string that you specify in `SearchString` .
    - *TCP* : Route 53 tries to establish a TCP connection.
    - *CLOUDWATCH_METRIC* : The health check is associated with a CloudWatch alarm. If the state of the alarm is `OK` , the health check is considered healthy. If the state is `ALARM` , the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is `OK` or `ALARM` , the health check status depends on the setting for `InsufficientDataHealthStatus` : `Healthy` , `Unhealthy` , or `LastKnownStatus` .

    > Route 53 supports CloudWatch alarms with the following features:
    > 
    > - Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide* .
    > - Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.
    - *CALCULATED* : For health checks that monitor the status of other health checks, Route 53 adds up the number of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of `HealthThreshold` .
    - *RECOVERY_CONTROL* : The health check is assocated with a Route53 Application Recovery Controller routing control. If the routing control state is `ON` , the health check is considered healthy. If the state is `OFF` , the health check is considered unhealthy.

    For more information, see [How Route 53 Determines Whether an Endpoint Is Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html) in the *Amazon Route 53 Developer Guide* .
    """
    CALCULATED = "CALCULATED"
    CLOUDWATCH_METRIC = "CLOUDWATCH_METRIC"
    HTTP = "HTTP"
    HTTP_STR_MATCH = "HTTP_STR_MATCH"
    HTTPS = "HTTPS"
    HTTPS_STR_MATCH = "HTTPS_STR_MATCH"
    TCP = "TCP"
    RECOVERY_CONTROL = "RECOVERY_CONTROL"


class KeySigningKeyStatus(str, Enum):
    """
    A string specifying the initial status of the key signing key (KSK). You can set the value to ACTIVE or INACTIVE.
    """
    ACTIVE = "ACTIVE"
    INACTIVE = "INACTIVE"
