# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetProfileResult',
    'AwaitableGetProfileResult',
    'get_profile',
    'get_profile_output',
]

@pulumi.output_type
class GetProfileResult:
    def __init__(__self__, accept_role_session_name=None, attribute_mappings=None, duration_seconds=None, enabled=None, managed_policy_arns=None, name=None, profile_arn=None, profile_id=None, require_instance_properties=None, role_arns=None, session_policy=None, tags=None):
        if accept_role_session_name and not isinstance(accept_role_session_name, bool):
            raise TypeError("Expected argument 'accept_role_session_name' to be a bool")
        pulumi.set(__self__, "accept_role_session_name", accept_role_session_name)
        if attribute_mappings and not isinstance(attribute_mappings, list):
            raise TypeError("Expected argument 'attribute_mappings' to be a list")
        pulumi.set(__self__, "attribute_mappings", attribute_mappings)
        if duration_seconds and not isinstance(duration_seconds, float):
            raise TypeError("Expected argument 'duration_seconds' to be a float")
        pulumi.set(__self__, "duration_seconds", duration_seconds)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if managed_policy_arns and not isinstance(managed_policy_arns, list):
            raise TypeError("Expected argument 'managed_policy_arns' to be a list")
        pulumi.set(__self__, "managed_policy_arns", managed_policy_arns)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if profile_arn and not isinstance(profile_arn, str):
            raise TypeError("Expected argument 'profile_arn' to be a str")
        pulumi.set(__self__, "profile_arn", profile_arn)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if require_instance_properties and not isinstance(require_instance_properties, bool):
            raise TypeError("Expected argument 'require_instance_properties' to be a bool")
        pulumi.set(__self__, "require_instance_properties", require_instance_properties)
        if role_arns and not isinstance(role_arns, list):
            raise TypeError("Expected argument 'role_arns' to be a list")
        pulumi.set(__self__, "role_arns", role_arns)
        if session_policy and not isinstance(session_policy, str):
            raise TypeError("Expected argument 'session_policy' to be a str")
        pulumi.set(__self__, "session_policy", session_policy)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="acceptRoleSessionName")
    def accept_role_session_name(self) -> Optional[bool]:
        """
        Used to determine if a custom role session name will be accepted in a temporary credential request.
        """
        return pulumi.get(self, "accept_role_session_name")

    @property
    @pulumi.getter(name="attributeMappings")
    def attribute_mappings(self) -> Optional[Sequence['outputs.ProfileAttributeMapping']]:
        """
        A mapping applied to the authenticating end-entity certificate.
        """
        return pulumi.get(self, "attribute_mappings")

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[float]:
        """
        The number of seconds vended session credentials will be valid for
        """
        return pulumi.get(self, "duration_seconds")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        The enabled status of the resource.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="managedPolicyArns")
    def managed_policy_arns(self) -> Optional[Sequence[str]]:
        """
        A list of managed policy ARNs. Managed policies identified by this list will be applied to the vended session credentials.
        """
        return pulumi.get(self, "managed_policy_arns")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The customer specified name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="profileArn")
    def profile_arn(self) -> Optional[str]:
        """
        The ARN of the profile.
        """
        return pulumi.get(self, "profile_arn")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[str]:
        """
        The unique primary identifier of the Profile
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="requireInstanceProperties")
    def require_instance_properties(self) -> Optional[bool]:
        """
        Specifies whether instance properties are required in CreateSession requests with this profile.
        """
        return pulumi.get(self, "require_instance_properties")

    @property
    @pulumi.getter(name="roleArns")
    def role_arns(self) -> Optional[Sequence[str]]:
        """
        A list of IAM role ARNs that can be assumed when this profile is specified in a CreateSession request.
        """
        return pulumi.get(self, "role_arns")

    @property
    @pulumi.getter(name="sessionPolicy")
    def session_policy(self) -> Optional[str]:
        """
        A session policy that will applied to the trust boundary of the vended session credentials.
        """
        return pulumi.get(self, "session_policy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of Tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProfileResult(GetProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfileResult(
            accept_role_session_name=self.accept_role_session_name,
            attribute_mappings=self.attribute_mappings,
            duration_seconds=self.duration_seconds,
            enabled=self.enabled,
            managed_policy_arns=self.managed_policy_arns,
            name=self.name,
            profile_arn=self.profile_arn,
            profile_id=self.profile_id,
            require_instance_properties=self.require_instance_properties,
            role_arns=self.role_arns,
            session_policy=self.session_policy,
            tags=self.tags)


def get_profile(profile_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfileResult:
    """
    Definition of AWS::RolesAnywhere::Profile Resource Type


    :param str profile_id: The unique primary identifier of the Profile
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rolesanywhere:getProfile', __args__, opts=opts, typ=GetProfileResult).value

    return AwaitableGetProfileResult(
        accept_role_session_name=pulumi.get(__ret__, 'accept_role_session_name'),
        attribute_mappings=pulumi.get(__ret__, 'attribute_mappings'),
        duration_seconds=pulumi.get(__ret__, 'duration_seconds'),
        enabled=pulumi.get(__ret__, 'enabled'),
        managed_policy_arns=pulumi.get(__ret__, 'managed_policy_arns'),
        name=pulumi.get(__ret__, 'name'),
        profile_arn=pulumi.get(__ret__, 'profile_arn'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        require_instance_properties=pulumi.get(__ret__, 'require_instance_properties'),
        role_arns=pulumi.get(__ret__, 'role_arns'),
        session_policy=pulumi.get(__ret__, 'session_policy'),
        tags=pulumi.get(__ret__, 'tags'))
def get_profile_output(profile_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProfileResult]:
    """
    Definition of AWS::RolesAnywhere::Profile Resource Type


    :param str profile_id: The unique primary identifier of the Profile
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rolesanywhere:getProfile', __args__, opts=opts, typ=GetProfileResult)
    return __ret__.apply(lambda __response__: GetProfileResult(
        accept_role_session_name=pulumi.get(__response__, 'accept_role_session_name'),
        attribute_mappings=pulumi.get(__response__, 'attribute_mappings'),
        duration_seconds=pulumi.get(__response__, 'duration_seconds'),
        enabled=pulumi.get(__response__, 'enabled'),
        managed_policy_arns=pulumi.get(__response__, 'managed_policy_arns'),
        name=pulumi.get(__response__, 'name'),
        profile_arn=pulumi.get(__response__, 'profile_arn'),
        profile_id=pulumi.get(__response__, 'profile_id'),
        require_instance_properties=pulumi.get(__response__, 'require_instance_properties'),
        role_arns=pulumi.get(__response__, 'role_arns'),
        session_policy=pulumi.get(__response__, 'session_policy'),
        tags=pulumi.get(__response__, 'tags')))
