# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ProfileAttributeMappingArgs',
    'ProfileAttributeMappingArgsDict',
    'ProfileMappingRuleArgs',
    'ProfileMappingRuleArgsDict',
    'TrustAnchorNotificationSettingArgs',
    'TrustAnchorNotificationSettingArgsDict',
    'TrustAnchorSourceData0PropertiesArgs',
    'TrustAnchorSourceData0PropertiesArgsDict',
    'TrustAnchorSourceData1PropertiesArgs',
    'TrustAnchorSourceData1PropertiesArgsDict',
    'TrustAnchorSourceArgs',
    'TrustAnchorSourceArgsDict',
]

MYPY = False

if not MYPY:
    class ProfileAttributeMappingArgsDict(TypedDict):
        certificate_field: pulumi.Input['ProfileCertificateField']
        """
        Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
        """
        mapping_rules: pulumi.Input[Sequence[pulumi.Input['ProfileMappingRuleArgsDict']]]
        """
        A list of mapping entries for every supported specifier or sub-field.
        """
elif False:
    ProfileAttributeMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProfileAttributeMappingArgs:
    def __init__(__self__, *,
                 certificate_field: pulumi.Input['ProfileCertificateField'],
                 mapping_rules: pulumi.Input[Sequence[pulumi.Input['ProfileMappingRuleArgs']]]):
        """
        :param pulumi.Input['ProfileCertificateField'] certificate_field: Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileMappingRuleArgs']]] mapping_rules: A list of mapping entries for every supported specifier or sub-field.
        """
        pulumi.set(__self__, "certificate_field", certificate_field)
        pulumi.set(__self__, "mapping_rules", mapping_rules)

    @property
    @pulumi.getter(name="certificateField")
    def certificate_field(self) -> pulumi.Input['ProfileCertificateField']:
        """
        Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
        """
        return pulumi.get(self, "certificate_field")

    @certificate_field.setter
    def certificate_field(self, value: pulumi.Input['ProfileCertificateField']):
        pulumi.set(self, "certificate_field", value)

    @property
    @pulumi.getter(name="mappingRules")
    def mapping_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ProfileMappingRuleArgs']]]:
        """
        A list of mapping entries for every supported specifier or sub-field.
        """
        return pulumi.get(self, "mapping_rules")

    @mapping_rules.setter
    def mapping_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ProfileMappingRuleArgs']]]):
        pulumi.set(self, "mapping_rules", value)


if not MYPY:
    class ProfileMappingRuleArgsDict(TypedDict):
        specifier: pulumi.Input[str]
        """
        Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
        """
elif False:
    ProfileMappingRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProfileMappingRuleArgs:
    def __init__(__self__, *,
                 specifier: pulumi.Input[str]):
        """
        :param pulumi.Input[str] specifier: Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
        """
        pulumi.set(__self__, "specifier", specifier)

    @property
    @pulumi.getter
    def specifier(self) -> pulumi.Input[str]:
        """
        Specifier within a certificate field, such as CN, OU, or UID from the Subject field.
        """
        return pulumi.get(self, "specifier")

    @specifier.setter
    def specifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "specifier", value)


if not MYPY:
    class TrustAnchorNotificationSettingArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Indicates whether the notification setting is enabled.
        """
        event: pulumi.Input['TrustAnchorNotificationEvent']
        """
        The event to which this notification setting is applied.
        """
        channel: NotRequired[pulumi.Input['TrustAnchorNotificationChannel']]
        """
        The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and AWS Health Dashboard to notify for an event.

        > In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
        """
        threshold: NotRequired[pulumi.Input[float]]
        """
        The number of days before a notification event. This value is required for a notification setting that is enabled.
        """
elif False:
    TrustAnchorNotificationSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrustAnchorNotificationSettingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 event: pulumi.Input['TrustAnchorNotificationEvent'],
                 channel: Optional[pulumi.Input['TrustAnchorNotificationChannel']] = None,
                 threshold: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] enabled: Indicates whether the notification setting is enabled.
        :param pulumi.Input['TrustAnchorNotificationEvent'] event: The event to which this notification setting is applied.
        :param pulumi.Input['TrustAnchorNotificationChannel'] channel: The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and AWS Health Dashboard to notify for an event.
               
               > In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
        :param pulumi.Input[float] threshold: The number of days before a notification event. This value is required for a notification setting that is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "event", event)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Indicates whether the notification setting is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def event(self) -> pulumi.Input['TrustAnchorNotificationEvent']:
        """
        The event to which this notification setting is applied.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: pulumi.Input['TrustAnchorNotificationEvent']):
        pulumi.set(self, "event", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input['TrustAnchorNotificationChannel']]:
        """
        The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and AWS Health Dashboard to notify for an event.

        > In the absence of a specific channel, IAM Roles Anywhere applies this setting to 'ALL' channels.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input['TrustAnchorNotificationChannel']]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The number of days before a notification event. This value is required for a notification setting that is enabled.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class TrustAnchorSourceData0PropertiesArgsDict(TypedDict):
        x509_certificate_data: pulumi.Input[str]
elif False:
    TrustAnchorSourceData0PropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrustAnchorSourceData0PropertiesArgs:
    def __init__(__self__, *,
                 x509_certificate_data: pulumi.Input[str]):
        pulumi.set(__self__, "x509_certificate_data", x509_certificate_data)

    @property
    @pulumi.getter(name="x509CertificateData")
    def x509_certificate_data(self) -> pulumi.Input[str]:
        return pulumi.get(self, "x509_certificate_data")

    @x509_certificate_data.setter
    def x509_certificate_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "x509_certificate_data", value)


if not MYPY:
    class TrustAnchorSourceData1PropertiesArgsDict(TypedDict):
        acm_pca_arn: pulumi.Input[str]
elif False:
    TrustAnchorSourceData1PropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrustAnchorSourceData1PropertiesArgs:
    def __init__(__self__, *,
                 acm_pca_arn: pulumi.Input[str]):
        pulumi.set(__self__, "acm_pca_arn", acm_pca_arn)

    @property
    @pulumi.getter(name="acmPcaArn")
    def acm_pca_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "acm_pca_arn")

    @acm_pca_arn.setter
    def acm_pca_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "acm_pca_arn", value)


if not MYPY:
    class TrustAnchorSourceArgsDict(TypedDict):
        source_data: NotRequired[pulumi.Input[Union['TrustAnchorSourceData0PropertiesArgsDict', 'TrustAnchorSourceData1PropertiesArgsDict']]]
        """
        A union object representing the data field of the TrustAnchor depending on its type
        """
        source_type: NotRequired[pulumi.Input['TrustAnchorType']]
        """
        The type of the TrustAnchor.
        """
elif False:
    TrustAnchorSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrustAnchorSourceArgs:
    def __init__(__self__, *,
                 source_data: Optional[pulumi.Input[Union['TrustAnchorSourceData0PropertiesArgs', 'TrustAnchorSourceData1PropertiesArgs']]] = None,
                 source_type: Optional[pulumi.Input['TrustAnchorType']] = None):
        """
        :param pulumi.Input[Union['TrustAnchorSourceData0PropertiesArgs', 'TrustAnchorSourceData1PropertiesArgs']] source_data: A union object representing the data field of the TrustAnchor depending on its type
        :param pulumi.Input['TrustAnchorType'] source_type: The type of the TrustAnchor.
        """
        if source_data is not None:
            pulumi.set(__self__, "source_data", source_data)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="sourceData")
    def source_data(self) -> Optional[pulumi.Input[Union['TrustAnchorSourceData0PropertiesArgs', 'TrustAnchorSourceData1PropertiesArgs']]]:
        """
        A union object representing the data field of the TrustAnchor depending on its type
        """
        return pulumi.get(self, "source_data")

    @source_data.setter
    def source_data(self, value: Optional[pulumi.Input[Union['TrustAnchorSourceData0PropertiesArgs', 'TrustAnchorSourceData1PropertiesArgs']]]):
        pulumi.set(self, "source_data", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input['TrustAnchorType']]:
        """
        The type of the TrustAnchor.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input['TrustAnchorType']]):
        pulumi.set(self, "source_type", value)


