# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'RobotApplicationRobotSoftwareSuite',
    'RobotApplicationSourceConfig',
    'SimulationApplicationRenderingEngine',
    'SimulationApplicationRobotSoftwareSuite',
    'SimulationApplicationSimulationSoftwareSuite',
    'SimulationApplicationSourceConfig',
]

@pulumi.output_type
class RobotApplicationRobotSoftwareSuite(dict):
    """
    The robot software suite used by the robot application.
    """
    def __init__(__self__, *,
                 name: 'RobotApplicationRobotSoftwareSuiteName',
                 version: Optional['RobotApplicationRobotSoftwareSuiteVersion'] = None):
        """
        The robot software suite used by the robot application.
        :param 'RobotApplicationRobotSoftwareSuiteName' name: The name of robot software suite.
        :param 'RobotApplicationRobotSoftwareSuiteVersion' version: The version of robot software suite.
        """
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> 'RobotApplicationRobotSoftwareSuiteName':
        """
        The name of robot software suite.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional['RobotApplicationRobotSoftwareSuiteVersion']:
        """
        The version of robot software suite.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RobotApplicationSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3Key":
            suggest = "s3_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RobotApplicationSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RobotApplicationSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RobotApplicationSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: 'RobotApplicationSourceConfigArchitecture',
                 s3_bucket: str,
                 s3_key: str):
        """
        :param 'RobotApplicationSourceConfigArchitecture' architecture: The architecture of robot application.
        :param str s3_bucket: The Arn of the S3Bucket that stores the robot application source.
        :param str s3_key: The s3 key of robot application source.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_key", s3_key)

    @property
    @pulumi.getter
    def architecture(self) -> 'RobotApplicationSourceConfigArchitecture':
        """
        The architecture of robot application.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        The Arn of the S3Bucket that stores the robot application source.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> str:
        """
        The s3 key of robot application source.
        """
        return pulumi.get(self, "s3_key")


@pulumi.output_type
class SimulationApplicationRenderingEngine(dict):
    """
    Information about a rendering engine.
    """
    def __init__(__self__, *,
                 name: 'SimulationApplicationRenderingEngineName',
                 version: str):
        """
        Information about a rendering engine.
        :param 'SimulationApplicationRenderingEngineName' name: The name of the rendering engine.
        :param str version: The version of the rendering engine.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> 'SimulationApplicationRenderingEngineName':
        """
        The name of the rendering engine.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the rendering engine.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SimulationApplicationRobotSoftwareSuite(dict):
    """
    Information about a robot software suite.
    """
    def __init__(__self__, *,
                 name: 'SimulationApplicationRobotSoftwareSuiteName',
                 version: Optional['SimulationApplicationRobotSoftwareSuiteVersion'] = None):
        """
        Information about a robot software suite.
        :param 'SimulationApplicationRobotSoftwareSuiteName' name: The name of the robot software suite.
        :param 'SimulationApplicationRobotSoftwareSuiteVersion' version: The version of the robot software suite.
        """
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> 'SimulationApplicationRobotSoftwareSuiteName':
        """
        The name of the robot software suite.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional['SimulationApplicationRobotSoftwareSuiteVersion']:
        """
        The version of the robot software suite.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SimulationApplicationSimulationSoftwareSuite(dict):
    """
    Information about a simulation software suite.
    """
    def __init__(__self__, *,
                 name: 'SimulationApplicationSimulationSoftwareSuiteName',
                 version: Optional['SimulationApplicationSimulationSoftwareSuiteVersion'] = None):
        """
        Information about a simulation software suite.
        :param 'SimulationApplicationSimulationSoftwareSuiteName' name: The name of the simulation software suite.
        :param 'SimulationApplicationSimulationSoftwareSuiteVersion' version: The version of the simulation software suite.
        """
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> 'SimulationApplicationSimulationSoftwareSuiteName':
        """
        The name of the simulation software suite.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional['SimulationApplicationSimulationSoftwareSuiteVersion']:
        """
        The version of the simulation software suite.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SimulationApplicationSourceConfig(dict):
    """
    Information about a source configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3Key":
            suggest = "s3_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimulationApplicationSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimulationApplicationSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimulationApplicationSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: 'SimulationApplicationSourceConfigArchitecture',
                 s3_bucket: str,
                 s3_key: str):
        """
        Information about a source configuration.
        :param 'SimulationApplicationSourceConfigArchitecture' architecture: The target processor architecture for the application.
        :param str s3_bucket: The Amazon S3 bucket name.
        :param str s3_key: The s3 object key.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_key", s3_key)

    @property
    @pulumi.getter
    def architecture(self) -> 'SimulationApplicationSourceConfigArchitecture':
        """
        The target processor architecture for the application.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        The Amazon S3 bucket name.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> str:
        """
        The s3 object key.
        """
        return pulumi.get(self, "s3_key")


