# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    def __init__(__self__, app_arn=None, app_assessment_schedule=None, app_template_body=None, description=None, drift_status=None, event_subscriptions=None, permission_model=None, resiliency_policy_arn=None, resource_mappings=None, tags=None):
        if app_arn and not isinstance(app_arn, str):
            raise TypeError("Expected argument 'app_arn' to be a str")
        pulumi.set(__self__, "app_arn", app_arn)
        if app_assessment_schedule and not isinstance(app_assessment_schedule, str):
            raise TypeError("Expected argument 'app_assessment_schedule' to be a str")
        pulumi.set(__self__, "app_assessment_schedule", app_assessment_schedule)
        if app_template_body and not isinstance(app_template_body, str):
            raise TypeError("Expected argument 'app_template_body' to be a str")
        pulumi.set(__self__, "app_template_body", app_template_body)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if drift_status and not isinstance(drift_status, str):
            raise TypeError("Expected argument 'drift_status' to be a str")
        pulumi.set(__self__, "drift_status", drift_status)
        if event_subscriptions and not isinstance(event_subscriptions, list):
            raise TypeError("Expected argument 'event_subscriptions' to be a list")
        pulumi.set(__self__, "event_subscriptions", event_subscriptions)
        if permission_model and not isinstance(permission_model, dict):
            raise TypeError("Expected argument 'permission_model' to be a dict")
        pulumi.set(__self__, "permission_model", permission_model)
        if resiliency_policy_arn and not isinstance(resiliency_policy_arn, str):
            raise TypeError("Expected argument 'resiliency_policy_arn' to be a str")
        pulumi.set(__self__, "resiliency_policy_arn", resiliency_policy_arn)
        if resource_mappings and not isinstance(resource_mappings, list):
            raise TypeError("Expected argument 'resource_mappings' to be a list")
        pulumi.set(__self__, "resource_mappings", resource_mappings)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appArn")
    def app_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the App.
        """
        return pulumi.get(self, "app_arn")

    @property
    @pulumi.getter(name="appAssessmentSchedule")
    def app_assessment_schedule(self) -> Optional['AppAssessmentSchedule']:
        """
        Assessment execution schedule.
        """
        return pulumi.get(self, "app_assessment_schedule")

    @property
    @pulumi.getter(name="appTemplateBody")
    def app_template_body(self) -> Optional[str]:
        """
        A string containing full ResilienceHub app template body.
        """
        return pulumi.get(self, "app_template_body")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        App description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="driftStatus")
    def drift_status(self) -> Optional['AppDriftStatus']:
        """
        Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
        """
        return pulumi.get(self, "drift_status")

    @property
    @pulumi.getter(name="eventSubscriptions")
    def event_subscriptions(self) -> Optional[Sequence['outputs.AppEventSubscription']]:
        """
        The list of events you would like to subscribe and get notification for.
        """
        return pulumi.get(self, "event_subscriptions")

    @property
    @pulumi.getter(name="permissionModel")
    def permission_model(self) -> Optional['outputs.AppPermissionModel']:
        """
        Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
        """
        return pulumi.get(self, "permission_model")

    @property
    @pulumi.getter(name="resiliencyPolicyArn")
    def resiliency_policy_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the Resiliency Policy.
        """
        return pulumi.get(self, "resiliency_policy_arn")

    @property
    @pulumi.getter(name="resourceMappings")
    def resource_mappings(self) -> Optional[Sequence['outputs.AppResourceMapping']]:
        """
        An array of ResourceMapping objects.
        """
        return pulumi.get(self, "resource_mappings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags assigned to the resource. A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            app_arn=self.app_arn,
            app_assessment_schedule=self.app_assessment_schedule,
            app_template_body=self.app_template_body,
            description=self.description,
            drift_status=self.drift_status,
            event_subscriptions=self.event_subscriptions,
            permission_model=self.permission_model,
            resiliency_policy_arn=self.resiliency_policy_arn,
            resource_mappings=self.resource_mappings,
            tags=self.tags)


def get_app(app_arn: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    Resource Type Definition for AWS::ResilienceHub::App.


    :param str app_arn: Amazon Resource Name (ARN) of the App.
    """
    __args__ = dict()
    __args__['appArn'] = app_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:resiliencehub:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        app_arn=pulumi.get(__ret__, 'app_arn'),
        app_assessment_schedule=pulumi.get(__ret__, 'app_assessment_schedule'),
        app_template_body=pulumi.get(__ret__, 'app_template_body'),
        description=pulumi.get(__ret__, 'description'),
        drift_status=pulumi.get(__ret__, 'drift_status'),
        event_subscriptions=pulumi.get(__ret__, 'event_subscriptions'),
        permission_model=pulumi.get(__ret__, 'permission_model'),
        resiliency_policy_arn=pulumi.get(__ret__, 'resiliency_policy_arn'),
        resource_mappings=pulumi.get(__ret__, 'resource_mappings'),
        tags=pulumi.get(__ret__, 'tags'))
def get_app_output(app_arn: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppResult]:
    """
    Resource Type Definition for AWS::ResilienceHub::App.


    :param str app_arn: Amazon Resource Name (ARN) of the App.
    """
    __args__ = dict()
    __args__['appArn'] = app_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:resiliencehub:getApp', __args__, opts=opts, typ=GetAppResult)
    return __ret__.apply(lambda __response__: GetAppResult(
        app_arn=pulumi.get(__response__, 'app_arn'),
        app_assessment_schedule=pulumi.get(__response__, 'app_assessment_schedule'),
        app_template_body=pulumi.get(__response__, 'app_template_body'),
        description=pulumi.get(__response__, 'description'),
        drift_status=pulumi.get(__response__, 'drift_status'),
        event_subscriptions=pulumi.get(__response__, 'event_subscriptions'),
        permission_model=pulumi.get(__response__, 'permission_model'),
        resiliency_policy_arn=pulumi.get(__response__, 'resiliency_policy_arn'),
        resource_mappings=pulumi.get(__response__, 'resource_mappings'),
        tags=pulumi.get(__response__, 'tags')))
