# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationApiGatewayProxyInputArgs',
    'ApplicationApiGatewayProxyInputArgsDict',
    'RouteDefaultRouteInputArgs',
    'RouteDefaultRouteInputArgsDict',
    'RouteUriPathRouteInputArgs',
    'RouteUriPathRouteInputArgsDict',
    'ServiceLambdaEndpointInputArgs',
    'ServiceLambdaEndpointInputArgsDict',
    'ServiceUrlEndpointInputArgs',
    'ServiceUrlEndpointInputArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationApiGatewayProxyInputArgsDict(TypedDict):
        endpoint_type: NotRequired[pulumi.Input['ApplicationApiGatewayEndpointType']]
        """
        The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to `REGIONAL` by default.

        If the value is set to `PRIVATE` in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about creating a private connection with Refactor Spaces and interface endpoint ( AWS PrivateLink ) availability, see [Access Refactor Spaces using an interface endpoint ( AWS PrivateLink )](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html) .
        """
        stage_name: NotRequired[pulumi.Input[str]]
        """
        The name of the API Gateway stage. The name defaults to `prod` .
        """
elif False:
    ApplicationApiGatewayProxyInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationApiGatewayProxyInputArgs:
    def __init__(__self__, *,
                 endpoint_type: Optional[pulumi.Input['ApplicationApiGatewayEndpointType']] = None,
                 stage_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ApplicationApiGatewayEndpointType'] endpoint_type: The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to `REGIONAL` by default.
               
               If the value is set to `PRIVATE` in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about creating a private connection with Refactor Spaces and interface endpoint ( AWS PrivateLink ) availability, see [Access Refactor Spaces using an interface endpoint ( AWS PrivateLink )](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html) .
        :param pulumi.Input[str] stage_name: The name of the API Gateway stage. The name defaults to `prod` .
        """
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if stage_name is not None:
            pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input['ApplicationApiGatewayEndpointType']]:
        """
        The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to `REGIONAL` by default.

        If the value is set to `PRIVATE` in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about creating a private connection with Refactor Spaces and interface endpoint ( AWS PrivateLink ) availability, see [Access Refactor Spaces using an interface endpoint ( AWS PrivateLink )](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html) .
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input['ApplicationApiGatewayEndpointType']]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the API Gateway stage. The name defaults to `prod` .
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stage_name", value)


if not MYPY:
    class RouteDefaultRouteInputArgsDict(TypedDict):
        activation_state: pulumi.Input['RouteActivationState']
        """
        If set to `ACTIVE` , traffic is forwarded to this route’s service after the route is created.
        """
elif False:
    RouteDefaultRouteInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteDefaultRouteInputArgs:
    def __init__(__self__, *,
                 activation_state: pulumi.Input['RouteActivationState']):
        """
        :param pulumi.Input['RouteActivationState'] activation_state: If set to `ACTIVE` , traffic is forwarded to this route’s service after the route is created.
        """
        pulumi.set(__self__, "activation_state", activation_state)

    @property
    @pulumi.getter(name="activationState")
    def activation_state(self) -> pulumi.Input['RouteActivationState']:
        """
        If set to `ACTIVE` , traffic is forwarded to this route’s service after the route is created.
        """
        return pulumi.get(self, "activation_state")

    @activation_state.setter
    def activation_state(self, value: pulumi.Input['RouteActivationState']):
        pulumi.set(self, "activation_state", value)


if not MYPY:
    class RouteUriPathRouteInputArgsDict(TypedDict):
        activation_state: pulumi.Input['RouteActivationState']
        """
        If set to `ACTIVE` , traffic is forwarded to this route’s service after the route is created.
        """
        append_source_path: NotRequired[pulumi.Input[bool]]
        """
        If set to `true` , this option appends the source path to the service URL endpoint.
        """
        include_child_paths: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to match all subpaths of the given source path. If this value is `false` , requests must match the source path exactly before they are forwarded to this route's service.
        """
        methods: NotRequired[pulumi.Input[Sequence[pulumi.Input['RouteMethod']]]]
        """
        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service.
        """
        source_path: NotRequired[pulumi.Input[str]]
        """
        This is the path that Refactor Spaces uses to match traffic. Paths must start with `/` and are relative to the base of the application. To use path parameters in the source path, add a variable in curly braces. For example, the resource path {user} represents a path parameter called 'user'.
        """
elif False:
    RouteUriPathRouteInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteUriPathRouteInputArgs:
    def __init__(__self__, *,
                 activation_state: pulumi.Input['RouteActivationState'],
                 append_source_path: Optional[pulumi.Input[bool]] = None,
                 include_child_paths: Optional[pulumi.Input[bool]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input['RouteMethod']]]] = None,
                 source_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['RouteActivationState'] activation_state: If set to `ACTIVE` , traffic is forwarded to this route’s service after the route is created.
        :param pulumi.Input[bool] append_source_path: If set to `true` , this option appends the source path to the service URL endpoint.
        :param pulumi.Input[bool] include_child_paths: Indicates whether to match all subpaths of the given source path. If this value is `false` , requests must match the source path exactly before they are forwarded to this route's service.
        :param pulumi.Input[Sequence[pulumi.Input['RouteMethod']]] methods: A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service.
        :param pulumi.Input[str] source_path: This is the path that Refactor Spaces uses to match traffic. Paths must start with `/` and are relative to the base of the application. To use path parameters in the source path, add a variable in curly braces. For example, the resource path {user} represents a path parameter called 'user'.
        """
        pulumi.set(__self__, "activation_state", activation_state)
        if append_source_path is not None:
            pulumi.set(__self__, "append_source_path", append_source_path)
        if include_child_paths is not None:
            pulumi.set(__self__, "include_child_paths", include_child_paths)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="activationState")
    def activation_state(self) -> pulumi.Input['RouteActivationState']:
        """
        If set to `ACTIVE` , traffic is forwarded to this route’s service after the route is created.
        """
        return pulumi.get(self, "activation_state")

    @activation_state.setter
    def activation_state(self, value: pulumi.Input['RouteActivationState']):
        pulumi.set(self, "activation_state", value)

    @property
    @pulumi.getter(name="appendSourcePath")
    def append_source_path(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true` , this option appends the source path to the service URL endpoint.
        """
        return pulumi.get(self, "append_source_path")

    @append_source_path.setter
    def append_source_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append_source_path", value)

    @property
    @pulumi.getter(name="includeChildPaths")
    def include_child_paths(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to match all subpaths of the given source path. If this value is `false` , requests must match the source path exactly before they are forwarded to this route's service.
        """
        return pulumi.get(self, "include_child_paths")

    @include_child_paths.setter
    def include_child_paths(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_child_paths", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteMethod']]]]:
        """
        A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service.
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteMethod']]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[pulumi.Input[str]]:
        """
        This is the path that Refactor Spaces uses to match traffic. Paths must start with `/` and are relative to the base of the application. To use path parameters in the source path, add a variable in curly braces. For example, the resource path {user} represents a path parameter called 'user'.
        """
        return pulumi.get(self, "source_path")

    @source_path.setter
    def source_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_path", value)


if not MYPY:
    class ServiceLambdaEndpointInputArgsDict(TypedDict):
        arn: pulumi.Input[str]
        """
        The Amazon Resource Name (ARN) of the Lambda function or alias.
        """
elif False:
    ServiceLambdaEndpointInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLambdaEndpointInputArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the Lambda function or alias.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the Lambda function or alias.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class ServiceUrlEndpointInputArgsDict(TypedDict):
        url: pulumi.Input[str]
        """
        The URL to route traffic to. The URL must be an [rfc3986-formatted URL](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc3986) . If the host is a domain name, the name must be resolvable over the public internet. If the scheme is `https` , the top level domain of the host must be listed in the [IANA root zone database](https://docs.aws.amazon.com/https://www.iana.org/domains/root/db) .
        """
        health_url: NotRequired[pulumi.Input[str]]
        """
        The health check URL of the URL endpoint type. If the URL is a public endpoint, the `HealthUrl` must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.
        """
elif False:
    ServiceUrlEndpointInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceUrlEndpointInputArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 health_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: The URL to route traffic to. The URL must be an [rfc3986-formatted URL](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc3986) . If the host is a domain name, the name must be resolvable over the public internet. If the scheme is `https` , the top level domain of the host must be listed in the [IANA root zone database](https://docs.aws.amazon.com/https://www.iana.org/domains/root/db) .
        :param pulumi.Input[str] health_url: The health check URL of the URL endpoint type. If the URL is a public endpoint, the `HealthUrl` must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.
        """
        pulumi.set(__self__, "url", url)
        if health_url is not None:
            pulumi.set(__self__, "health_url", health_url)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to route traffic to. The URL must be an [rfc3986-formatted URL](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc3986) . If the host is a domain name, the name must be resolvable over the public internet. If the scheme is `https` , the top level domain of the host must be listed in the [IANA root zone database](https://docs.aws.amazon.com/https://www.iana.org/domains/root/db) .
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="healthUrl")
    def health_url(self) -> Optional[pulumi.Input[str]]:
        """
        The health check URL of the URL endpoint type. If the URL is a public endpoint, the `HealthUrl` must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.
        """
        return pulumi.get(self, "health_url")

    @health_url.setter
    def health_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_url", value)


