# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['WorkgroupArgs', 'Workgroup']

@pulumi.input_type
class WorkgroupArgs:
    def __init__(__self__, *,
                 base_capacity: Optional[pulumi.Input[int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Workgroup resource.
        :param pulumi.Input[int] base_capacity: The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]] config_parameters: A list of parameters to set for finer control over a database. Available options are datestyle, enable_user_activity_logging, query_group, search_path, max_query_execution_time, and require_ssl.
        :param pulumi.Input[bool] enhanced_vpc_routing: The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        :param pulumi.Input[int] max_capacity: The max compute capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[str] namespace_name: The namespace the workgroup is associated with.
        :param pulumi.Input[int] port: The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
        :param pulumi.Input[bool] publicly_accessible: A value that specifies whether the workgroup can be accessible from a public network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group IDs to associate with the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs the workgroup is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The map of the key-value pairs used to tag the workgroup.
        :param pulumi.Input[str] workgroup_name: The name of the workgroup.
        """
        if base_capacity is not None:
            pulumi.set(__self__, "base_capacity", base_capacity)
        if config_parameters is not None:
            pulumi.set(__self__, "config_parameters", config_parameters)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base_capacity", value)

    @property
    @pulumi.getter(name="configParameters")
    def config_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]:
        """
        A list of parameters to set for finer control over a database. Available options are datestyle, enable_user_activity_logging, query_group, search_path, max_query_execution_time, and require_ssl.
        """
        return pulumi.get(self, "config_parameters")

    @config_parameters.setter
    def config_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]):
        pulumi.set(self, "config_parameters", value)

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[bool]]:
        """
        The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The max compute capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace the workgroup is associated with.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that specifies whether the workgroup can be accessible from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to associate with the workgroup.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnet IDs the workgroup is associated with.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The map of the key-value pairs used to tag the workgroup.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workgroup.
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup_name", value)


class Workgroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::RedshiftServerless::Workgroup Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] base_capacity: The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]] config_parameters: A list of parameters to set for finer control over a database. Available options are datestyle, enable_user_activity_logging, query_group, search_path, max_query_execution_time, and require_ssl.
        :param pulumi.Input[bool] enhanced_vpc_routing: The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        :param pulumi.Input[int] max_capacity: The max compute capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[str] namespace_name: The namespace the workgroup is associated with.
        :param pulumi.Input[int] port: The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
        :param pulumi.Input[bool] publicly_accessible: A value that specifies whether the workgroup can be accessible from a public network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group IDs to associate with the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs the workgroup is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The map of the key-value pairs used to tag the workgroup.
        :param pulumi.Input[str] workgroup_name: The name of the workgroup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WorkgroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::RedshiftServerless::Workgroup Resource Type

        :param str resource_name: The name of the resource.
        :param WorkgroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkgroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkgroupArgs.__new__(WorkgroupArgs)

            __props__.__dict__["base_capacity"] = base_capacity
            __props__.__dict__["config_parameters"] = config_parameters
            __props__.__dict__["enhanced_vpc_routing"] = enhanced_vpc_routing
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["port"] = port
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workgroup_name"] = workgroup_name
            __props__.__dict__["workgroup"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["namespaceName", "workgroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Workgroup, __self__).__init__(
            'aws-native:redshiftserverless:Workgroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Workgroup':
        """
        Get an existing Workgroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkgroupArgs.__new__(WorkgroupArgs)

        __props__.__dict__["base_capacity"] = None
        __props__.__dict__["config_parameters"] = None
        __props__.__dict__["enhanced_vpc_routing"] = None
        __props__.__dict__["max_capacity"] = None
        __props__.__dict__["namespace_name"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["subnet_ids"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["workgroup"] = None
        __props__.__dict__["workgroup_name"] = None
        return Workgroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "base_capacity")

    @property
    @pulumi.getter(name="configParameters")
    def config_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.WorkgroupConfigParameter']]]:
        """
        A list of parameters to set for finer control over a database. Available options are datestyle, enable_user_activity_logging, query_group, search_path, max_query_execution_time, and require_ssl.
        """
        return pulumi.get(self, "config_parameters")

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> pulumi.Output[Optional[bool]]:
        """
        The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The max compute capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace the workgroup is associated with.
        """
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that specifies whether the workgroup can be accessible from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of security group IDs to associate with the workgroup.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of subnet IDs the workgroup is associated with.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The map of the key-value pairs used to tag the workgroup.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def workgroup(self) -> pulumi.Output['outputs.Workgroup']:
        """
        Definition for workgroup resource
        """
        return pulumi.get(self, "workgroup")

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> pulumi.Output[str]:
        """
        The name of the workgroup.
        """
        return pulumi.get(self, "workgroup_name")

