# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetNamespaceResult',
    'AwaitableGetNamespaceResult',
    'get_namespace',
    'get_namespace_output',
]

@pulumi.output_type
class GetNamespaceResult:
    def __init__(__self__, admin_password_secret_kms_key_id=None, admin_username=None, db_name=None, default_iam_role_arn=None, iam_roles=None, kms_key_id=None, log_exports=None, namespace=None, namespace_resource_policy=None, snapshot_copy_configurations=None):
        if admin_password_secret_kms_key_id and not isinstance(admin_password_secret_kms_key_id, str):
            raise TypeError("Expected argument 'admin_password_secret_kms_key_id' to be a str")
        pulumi.set(__self__, "admin_password_secret_kms_key_id", admin_password_secret_kms_key_id)
        if admin_username and not isinstance(admin_username, str):
            raise TypeError("Expected argument 'admin_username' to be a str")
        pulumi.set(__self__, "admin_username", admin_username)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if default_iam_role_arn and not isinstance(default_iam_role_arn, str):
            raise TypeError("Expected argument 'default_iam_role_arn' to be a str")
        pulumi.set(__self__, "default_iam_role_arn", default_iam_role_arn)
        if iam_roles and not isinstance(iam_roles, list):
            raise TypeError("Expected argument 'iam_roles' to be a list")
        pulumi.set(__self__, "iam_roles", iam_roles)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_exports and not isinstance(log_exports, list):
            raise TypeError("Expected argument 'log_exports' to be a list")
        pulumi.set(__self__, "log_exports", log_exports)
        if namespace and not isinstance(namespace, dict):
            raise TypeError("Expected argument 'namespace' to be a dict")
        pulumi.set(__self__, "namespace", namespace)
        if namespace_resource_policy and not isinstance(namespace_resource_policy, dict):
            raise TypeError("Expected argument 'namespace_resource_policy' to be a dict")
        pulumi.set(__self__, "namespace_resource_policy", namespace_resource_policy)
        if snapshot_copy_configurations and not isinstance(snapshot_copy_configurations, list):
            raise TypeError("Expected argument 'snapshot_copy_configurations' to be a list")
        pulumi.set(__self__, "snapshot_copy_configurations", snapshot_copy_configurations)

    @property
    @pulumi.getter(name="adminPasswordSecretKmsKeyId")
    def admin_password_secret_kms_key_id(self) -> Optional[str]:
        """
        The ID of the AWS Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret. You can only use this parameter if manageAdminPassword is true.
        """
        return pulumi.get(self, "admin_password_secret_kms_key_id")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        The user name associated with the admin user for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        The database name associated for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> Optional[str]:
        """
        The default IAM role ARN for the namespace that is being created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Optional[Sequence[str]]:
        """
        A list of AWS Identity and Access Management (IAM) roles that can be used by the namespace to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. The Default role limit for each request is 10.
        """
        return pulumi.get(self, "iam_roles")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the namespace.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Optional[Sequence['NamespaceLogExport']]:
        """
        The collection of log types to be exported provided by the customer. Should only be one of the three supported log types: userlog, useractivitylog and connectionlog
        """
        return pulumi.get(self, "log_exports")

    @property
    @pulumi.getter
    def namespace(self) -> Optional['outputs.Namespace']:
        """
        Definition of Namespace resource.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="namespaceResourcePolicy")
    def namespace_resource_policy(self) -> Optional[Any]:
        """
        The resource policy document that will be attached to the namespace.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RedshiftServerless::Namespace` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "namespace_resource_policy")

    @property
    @pulumi.getter(name="snapshotCopyConfigurations")
    def snapshot_copy_configurations(self) -> Optional[Sequence['outputs.NamespaceSnapshotCopyConfiguration']]:
        """
        The snapshot copy configurations for the namespace.
        """
        return pulumi.get(self, "snapshot_copy_configurations")


class AwaitableGetNamespaceResult(GetNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceResult(
            admin_password_secret_kms_key_id=self.admin_password_secret_kms_key_id,
            admin_username=self.admin_username,
            db_name=self.db_name,
            default_iam_role_arn=self.default_iam_role_arn,
            iam_roles=self.iam_roles,
            kms_key_id=self.kms_key_id,
            log_exports=self.log_exports,
            namespace=self.namespace,
            namespace_resource_policy=self.namespace_resource_policy,
            snapshot_copy_configurations=self.snapshot_copy_configurations)


def get_namespace(namespace_name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceResult:
    """
    Definition of AWS::RedshiftServerless::Namespace Resource Type


    :param str namespace_name: A unique identifier for the namespace. You use this identifier to refer to the namespace for any subsequent namespace operations such as deleting or modifying. All alphabetical characters must be lower case. Namespace name should be unique for all namespaces within an AWS account.
    """
    __args__ = dict()
    __args__['namespaceName'] = namespace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:redshiftserverless:getNamespace', __args__, opts=opts, typ=GetNamespaceResult).value

    return AwaitableGetNamespaceResult(
        admin_password_secret_kms_key_id=pulumi.get(__ret__, 'admin_password_secret_kms_key_id'),
        admin_username=pulumi.get(__ret__, 'admin_username'),
        db_name=pulumi.get(__ret__, 'db_name'),
        default_iam_role_arn=pulumi.get(__ret__, 'default_iam_role_arn'),
        iam_roles=pulumi.get(__ret__, 'iam_roles'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        log_exports=pulumi.get(__ret__, 'log_exports'),
        namespace=pulumi.get(__ret__, 'namespace'),
        namespace_resource_policy=pulumi.get(__ret__, 'namespace_resource_policy'),
        snapshot_copy_configurations=pulumi.get(__ret__, 'snapshot_copy_configurations'))
def get_namespace_output(namespace_name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespaceResult]:
    """
    Definition of AWS::RedshiftServerless::Namespace Resource Type


    :param str namespace_name: A unique identifier for the namespace. You use this identifier to refer to the namespace for any subsequent namespace operations such as deleting or modifying. All alphabetical characters must be lower case. Namespace name should be unique for all namespaces within an AWS account.
    """
    __args__ = dict()
    __args__['namespaceName'] = namespace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:redshiftserverless:getNamespace', __args__, opts=opts, typ=GetNamespaceResult)
    return __ret__.apply(lambda __response__: GetNamespaceResult(
        admin_password_secret_kms_key_id=pulumi.get(__response__, 'admin_password_secret_kms_key_id'),
        admin_username=pulumi.get(__response__, 'admin_username'),
        db_name=pulumi.get(__response__, 'db_name'),
        default_iam_role_arn=pulumi.get(__response__, 'default_iam_role_arn'),
        iam_roles=pulumi.get(__response__, 'iam_roles'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        log_exports=pulumi.get(__response__, 'log_exports'),
        namespace=pulumi.get(__response__, 'namespace'),
        namespace_resource_policy=pulumi.get(__response__, 'namespace_resource_policy'),
        snapshot_copy_configurations=pulumi.get(__response__, 'snapshot_copy_configurations')))
