# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'NamespaceSnapshotCopyConfigurationArgs',
    'NamespaceSnapshotCopyConfigurationArgsDict',
    'WorkgroupConfigParameterArgs',
    'WorkgroupConfigParameterArgsDict',
]

MYPY = False

if not MYPY:
    class NamespaceSnapshotCopyConfigurationArgsDict(TypedDict):
        destination_region: pulumi.Input[str]
        """
        The destination AWS Region to copy snapshots to.
        """
        destination_kms_key_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
        """
        snapshot_retention_period: NotRequired[pulumi.Input[int]]
        """
        The retention period of snapshots that are copied to the destination AWS Region .
        """
elif False:
    NamespaceSnapshotCopyConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NamespaceSnapshotCopyConfigurationArgs:
    def __init__(__self__, *,
                 destination_region: pulumi.Input[str],
                 destination_kms_key_id: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_period: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] destination_region: The destination AWS Region to copy snapshots to.
        :param pulumi.Input[str] destination_kms_key_id: The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
        :param pulumi.Input[int] snapshot_retention_period: The retention period of snapshots that are copied to the destination AWS Region .
        """
        pulumi.set(__self__, "destination_region", destination_region)
        if destination_kms_key_id is not None:
            pulumi.set(__self__, "destination_kms_key_id", destination_kms_key_id)
        if snapshot_retention_period is not None:
            pulumi.set(__self__, "snapshot_retention_period", snapshot_retention_period)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Input[str]:
        """
        The destination AWS Region to copy snapshots to.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="destinationKmsKeyId")
    def destination_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
        """
        return pulumi.get(self, "destination_kms_key_id")

    @destination_kms_key_id.setter
    def destination_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_kms_key_id", value)

    @property
    @pulumi.getter(name="snapshotRetentionPeriod")
    def snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period of snapshots that are copied to the destination AWS Region .
        """
        return pulumi.get(self, "snapshot_retention_period")

    @snapshot_retention_period.setter
    def snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_period", value)


if not MYPY:
    class WorkgroupConfigParameterArgsDict(TypedDict):
        parameter_key: NotRequired[pulumi.Input[str]]
        """
        The key of the parameter. The options are `datestyle` , `enable_user_activity_logging` , `query_group` , `search_path` , `max_query_execution_time` , and `require_ssl` .
        """
        parameter_value: NotRequired[pulumi.Input[str]]
        """
        The value of the parameter to set.
        """
elif False:
    WorkgroupConfigParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupConfigParameterArgs:
    def __init__(__self__, *,
                 parameter_key: Optional[pulumi.Input[str]] = None,
                 parameter_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] parameter_key: The key of the parameter. The options are `datestyle` , `enable_user_activity_logging` , `query_group` , `search_path` , `max_query_execution_time` , and `require_ssl` .
        :param pulumi.Input[str] parameter_value: The value of the parameter to set.
        """
        if parameter_key is not None:
            pulumi.set(__self__, "parameter_key", parameter_key)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the parameter. The options are `datestyle` , `enable_user_activity_logging` , `query_group` , `search_path` , `max_query_execution_time` , and `require_ssl` .
        """
        return pulumi.get(self, "parameter_key")

    @parameter_key.setter
    def parameter_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_key", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the parameter to set.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_value", value)


