# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetClusterSubnetGroupResult',
    'AwaitableGetClusterSubnetGroupResult',
    'get_cluster_subnet_group',
    'get_cluster_subnet_group_output',
]

@pulumi.output_type
class GetClusterSubnetGroupResult:
    def __init__(__self__, cluster_subnet_group_name=None, description=None, subnet_ids=None):
        if cluster_subnet_group_name and not isinstance(cluster_subnet_group_name, str):
            raise TypeError("Expected argument 'cluster_subnet_group_name' to be a str")
        pulumi.set(__self__, "cluster_subnet_group_name", cluster_subnet_group_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> Optional[str]:
        """
        This name must be unique for all subnet groups that are created by your AWS account. If costumer do not provide it, cloudformation will generate it. Must not be "Default". 
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the parameter group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        The list of VPC subnet IDs
        """
        return pulumi.get(self, "subnet_ids")


class AwaitableGetClusterSubnetGroupResult(GetClusterSubnetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterSubnetGroupResult(
            cluster_subnet_group_name=self.cluster_subnet_group_name,
            description=self.description,
            subnet_ids=self.subnet_ids)


def get_cluster_subnet_group(cluster_subnet_group_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterSubnetGroupResult:
    """
    Specifies an Amazon Redshift subnet group.


    :param str cluster_subnet_group_name: This name must be unique for all subnet groups that are created by your AWS account. If costumer do not provide it, cloudformation will generate it. Must not be "Default". 
    """
    __args__ = dict()
    __args__['clusterSubnetGroupName'] = cluster_subnet_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:redshift:getClusterSubnetGroup', __args__, opts=opts, typ=GetClusterSubnetGroupResult).value

    return AwaitableGetClusterSubnetGroupResult(
        cluster_subnet_group_name=pulumi.get(__ret__, 'cluster_subnet_group_name'),
        description=pulumi.get(__ret__, 'description'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'))
def get_cluster_subnet_group_output(cluster_subnet_group_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterSubnetGroupResult]:
    """
    Specifies an Amazon Redshift subnet group.


    :param str cluster_subnet_group_name: This name must be unique for all subnet groups that are created by your AWS account. If costumer do not provide it, cloudformation will generate it. Must not be "Default". 
    """
    __args__ = dict()
    __args__['clusterSubnetGroupName'] = cluster_subnet_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:redshift:getClusterSubnetGroup', __args__, opts=opts, typ=GetClusterSubnetGroupResult)
    return __ret__.apply(lambda __response__: GetClusterSubnetGroupResult(
        cluster_subnet_group_name=pulumi.get(__response__, 'cluster_subnet_group_name'),
        description=pulumi.get(__response__, 'description'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids')))
