# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ClusterEndpointArgs',
    'ClusterEndpointArgsDict',
    'ClusterLoggingPropertiesArgs',
    'ClusterLoggingPropertiesArgsDict',
    'ClusterParameterGroupParameterArgs',
    'ClusterParameterGroupParameterArgsDict',
    'ScheduledActionTypeArgs',
    'ScheduledActionTypeArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[str]]
        """
        The DNS address of the cluster. This property is read only.
        """
        port: NotRequired[pulumi.Input[str]]
        """
        The port that the database engine is listening on. This property is read only.
        """
elif False:
    ClusterEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The DNS address of the cluster. This property is read only.
        :param pulumi.Input[str] port: The port that the database engine is listening on. This property is read only.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS address of the cluster. This property is read only.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port that the database engine is listening on. This property is read only.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ClusterLoggingPropertiesArgsDict(TypedDict):
        bucket_name: NotRequired[pulumi.Input[str]]
        """
        The name of an existing S3 bucket where the log files are to be stored.

        Constraints:

        - Must be in the same region as the cluster
        - The cluster must have read bucket and put object permissions
        """
        log_destination_type: NotRequired[pulumi.Input[str]]
        """
        The log destination type. An enum with possible values of `s3` and `cloudwatch` .
        """
        log_exports: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The collection of exported log types. Possible values are `connectionlog` , `useractivitylog` , and `userlog` .
        """
        s3_key_prefix: NotRequired[pulumi.Input[str]]
        """
        The prefix applied to the log file names.

        Constraints:

        - Cannot exceed 512 characters
        - Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\\), or control characters. The hexadecimal codes for invalid characters are:

        - x00 to x20
        - x22
        - x27
        - x5c
        - x7f or larger
        """
elif False:
    ClusterLoggingPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterLoggingPropertiesArgs:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 log_destination_type: Optional[pulumi.Input[str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The name of an existing S3 bucket where the log files are to be stored.
               
               Constraints:
               
               - Must be in the same region as the cluster
               - The cluster must have read bucket and put object permissions
        :param pulumi.Input[str] log_destination_type: The log destination type. An enum with possible values of `s3` and `cloudwatch` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_exports: The collection of exported log types. Possible values are `connectionlog` , `useractivitylog` , and `userlog` .
        :param pulumi.Input[str] s3_key_prefix: The prefix applied to the log file names.
               
               Constraints:
               
               - Cannot exceed 512 characters
               - Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\\), or control characters. The hexadecimal codes for invalid characters are:
               
               - x00 to x20
               - x22
               - x27
               - x5c
               - x7f or larger
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if log_destination_type is not None:
            pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_exports is not None:
            pulumi.set(__self__, "log_exports", log_exports)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing S3 bucket where the log files are to be stored.

        Constraints:

        - Must be in the same region as the cluster
        - The cluster must have read bucket and put object permissions
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log destination type. An enum with possible values of `s3` and `cloudwatch` .
        """
        return pulumi.get(self, "log_destination_type")

    @log_destination_type.setter
    def log_destination_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_destination_type", value)

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of exported log types. Possible values are `connectionlog` , `useractivitylog` , and `userlog` .
        """
        return pulumi.get(self, "log_exports")

    @log_exports.setter
    def log_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_exports", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix applied to the log file names.

        Constraints:

        - Cannot exceed 512 characters
        - Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\\), or control characters. The hexadecimal codes for invalid characters are:

        - x00 to x20
        - x22
        - x27
        - x5c
        - x7f or larger
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_prefix", value)


if not MYPY:
    class ClusterParameterGroupParameterArgsDict(TypedDict):
        parameter_name: pulumi.Input[str]
        """
        The name of the parameter.
        """
        parameter_value: pulumi.Input[str]
        """
        The value of the parameter. If `ParameterName` is `wlm_json_configuration`, then the maximum size of `ParameterValue` is 8000 characters.
        """
elif False:
    ClusterParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterParameterGroupParameterArgs:
    def __init__(__self__, *,
                 parameter_name: pulumi.Input[str],
                 parameter_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] parameter_name: The name of the parameter.
        :param pulumi.Input[str] parameter_value: The value of the parameter. If `ParameterName` is `wlm_json_configuration`, then the maximum size of `ParameterValue` is 8000 characters.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> pulumi.Input[str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[str]:
        """
        The value of the parameter. If `ParameterName` is `wlm_json_configuration`, then the maximum size of `ParameterValue` is 8000 characters.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class ScheduledActionTypeArgsDict(TypedDict):
        pass
elif False:
    ScheduledActionTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledActionTypeArgs:
    def __init__(__self__):
        pass


