# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetOptionGroupResult',
    'AwaitableGetOptionGroupResult',
    'get_option_group',
    'get_option_group_output',
]

@pulumi.output_type
class GetOptionGroupResult:
    def __init__(__self__, option_configurations=None, tags=None):
        if option_configurations and not isinstance(option_configurations, list):
            raise TypeError("Expected argument 'option_configurations' to be a list")
        pulumi.set(__self__, "option_configurations", option_configurations)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="optionConfigurations")
    def option_configurations(self) -> Optional[Sequence['outputs.OptionGroupOptionConfiguration']]:
        """
        A list of all available options for an option group.
        """
        return pulumi.get(self, "option_configurations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags to assign to the option group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetOptionGroupResult(GetOptionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOptionGroupResult(
            option_configurations=self.option_configurations,
            tags=self.tags)


def get_option_group(option_group_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOptionGroupResult:
    """
    The ``AWS::RDS::OptionGroup`` resource creates or updates an option group, to enable and configure features that are specific to a particular DB engine.


    :param str option_group_name: The name of the option group to be created.
            Constraints:
             +  Must be 1 to 255 letters, numbers, or hyphens
             +  First character must be a letter
             +  Can't end with a hyphen or contain two consecutive hyphens
             
            Example: ``myoptiongroup`` 
            If you don't specify a value for ``OptionGroupName`` property, a name is automatically created for the option group.
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['optionGroupName'] = option_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getOptionGroup', __args__, opts=opts, typ=GetOptionGroupResult).value

    return AwaitableGetOptionGroupResult(
        option_configurations=pulumi.get(__ret__, 'option_configurations'),
        tags=pulumi.get(__ret__, 'tags'))
def get_option_group_output(option_group_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOptionGroupResult]:
    """
    The ``AWS::RDS::OptionGroup`` resource creates or updates an option group, to enable and configure features that are specific to a particular DB engine.


    :param str option_group_name: The name of the option group to be created.
            Constraints:
             +  Must be 1 to 255 letters, numbers, or hyphens
             +  First character must be a letter
             +  Can't end with a hyphen or contain two consecutive hyphens
             
            Example: ``myoptiongroup`` 
            If you don't specify a value for ``OptionGroupName`` property, a name is automatically created for the option group.
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['optionGroupName'] = option_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getOptionGroup', __args__, opts=opts, typ=GetOptionGroupResult)
    return __ret__.apply(lambda __response__: GetOptionGroupResult(
        option_configurations=pulumi.get(__response__, 'option_configurations'),
        tags=pulumi.get(__response__, 'tags')))
