# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetIntegrationResult',
    'AwaitableGetIntegrationResult',
    'get_integration',
    'get_integration_output',
]

@pulumi.output_type
class GetIntegrationResult:
    def __init__(__self__, create_time=None, data_filter=None, description=None, integration_arn=None, integration_name=None, tags=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_filter and not isinstance(data_filter, str):
            raise TypeError("Expected argument 'data_filter' to be a str")
        pulumi.set(__self__, "data_filter", data_filter)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if integration_arn and not isinstance(integration_arn, str):
            raise TypeError("Expected argument 'integration_arn' to be a str")
        pulumi.set(__self__, "integration_arn", integration_arn)
        if integration_name and not isinstance(integration_name, str):
            raise TypeError("Expected argument 'integration_name' to be a str")
        pulumi.set(__self__, "integration_name", integration_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        The time when the integration was created, in Universal Coordinated Time (UTC).
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataFilter")
    def data_filter(self) -> Optional[str]:
        """
        Data filters for the integration. These filters determine which tables from the source database are sent to the target Amazon Redshift data warehouse.
        """
        return pulumi.get(self, "data_filter")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the integration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="integrationArn")
    def integration_arn(self) -> Optional[str]:
        """
        The ARN of the integration.
        """
        return pulumi.get(self, "integration_arn")

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> Optional[str]:
        """
        The name of the integration.
        """
        return pulumi.get(self, "integration_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIntegrationResult(GetIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIntegrationResult(
            create_time=self.create_time,
            data_filter=self.data_filter,
            description=self.description,
            integration_arn=self.integration_arn,
            integration_name=self.integration_name,
            tags=self.tags)


def get_integration(integration_arn: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIntegrationResult:
    """
    A zero-ETL integration with Amazon Redshift.


    :param str integration_arn: The ARN of the integration.
    """
    __args__ = dict()
    __args__['integrationArn'] = integration_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getIntegration', __args__, opts=opts, typ=GetIntegrationResult).value

    return AwaitableGetIntegrationResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        data_filter=pulumi.get(__ret__, 'data_filter'),
        description=pulumi.get(__ret__, 'description'),
        integration_arn=pulumi.get(__ret__, 'integration_arn'),
        integration_name=pulumi.get(__ret__, 'integration_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_integration_output(integration_arn: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIntegrationResult]:
    """
    A zero-ETL integration with Amazon Redshift.


    :param str integration_arn: The ARN of the integration.
    """
    __args__ = dict()
    __args__['integrationArn'] = integration_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getIntegration', __args__, opts=opts, typ=GetIntegrationResult)
    return __ret__.apply(lambda __response__: GetIntegrationResult(
        create_time=pulumi.get(__response__, 'create_time'),
        data_filter=pulumi.get(__response__, 'data_filter'),
        description=pulumi.get(__response__, 'description'),
        integration_arn=pulumi.get(__response__, 'integration_arn'),
        integration_name=pulumi.get(__response__, 'integration_name'),
        tags=pulumi.get(__response__, 'tags')))
