# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetGlobalClusterResult',
    'AwaitableGetGlobalClusterResult',
    'get_global_cluster',
    'get_global_cluster_output',
]

@pulumi.output_type
class GetGlobalClusterResult:
    def __init__(__self__, deletion_protection=None, engine_lifecycle_support=None, engine_version=None, tags=None):
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if engine_lifecycle_support and not isinstance(engine_lifecycle_support, str):
            raise TypeError("Expected argument 'engine_lifecycle_support' to be a str")
        pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[bool]:
        """
        The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[str]:
        """
        The life cycle type of the global cluster. You can use this setting to enroll your global cluster into Amazon RDS Extended Support.
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[str]:
        """
        The version number of the database engine to use. If you specify the SourceDBClusterIdentifier property, don't specify this property. The value is inherited from the cluster.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGlobalClusterResult(GetGlobalClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalClusterResult(
            deletion_protection=self.deletion_protection,
            engine_lifecycle_support=self.engine_lifecycle_support,
            engine_version=self.engine_version,
            tags=self.tags)


def get_global_cluster(global_cluster_identifier: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalClusterResult:
    """
    Resource Type definition for AWS::RDS::GlobalCluster


    :param str global_cluster_identifier: The cluster identifier of the new global database cluster. This parameter is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['globalClusterIdentifier'] = global_cluster_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getGlobalCluster', __args__, opts=opts, typ=GetGlobalClusterResult).value

    return AwaitableGetGlobalClusterResult(
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        engine_lifecycle_support=pulumi.get(__ret__, 'engine_lifecycle_support'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        tags=pulumi.get(__ret__, 'tags'))
def get_global_cluster_output(global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGlobalClusterResult]:
    """
    Resource Type definition for AWS::RDS::GlobalCluster


    :param str global_cluster_identifier: The cluster identifier of the new global database cluster. This parameter is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['globalClusterIdentifier'] = global_cluster_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getGlobalCluster', __args__, opts=opts, typ=GetGlobalClusterResult)
    return __ret__.apply(lambda __response__: GetGlobalClusterResult(
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        engine_lifecycle_support=pulumi.get(__response__, 'engine_lifecycle_support'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        tags=pulumi.get(__response__, 'tags')))
