# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDbParameterGroupResult',
    'AwaitableGetDbParameterGroupResult',
    'get_db_parameter_group',
    'get_db_parameter_group_output',
]

@pulumi.output_type
class GetDbParameterGroupResult:
    def __init__(__self__, parameters=None, tags=None):
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        An array of parameter names and values for the parameter update. You must specify at least one parameter name and value.
         For more information about parameter groups, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*, or [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
           AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBParameterGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags to assign to the DB parameter group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDbParameterGroupResult(GetDbParameterGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbParameterGroupResult(
            parameters=self.parameters,
            tags=self.tags)


def get_db_parameter_group(db_parameter_group_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbParameterGroupResult:
    """
    The ``AWS::RDS::DBParameterGroup`` resource creates a custom parameter group for an RDS database family.
     This type can be declared in a template and referenced in the ``DBParameterGroupName`` property of an ``AWS::RDS::DBInstance`` resource.
     For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
     For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
      Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.


    :param str db_parameter_group_name: The name of the DB parameter group.
            Constraints:
             +  Must be 1 to 255 letters, numbers, or hyphens.
             +  First character must be a letter
             +  Can't end with a hyphen or contain two consecutive hyphens
             
            If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['dbParameterGroupName'] = db_parameter_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbParameterGroup', __args__, opts=opts, typ=GetDbParameterGroupResult).value

    return AwaitableGetDbParameterGroupResult(
        parameters=pulumi.get(__ret__, 'parameters'),
        tags=pulumi.get(__ret__, 'tags'))
def get_db_parameter_group_output(db_parameter_group_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbParameterGroupResult]:
    """
    The ``AWS::RDS::DBParameterGroup`` resource creates a custom parameter group for an RDS database family.
     This type can be declared in a template and referenced in the ``DBParameterGroupName`` property of an ``AWS::RDS::DBInstance`` resource.
     For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
     For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
      Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.


    :param str db_parameter_group_name: The name of the DB parameter group.
            Constraints:
             +  Must be 1 to 255 letters, numbers, or hyphens.
             +  First character must be a letter
             +  Can't end with a hyphen or contain two consecutive hyphens
             
            If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['dbParameterGroupName'] = db_parameter_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getDbParameterGroup', __args__, opts=opts, typ=GetDbParameterGroupResult)
    return __ret__.apply(lambda __response__: GetDbParameterGroupResult(
        parameters=pulumi.get(__response__, 'parameters'),
        tags=pulumi.get(__response__, 'tags')))
