# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDbInstanceResult',
    'AwaitableGetDbInstanceResult',
    'get_db_instance',
    'get_db_instance_output',
]

@pulumi.output_type
class GetDbInstanceResult:
    def __init__(__self__, allocated_storage=None, associated_roles=None, auto_minor_version_upgrade=None, automatic_backup_replication_region=None, availability_zone=None, backup_retention_period=None, ca_certificate_identifier=None, certificate_details=None, copy_tags_to_snapshot=None, db_cluster_snapshot_identifier=None, db_instance_arn=None, db_instance_class=None, db_parameter_group_name=None, db_security_groups=None, db_system_id=None, dbi_resource_id=None, dedicated_log_volume=None, deletion_protection=None, domain=None, domain_auth_secret_arn=None, domain_dns_ips=None, domain_fqdn=None, domain_iam_role_name=None, domain_ou=None, enable_cloudwatch_logs_exports=None, enable_iam_database_authentication=None, enable_performance_insights=None, endpoint=None, engine=None, engine_lifecycle_support=None, engine_version=None, iops=None, license_model=None, manage_master_user_password=None, master_user_secret=None, max_allocated_storage=None, monitoring_interval=None, monitoring_role_arn=None, multi_az=None, network_type=None, option_group_name=None, performance_insights_kms_key_id=None, performance_insights_retention_period=None, preferred_backup_window=None, preferred_maintenance_window=None, processor_features=None, promotion_tier=None, publicly_accessible=None, replica_mode=None, source_db_cluster_identifier=None, storage_throughput=None, storage_type=None, tags=None, tde_credential_arn=None, vpc_security_groups=None):
        if allocated_storage and not isinstance(allocated_storage, str):
            raise TypeError("Expected argument 'allocated_storage' to be a str")
        pulumi.set(__self__, "allocated_storage", allocated_storage)
        if associated_roles and not isinstance(associated_roles, list):
            raise TypeError("Expected argument 'associated_roles' to be a list")
        pulumi.set(__self__, "associated_roles", associated_roles)
        if auto_minor_version_upgrade and not isinstance(auto_minor_version_upgrade, bool):
            raise TypeError("Expected argument 'auto_minor_version_upgrade' to be a bool")
        pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if automatic_backup_replication_region and not isinstance(automatic_backup_replication_region, str):
            raise TypeError("Expected argument 'automatic_backup_replication_region' to be a str")
        pulumi.set(__self__, "automatic_backup_replication_region", automatic_backup_replication_region)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_period and not isinstance(backup_retention_period, int):
            raise TypeError("Expected argument 'backup_retention_period' to be a int")
        pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if ca_certificate_identifier and not isinstance(ca_certificate_identifier, str):
            raise TypeError("Expected argument 'ca_certificate_identifier' to be a str")
        pulumi.set(__self__, "ca_certificate_identifier", ca_certificate_identifier)
        if certificate_details and not isinstance(certificate_details, dict):
            raise TypeError("Expected argument 'certificate_details' to be a dict")
        pulumi.set(__self__, "certificate_details", certificate_details)
        if copy_tags_to_snapshot and not isinstance(copy_tags_to_snapshot, bool):
            raise TypeError("Expected argument 'copy_tags_to_snapshot' to be a bool")
        pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if db_cluster_snapshot_identifier and not isinstance(db_cluster_snapshot_identifier, str):
            raise TypeError("Expected argument 'db_cluster_snapshot_identifier' to be a str")
        pulumi.set(__self__, "db_cluster_snapshot_identifier", db_cluster_snapshot_identifier)
        if db_instance_arn and not isinstance(db_instance_arn, str):
            raise TypeError("Expected argument 'db_instance_arn' to be a str")
        pulumi.set(__self__, "db_instance_arn", db_instance_arn)
        if db_instance_class and not isinstance(db_instance_class, str):
            raise TypeError("Expected argument 'db_instance_class' to be a str")
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        if db_parameter_group_name and not isinstance(db_parameter_group_name, str):
            raise TypeError("Expected argument 'db_parameter_group_name' to be a str")
        pulumi.set(__self__, "db_parameter_group_name", db_parameter_group_name)
        if db_security_groups and not isinstance(db_security_groups, list):
            raise TypeError("Expected argument 'db_security_groups' to be a list")
        pulumi.set(__self__, "db_security_groups", db_security_groups)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if dbi_resource_id and not isinstance(dbi_resource_id, str):
            raise TypeError("Expected argument 'dbi_resource_id' to be a str")
        pulumi.set(__self__, "dbi_resource_id", dbi_resource_id)
        if dedicated_log_volume and not isinstance(dedicated_log_volume, bool):
            raise TypeError("Expected argument 'dedicated_log_volume' to be a bool")
        pulumi.set(__self__, "dedicated_log_volume", dedicated_log_volume)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domain_auth_secret_arn and not isinstance(domain_auth_secret_arn, str):
            raise TypeError("Expected argument 'domain_auth_secret_arn' to be a str")
        pulumi.set(__self__, "domain_auth_secret_arn", domain_auth_secret_arn)
        if domain_dns_ips and not isinstance(domain_dns_ips, list):
            raise TypeError("Expected argument 'domain_dns_ips' to be a list")
        pulumi.set(__self__, "domain_dns_ips", domain_dns_ips)
        if domain_fqdn and not isinstance(domain_fqdn, str):
            raise TypeError("Expected argument 'domain_fqdn' to be a str")
        pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        if domain_iam_role_name and not isinstance(domain_iam_role_name, str):
            raise TypeError("Expected argument 'domain_iam_role_name' to be a str")
        pulumi.set(__self__, "domain_iam_role_name", domain_iam_role_name)
        if domain_ou and not isinstance(domain_ou, str):
            raise TypeError("Expected argument 'domain_ou' to be a str")
        pulumi.set(__self__, "domain_ou", domain_ou)
        if enable_cloudwatch_logs_exports and not isinstance(enable_cloudwatch_logs_exports, list):
            raise TypeError("Expected argument 'enable_cloudwatch_logs_exports' to be a list")
        pulumi.set(__self__, "enable_cloudwatch_logs_exports", enable_cloudwatch_logs_exports)
        if enable_iam_database_authentication and not isinstance(enable_iam_database_authentication, bool):
            raise TypeError("Expected argument 'enable_iam_database_authentication' to be a bool")
        pulumi.set(__self__, "enable_iam_database_authentication", enable_iam_database_authentication)
        if enable_performance_insights and not isinstance(enable_performance_insights, bool):
            raise TypeError("Expected argument 'enable_performance_insights' to be a bool")
        pulumi.set(__self__, "enable_performance_insights", enable_performance_insights)
        if endpoint and not isinstance(endpoint, dict):
            raise TypeError("Expected argument 'endpoint' to be a dict")
        pulumi.set(__self__, "endpoint", endpoint)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support and not isinstance(engine_lifecycle_support, str):
            raise TypeError("Expected argument 'engine_lifecycle_support' to be a str")
        pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if iops and not isinstance(iops, int):
            raise TypeError("Expected argument 'iops' to be a int")
        pulumi.set(__self__, "iops", iops)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if manage_master_user_password and not isinstance(manage_master_user_password, bool):
            raise TypeError("Expected argument 'manage_master_user_password' to be a bool")
        pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_user_secret and not isinstance(master_user_secret, dict):
            raise TypeError("Expected argument 'master_user_secret' to be a dict")
        pulumi.set(__self__, "master_user_secret", master_user_secret)
        if max_allocated_storage and not isinstance(max_allocated_storage, int):
            raise TypeError("Expected argument 'max_allocated_storage' to be a int")
        pulumi.set(__self__, "max_allocated_storage", max_allocated_storage)
        if monitoring_interval and not isinstance(monitoring_interval, int):
            raise TypeError("Expected argument 'monitoring_interval' to be a int")
        pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn and not isinstance(monitoring_role_arn, str):
            raise TypeError("Expected argument 'monitoring_role_arn' to be a str")
        pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if multi_az and not isinstance(multi_az, bool):
            raise TypeError("Expected argument 'multi_az' to be a bool")
        pulumi.set(__self__, "multi_az", multi_az)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if option_group_name and not isinstance(option_group_name, str):
            raise TypeError("Expected argument 'option_group_name' to be a str")
        pulumi.set(__self__, "option_group_name", option_group_name)
        if performance_insights_kms_key_id and not isinstance(performance_insights_kms_key_id, str):
            raise TypeError("Expected argument 'performance_insights_kms_key_id' to be a str")
        pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period and not isinstance(performance_insights_retention_period, int):
            raise TypeError("Expected argument 'performance_insights_retention_period' to be a int")
        pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if preferred_backup_window and not isinstance(preferred_backup_window, str):
            raise TypeError("Expected argument 'preferred_backup_window' to be a str")
        pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window and not isinstance(preferred_maintenance_window, str):
            raise TypeError("Expected argument 'preferred_maintenance_window' to be a str")
        pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if processor_features and not isinstance(processor_features, list):
            raise TypeError("Expected argument 'processor_features' to be a list")
        pulumi.set(__self__, "processor_features", processor_features)
        if promotion_tier and not isinstance(promotion_tier, int):
            raise TypeError("Expected argument 'promotion_tier' to be a int")
        pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible and not isinstance(publicly_accessible, bool):
            raise TypeError("Expected argument 'publicly_accessible' to be a bool")
        pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if replica_mode and not isinstance(replica_mode, str):
            raise TypeError("Expected argument 'replica_mode' to be a str")
        pulumi.set(__self__, "replica_mode", replica_mode)
        if source_db_cluster_identifier and not isinstance(source_db_cluster_identifier, str):
            raise TypeError("Expected argument 'source_db_cluster_identifier' to be a str")
        pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if storage_throughput and not isinstance(storage_throughput, int):
            raise TypeError("Expected argument 'storage_throughput' to be a int")
        pulumi.set(__self__, "storage_throughput", storage_throughput)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tde_credential_arn and not isinstance(tde_credential_arn, str):
            raise TypeError("Expected argument 'tde_credential_arn' to be a str")
        pulumi.set(__self__, "tde_credential_arn", tde_credential_arn)
        if vpc_security_groups and not isinstance(vpc_security_groups, list):
            raise TypeError("Expected argument 'vpc_security_groups' to be a list")
        pulumi.set(__self__, "vpc_security_groups", vpc_security_groups)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[str]:
        """
        The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
          If any value is set in the ``Iops`` parameter, ``AllocatedStorage`` must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the ``Iops`` value (in 1,000 IOPS increments), then you must also increase the ``AllocatedStorage`` value (in 100-GiB increments). 
           *Amazon Aurora* 
         Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
          *Db2* 
         Constraints to the amount of storage for each storage type are the following:
          +  General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.
          
          *MySQL* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *MariaDB* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *PostgreSQL* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *Oracle* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 10 to 3072.
          
          *SQL Server* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2):
          +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
          +  Web and Express editions: Must be an integer from 20 to 16384.
          
          +  Provisioned IOPS storage (io1):
          +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
          +  Web and Express editions: Must be an integer from 20 to 16384.
          
          +  Magnetic storage (standard):
          +  Enterprise and Standard editions: Must be an integer from 20 to 1024.
          +  Web and Express editions: Must be an integer from 20 to 1024.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> Optional[Sequence['outputs.DbInstanceDbInstanceRole']]:
        """
        The IAMlong (IAM) roles associated with the DB instance. 
          *Amazon Aurora* 
         Not applicable. The associated roles are managed by the DB cluster.
        """
        return pulumi.get(self, "associated_roles")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[bool]:
        """
        A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="automaticBackupReplicationRegion")
    def automatic_backup_replication_region(self) -> Optional[str]:
        """
        The AWS-Region associated with the automated backup.
        """
        return pulumi.get(self, "automatic_backup_replication_region")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The Availability Zone (AZ) where the database will be created. For information on AWS-Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
         For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         Default: A random, system-chosen Availability Zone in the endpoint's AWS-Region.
         Constraints:
          +  The ``AvailabilityZone`` parameter can't be specified if the DB instance is a Multi-AZ deployment.
          +  The specified Availability Zone must be in the same AWS-Region as the current endpoint.
          
         Example: ``us-east-1d``
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[int]:
        """
        The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
          *Amazon Aurora* 
         Not applicable. The retention period for automated backups is managed by the DB cluster.
         Default: 1
         Constraints:
          +  Must be a value from 0 to 35
          +  Can't be set to 0 if the DB instance is a source to read replicas
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="caCertificateIdentifier")
    def ca_certificate_identifier(self) -> Optional[str]:
        """
        The identifier of the CA certificate for this DB instance.
         For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "ca_certificate_identifier")

    @property
    @pulumi.getter(name="certificateDetails")
    def certificate_details(self) -> Optional['outputs.DbInstanceCertificateDetails']:
        """
        The details of the DB instance's server certificate.
        """
        return pulumi.get(self, "certificate_details")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[bool]:
        """
        Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
         This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="dbClusterSnapshotIdentifier")
    def db_cluster_snapshot_identifier(self) -> Optional[str]:
        """
        The identifier for the Multi-AZ DB cluster snapshot to restore from.
         For more information on Multi-AZ DB clusters, see [Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
         Constraints:
          +  Must match the identifier of an existing Multi-AZ DB cluster snapshot.
          +  Can't be specified when ``DBSnapshotIdentifier`` is specified.
          +  Must be specified when ``DBSnapshotIdentifier`` isn't specified.
          +  If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the ``DBClusterSnapshotIdentifier`` must be the ARN of the shared snapshot.
          +  Can't be the identifier of an Aurora DB cluster snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_identifier")

    @property
    @pulumi.getter(name="dbInstanceArn")
    def db_instance_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the DB instance.
        """
        return pulumi.get(self, "db_instance_arn")

    @property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> Optional[str]:
        """
        The compute and memory capacity of the DB instance, for example ``db.m5.large``. Not all DB instance classes are available in all AWS-Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "db_instance_class")

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> Optional[str]:
        """
        The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
         To list all of the available DB parameter group names, use the following command:
          ``aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text`` 
          If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
          If you don't specify a value for ``DBParameterGroupName`` property, the default DB parameter group for the specified engine and engine version is used.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @property
    @pulumi.getter(name="dbSecurityGroups")
    def db_security_groups(self) -> Optional[Sequence[str]]:
        """
        A list of the DB security groups to assign to the DB instance. The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
          If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
          If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
          +   ``AllocatedStorage`` 
          +   ``AutoMinorVersionUpgrade`` 
          +   ``AvailabilityZone`` 
          +   ``BackupRetentionPeriod`` 
          +   ``CharacterSetName`` 
          +   ``DBInstanceClass`` 
          +   ``DBName`` 
          +   ``DBParameterGroupName`` 
          +   ``DBSecurityGroups`` 
          +   ``DBSubnetGroupName`` 
          +   ``Engine`` 
          +   ``EngineVersion`` 
          +   ``Iops`` 
          +   ``LicenseModel`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``MultiAZ`` 
          +   ``OptionGroupName`` 
          +   ``PreferredBackupWindow`` 
          +   ``PreferredMaintenanceWindow`` 
          
         All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as ``StorageType``, ``StorageEncrypted``, or ``KmsKeyId``. If you're already using the ``DBSecurityGroups`` property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
        """
        return pulumi.get(self, "db_security_groups")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[str]:
        """
        The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to ``RDSCDB``. The Oracle SID is also the name of your CDB.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> Optional[str]:
        """
        The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
        """
        return pulumi.get(self, "dbi_resource_id")

    @property
    @pulumi.getter(name="dedicatedLogVolume")
    def dedicated_log_volume(self) -> Optional[bool]:
        """
        Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
        """
        return pulumi.get(self, "dedicated_log_volume")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[bool]:
        """
        Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see ``CreateDBCluster``. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The Active Directory directory ID to create the DB instance in. Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainAuthSecretArn")
    def domain_auth_secret_arn(self) -> Optional[str]:
        """
        The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         Example: ``arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456``
        """
        return pulumi.get(self, "domain_auth_secret_arn")

    @property
    @pulumi.getter(name="domainDnsIps")
    def domain_dns_ips(self) -> Optional[Sequence[str]]:
        """
        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         Constraints:
          +  Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
          
         Example: ``123.124.125.126,234.235.236.237``
        """
        return pulumi.get(self, "domain_dns_ips")

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> Optional[str]:
        """
        The fully qualified domain name (FQDN) of an Active Directory domain.
         Constraints:
          +  Can't be longer than 64 characters.
          
         Example: ``mymanagedADtest.mymanagedAD.mydomain``
        """
        return pulumi.get(self, "domain_fqdn")

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> Optional[str]:
        """
        The name of the IAM role to use when making API calls to the Directory Service.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (The domain is managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "domain_iam_role_name")

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[str]:
        """
        The Active Directory organizational unit for your DB instance to join.
         Constraints:
          +  Must be in the distinguished name format.
          +  Can't be longer than 64 characters.
          
         Example: ``OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain``
        """
        return pulumi.get(self, "domain_ou")

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> Optional[Sequence[str]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Relational Database Service User Guide*.
          *Amazon Aurora* 
         Not applicable. CloudWatch Logs exports are managed by the DB cluster. 
          *Db2* 
         Valid values: ``diag.log``, ``notify.log`` 
          *MariaDB* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery`` 
          *Microsoft SQL Server* 
         Valid values: ``agent``, ``error`` 
          *MySQL* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery`` 
          *Oracle* 
         Valid values: ``alert``, ``audit``, ``listener``, ``trace``, ``oemagent`` 
          *PostgreSQL* 
         Valid values: ``postgresql``, ``upgrade``
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @property
    @pulumi.getter(name="enableIamDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> Optional[bool]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
         This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see [IAM Database Authentication for MariaDB, MySQL, and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.* 
          *Amazon Aurora* 
         Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @property
    @pulumi.getter(name="enablePerformanceInsights")
    def enable_performance_insights(self) -> Optional[bool]:
        """
        Specifies whether to enable Performance Insights for the DB instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "enable_performance_insights")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional['outputs.DbInstanceEndpoint']:
        """
        The connection endpoint for the DB instance.
          The endpoint might not be shown for instances with the status of ``creating``.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The name of the database engine to use for this DB instance. Not every database engine is available in every AWS Region.
         This property is required when creating a DB instance.
          You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the ``Engine`` value in your templates from ``oracle-ee`` to ``oracle-ee-cdb`` or from ``oracle-se2`` to ``oracle-se2-cdb``. Converting to the CDB architecture requires an interruption.
          Valid Values:
          +   ``aurora-mysql`` (for Aurora MySQL DB instances)
          +   ``aurora-postgresql`` (for Aurora PostgreSQL DB instances)
          +   ``custom-oracle-ee`` (for RDS Custom for Oracle DB instances)
          +   ``custom-oracle-ee-cdb`` (for RDS Custom for Oracle DB instances)
          +   ``custom-sqlserver-ee`` (for RDS Custom for SQL Server DB instances)
          +   ``custom-sqlserver-se`` (for RDS Custom for SQL Server DB instances)
          +   ``custom-sqlserver-web`` (for RDS Custom for SQL Server DB instances)
          +   ``db2-ae`` 
          +   ``db2-se`` 
          +   ``mariadb`` 
          +   ``mysql`` 
          +   ``oracle-ee`` 
          +   ``oracle-ee-cdb`` 
          +   ``oracle-se2`` 
          +   ``oracle-se2-cdb`` 
          +   ``postgres`` 
          +   ``sqlserver-ee`` 
          +   ``sqlserver-se`` 
          +   ``sqlserver-ex`` 
          +   ``sqlserver-web``
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[str]:
        """
        The life cycle type for this DB instance.
          By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
          This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
         You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
         Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled`` 
         Default: ``open-source-rds-extended-support``
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[str]:
        """
        The version number of the database engine to use.
         For a list of valid engine versions, use the ``DescribeDBEngineVersions`` action.
         The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
          *Amazon Aurora* 
         Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
          *Db2* 
         See [Amazon RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt) in the *Amazon RDS User Guide.* 
          *MariaDB* 
         See [MariaDB on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt) in the *Amazon RDS User Guide.* 
          *Microsoft SQL Server* 
         See [Microsoft SQL Server Versions on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport) in the *Amazon RDS User Guide.* 
          *MySQL* 
         See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.* 
          *Oracle* 
         See [Oracle Database Engine Release Notes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html) in the *Amazon RDS User Guide.* 
          *PostgreSQL* 
         See [Supported PostgreSQL Database Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the database provisions. The value must be equal to or greater than 1000. 
         If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
          If you specify ``io1`` for the ``StorageType`` property, then you must also specify the ``Iops`` property.
          Constraints:
          +  For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.
          +  For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[str]:
        """
        License model information for this DB instance.
          Valid Values:
          +  Aurora MySQL - ``general-public-license`` 
          +  Aurora PostgreSQL - ``postgresql-license`` 
          +  RDS for Db2 - ``bring-your-own-license``. For more information about RDS for Db2 licensing, see [](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide.* 
          +  RDS for MariaDB - ``general-public-license`` 
          +  RDS for Microsoft SQL Server - ``license-included`` 
          +  RDS for MySQL - ``general-public-license`` 
          +  RDS for Oracle - ``bring-your-own-license`` or ``license-included`` 
          +  RDS for PostgreSQL - ``postgresql-license`` 
          
          If you've specified ``DBSecurityGroups`` and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[bool]:
        """
        Specifies whether to manage the master user password with AWS Secrets Manager.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.* 
         Constraints:
          +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        """
        return pulumi.get(self, "manage_master_user_password")

    @property
    @pulumi.getter(name="masterUserSecret")
    def master_user_secret(self) -> Optional['outputs.DbInstanceMasterUserSecret']:
        """
        The secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "master_user_secret")

    @property
    @pulumi.getter(name="maxAllocatedStorage")
    def max_allocated_storage(self) -> Optional[int]:
        """
        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         For more information about this setting, including limitations that apply to it, see [Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (Storage is managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "max_allocated_storage")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[int]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify ``0``.
         If ``MonitoringRoleArn`` is specified, then you must set ``MonitoringInterval`` to a value other than ``0``.
         This setting doesn't apply to RDS Custom DB instances.
         Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60`` 
         Default: ``0``
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[str]:
        """
        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
         If ``MonitoringInterval`` is set to a value other than ``0``, then you must supply a ``MonitoringRoleArn`` value.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[bool]:
        """
        Specifies whether the DB instance is a Multi-AZ deployment. You can't set the ``AvailabilityZone`` parameter if the DB instance is a Multi-AZ deployment.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        """
        The network type of the DB instance.
         Valid values:
          +   ``IPV4`` 
          +   ``DUAL`` 
          
         The network type is determined by the ``DBSubnetGroup`` specified for the DB instance. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
         For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="optionGroupName")
    def option_group_name(self) -> Optional[str]:
        """
        Indicates that the DB instance should be associated with the specified option group.
         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
        """
        return pulumi.get(self, "option_group_name")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[str]:
        """
        The AWS KMS key identifier for encryption of Performance Insights data.
         The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         If you do not specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
         For information about enabling Performance Insights, see [EnablePerformanceInsights](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights).
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[int]:
        """
        The number of days to retain Performance Insights data.
         This setting doesn't apply to RDS Custom DB instances.
         Valid Values:
          +   ``7`` 
          +   *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
          +   ``731`` 
          
         Default: ``7`` days
         If you specify a retention period that isn't valid, such as ``94``, Amazon RDS returns an error.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[str]:
        """
        The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.* 
         Constraints:
          +  Must be in the format ``hh24:mi-hh24:mi``.
          +  Must be in Universal Coordinated Time (UTC).
          +  Must not conflict with the preferred maintenance window.
          +  Must be at least 30 minutes.
          
          *Amazon Aurora* 
         Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[str]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         Format: ``ddd:hh24:mi-ddd:hh24:mi`` 
         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Adjusting the Preferred DB Instance Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow) in the *Amazon RDS User Guide.* 
          This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
          Constraints: Minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="processorFeatures")
    def processor_features(self) -> Optional[Sequence['outputs.DbInstanceProcessorFeature']]:
        """
        The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
        """
        return pulumi.get(self, "processor_features")

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[int]:
        """
        The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
         This setting doesn't apply to RDS Custom DB instances.
         Default: ``1`` 
         Valid Values: ``0 - 15``
        """
        return pulumi.get(self, "promotion_tier")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[bool]:
        """
        Indicates whether the DB instance is an internet-facing instance. If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address. 
         The default behavior value depends on your VPC setup and the database subnet group. For more information, see the ``PubliclyAccessible`` parameter in the [CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="replicaMode")
    def replica_mode(self) -> Optional[str]:
        """
        The open mode of an Oracle read replica. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
         This setting is only supported in RDS for Oracle.
         Default: ``open-read-only`` 
         Valid Values: ``open-read-only`` or ``mounted``
        """
        return pulumi.get(self, "replica_mode")

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[str]:
        """
        The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
         Constraints:
          +  Must be the identifier of an existing Multi-AZ DB cluster.
          +  Can't be specified if the ``SourceDBInstanceIdentifier`` parameter is also specified.
          +  The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
          +  The source DB cluster must be in the same AWS-Region as the read replica. Cross-Region replication isn't supported.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> Optional[int]:
        """
        Specifies the storage throughput value for the DB instance. This setting applies only to the ``gp3`` storage type. 
         This setting doesn't apply to RDS Custom or Amazon Aurora.
        """
        return pulumi.get(self, "storage_throughput")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        The storage type to associate with the DB instance.
         If you specify ``io1``, ``io2``, or ``gp3``, you must also include a value for the ``Iops`` parameter.
         This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         Valid Values: ``gp2 | gp3 | io1 | io2 | standard`` 
         Default: ``io1``, if the ``Iops`` parameter is specified. Otherwise, ``gp2``.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags to assign to the DB instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tdeCredentialArn")
    def tde_credential_arn(self) -> Optional[str]:
        return pulumi.get(self, "tde_credential_arn")

    @property
    @pulumi.getter(name="vpcSecurityGroups")
    def vpc_security_groups(self) -> Optional[Sequence[str]]:
        """
        A list of the VPC security group IDs to assign to the DB instance. The list can include both the physical IDs of existing VPC security groups and references to [AWS::EC2::SecurityGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html) resources created in the template.
         If you plan to update the resource, don't specify VPC security groups in a shared VPC.
          If you set ``VPCSecurityGroups``, you must not set [DBSecurityGroups](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups), and vice versa.
          You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
          +  You can't revert to using an RDS security group after you establish a VPC security group membership.
          +  When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.
          +  To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the [DBSecurityGroups](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups) property.
          
          To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template. 
          *Amazon Aurora* 
         Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        return pulumi.get(self, "vpc_security_groups")


class AwaitableGetDbInstanceResult(GetDbInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbInstanceResult(
            allocated_storage=self.allocated_storage,
            associated_roles=self.associated_roles,
            auto_minor_version_upgrade=self.auto_minor_version_upgrade,
            automatic_backup_replication_region=self.automatic_backup_replication_region,
            availability_zone=self.availability_zone,
            backup_retention_period=self.backup_retention_period,
            ca_certificate_identifier=self.ca_certificate_identifier,
            certificate_details=self.certificate_details,
            copy_tags_to_snapshot=self.copy_tags_to_snapshot,
            db_cluster_snapshot_identifier=self.db_cluster_snapshot_identifier,
            db_instance_arn=self.db_instance_arn,
            db_instance_class=self.db_instance_class,
            db_parameter_group_name=self.db_parameter_group_name,
            db_security_groups=self.db_security_groups,
            db_system_id=self.db_system_id,
            dbi_resource_id=self.dbi_resource_id,
            dedicated_log_volume=self.dedicated_log_volume,
            deletion_protection=self.deletion_protection,
            domain=self.domain,
            domain_auth_secret_arn=self.domain_auth_secret_arn,
            domain_dns_ips=self.domain_dns_ips,
            domain_fqdn=self.domain_fqdn,
            domain_iam_role_name=self.domain_iam_role_name,
            domain_ou=self.domain_ou,
            enable_cloudwatch_logs_exports=self.enable_cloudwatch_logs_exports,
            enable_iam_database_authentication=self.enable_iam_database_authentication,
            enable_performance_insights=self.enable_performance_insights,
            endpoint=self.endpoint,
            engine=self.engine,
            engine_lifecycle_support=self.engine_lifecycle_support,
            engine_version=self.engine_version,
            iops=self.iops,
            license_model=self.license_model,
            manage_master_user_password=self.manage_master_user_password,
            master_user_secret=self.master_user_secret,
            max_allocated_storage=self.max_allocated_storage,
            monitoring_interval=self.monitoring_interval,
            monitoring_role_arn=self.monitoring_role_arn,
            multi_az=self.multi_az,
            network_type=self.network_type,
            option_group_name=self.option_group_name,
            performance_insights_kms_key_id=self.performance_insights_kms_key_id,
            performance_insights_retention_period=self.performance_insights_retention_period,
            preferred_backup_window=self.preferred_backup_window,
            preferred_maintenance_window=self.preferred_maintenance_window,
            processor_features=self.processor_features,
            promotion_tier=self.promotion_tier,
            publicly_accessible=self.publicly_accessible,
            replica_mode=self.replica_mode,
            source_db_cluster_identifier=self.source_db_cluster_identifier,
            storage_throughput=self.storage_throughput,
            storage_type=self.storage_type,
            tags=self.tags,
            tde_credential_arn=self.tde_credential_arn,
            vpc_security_groups=self.vpc_security_groups)


def get_db_instance(db_instance_identifier: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbInstanceResult:
    """
    The ``AWS::RDS::DBInstance`` resource creates an Amazon DB instance. The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
     For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide*.
     For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
     If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
      If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html).
       *Updating DB instances*
     When properties labeled "*Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement)" are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
      We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
      1.  Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
      2.  Create a snapshot of the DB instance. For more information, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html).
      3.  If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the ``DBSnapshotIdentifier`` property with the ID of the DB snapshot that you want to use.
           After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you can delete the ``DBSnapshotIdentifier`` property. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
      4.  Update the stack.

      For more information about updating other properties of this resource, see ``ModifyDBInstance``. For more information about updating stacks, see [CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
      *Deleting DB instances*
     For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the ``DBClusterIdentifier`` property:
      1.  For ``AWS::RDS::DBInstance`` resources that don't specify the ``DBClusterIdentifier`` property, AWS CloudFormation saves a snapshot of the DB instance.
      2.   For ``AWS::RDS::DBInstance`` resources that do specify the ``DBClusterIdentifier`` property, AWS CloudFormation deletes the DB instance.

      For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).


    :param str db_instance_identifier: A name for the DB instance. If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
            For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
             If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
    """
    __args__ = dict()
    __args__['dbInstanceIdentifier'] = db_instance_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbInstance', __args__, opts=opts, typ=GetDbInstanceResult).value

    return AwaitableGetDbInstanceResult(
        allocated_storage=pulumi.get(__ret__, 'allocated_storage'),
        associated_roles=pulumi.get(__ret__, 'associated_roles'),
        auto_minor_version_upgrade=pulumi.get(__ret__, 'auto_minor_version_upgrade'),
        automatic_backup_replication_region=pulumi.get(__ret__, 'automatic_backup_replication_region'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        backup_retention_period=pulumi.get(__ret__, 'backup_retention_period'),
        ca_certificate_identifier=pulumi.get(__ret__, 'ca_certificate_identifier'),
        certificate_details=pulumi.get(__ret__, 'certificate_details'),
        copy_tags_to_snapshot=pulumi.get(__ret__, 'copy_tags_to_snapshot'),
        db_cluster_snapshot_identifier=pulumi.get(__ret__, 'db_cluster_snapshot_identifier'),
        db_instance_arn=pulumi.get(__ret__, 'db_instance_arn'),
        db_instance_class=pulumi.get(__ret__, 'db_instance_class'),
        db_parameter_group_name=pulumi.get(__ret__, 'db_parameter_group_name'),
        db_security_groups=pulumi.get(__ret__, 'db_security_groups'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        dbi_resource_id=pulumi.get(__ret__, 'dbi_resource_id'),
        dedicated_log_volume=pulumi.get(__ret__, 'dedicated_log_volume'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        domain=pulumi.get(__ret__, 'domain'),
        domain_auth_secret_arn=pulumi.get(__ret__, 'domain_auth_secret_arn'),
        domain_dns_ips=pulumi.get(__ret__, 'domain_dns_ips'),
        domain_fqdn=pulumi.get(__ret__, 'domain_fqdn'),
        domain_iam_role_name=pulumi.get(__ret__, 'domain_iam_role_name'),
        domain_ou=pulumi.get(__ret__, 'domain_ou'),
        enable_cloudwatch_logs_exports=pulumi.get(__ret__, 'enable_cloudwatch_logs_exports'),
        enable_iam_database_authentication=pulumi.get(__ret__, 'enable_iam_database_authentication'),
        enable_performance_insights=pulumi.get(__ret__, 'enable_performance_insights'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_lifecycle_support=pulumi.get(__ret__, 'engine_lifecycle_support'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        iops=pulumi.get(__ret__, 'iops'),
        license_model=pulumi.get(__ret__, 'license_model'),
        manage_master_user_password=pulumi.get(__ret__, 'manage_master_user_password'),
        master_user_secret=pulumi.get(__ret__, 'master_user_secret'),
        max_allocated_storage=pulumi.get(__ret__, 'max_allocated_storage'),
        monitoring_interval=pulumi.get(__ret__, 'monitoring_interval'),
        monitoring_role_arn=pulumi.get(__ret__, 'monitoring_role_arn'),
        multi_az=pulumi.get(__ret__, 'multi_az'),
        network_type=pulumi.get(__ret__, 'network_type'),
        option_group_name=pulumi.get(__ret__, 'option_group_name'),
        performance_insights_kms_key_id=pulumi.get(__ret__, 'performance_insights_kms_key_id'),
        performance_insights_retention_period=pulumi.get(__ret__, 'performance_insights_retention_period'),
        preferred_backup_window=pulumi.get(__ret__, 'preferred_backup_window'),
        preferred_maintenance_window=pulumi.get(__ret__, 'preferred_maintenance_window'),
        processor_features=pulumi.get(__ret__, 'processor_features'),
        promotion_tier=pulumi.get(__ret__, 'promotion_tier'),
        publicly_accessible=pulumi.get(__ret__, 'publicly_accessible'),
        replica_mode=pulumi.get(__ret__, 'replica_mode'),
        source_db_cluster_identifier=pulumi.get(__ret__, 'source_db_cluster_identifier'),
        storage_throughput=pulumi.get(__ret__, 'storage_throughput'),
        storage_type=pulumi.get(__ret__, 'storage_type'),
        tags=pulumi.get(__ret__, 'tags'),
        tde_credential_arn=pulumi.get(__ret__, 'tde_credential_arn'),
        vpc_security_groups=pulumi.get(__ret__, 'vpc_security_groups'))
def get_db_instance_output(db_instance_identifier: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbInstanceResult]:
    """
    The ``AWS::RDS::DBInstance`` resource creates an Amazon DB instance. The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
     For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide*.
     For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
     If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
      If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html).
       *Updating DB instances*
     When properties labeled "*Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement)" are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
      We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
      1.  Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
      2.  Create a snapshot of the DB instance. For more information, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html).
      3.  If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the ``DBSnapshotIdentifier`` property with the ID of the DB snapshot that you want to use.
           After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you can delete the ``DBSnapshotIdentifier`` property. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
      4.  Update the stack.

      For more information about updating other properties of this resource, see ``ModifyDBInstance``. For more information about updating stacks, see [CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
      *Deleting DB instances*
     For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the ``DBClusterIdentifier`` property:
      1.  For ``AWS::RDS::DBInstance`` resources that don't specify the ``DBClusterIdentifier`` property, AWS CloudFormation saves a snapshot of the DB instance.
      2.   For ``AWS::RDS::DBInstance`` resources that do specify the ``DBClusterIdentifier`` property, AWS CloudFormation deletes the DB instance.

      For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).


    :param str db_instance_identifier: A name for the DB instance. If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
            For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
             If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
    """
    __args__ = dict()
    __args__['dbInstanceIdentifier'] = db_instance_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getDbInstance', __args__, opts=opts, typ=GetDbInstanceResult)
    return __ret__.apply(lambda __response__: GetDbInstanceResult(
        allocated_storage=pulumi.get(__response__, 'allocated_storage'),
        associated_roles=pulumi.get(__response__, 'associated_roles'),
        auto_minor_version_upgrade=pulumi.get(__response__, 'auto_minor_version_upgrade'),
        automatic_backup_replication_region=pulumi.get(__response__, 'automatic_backup_replication_region'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        backup_retention_period=pulumi.get(__response__, 'backup_retention_period'),
        ca_certificate_identifier=pulumi.get(__response__, 'ca_certificate_identifier'),
        certificate_details=pulumi.get(__response__, 'certificate_details'),
        copy_tags_to_snapshot=pulumi.get(__response__, 'copy_tags_to_snapshot'),
        db_cluster_snapshot_identifier=pulumi.get(__response__, 'db_cluster_snapshot_identifier'),
        db_instance_arn=pulumi.get(__response__, 'db_instance_arn'),
        db_instance_class=pulumi.get(__response__, 'db_instance_class'),
        db_parameter_group_name=pulumi.get(__response__, 'db_parameter_group_name'),
        db_security_groups=pulumi.get(__response__, 'db_security_groups'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        dbi_resource_id=pulumi.get(__response__, 'dbi_resource_id'),
        dedicated_log_volume=pulumi.get(__response__, 'dedicated_log_volume'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        domain=pulumi.get(__response__, 'domain'),
        domain_auth_secret_arn=pulumi.get(__response__, 'domain_auth_secret_arn'),
        domain_dns_ips=pulumi.get(__response__, 'domain_dns_ips'),
        domain_fqdn=pulumi.get(__response__, 'domain_fqdn'),
        domain_iam_role_name=pulumi.get(__response__, 'domain_iam_role_name'),
        domain_ou=pulumi.get(__response__, 'domain_ou'),
        enable_cloudwatch_logs_exports=pulumi.get(__response__, 'enable_cloudwatch_logs_exports'),
        enable_iam_database_authentication=pulumi.get(__response__, 'enable_iam_database_authentication'),
        enable_performance_insights=pulumi.get(__response__, 'enable_performance_insights'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        engine=pulumi.get(__response__, 'engine'),
        engine_lifecycle_support=pulumi.get(__response__, 'engine_lifecycle_support'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        iops=pulumi.get(__response__, 'iops'),
        license_model=pulumi.get(__response__, 'license_model'),
        manage_master_user_password=pulumi.get(__response__, 'manage_master_user_password'),
        master_user_secret=pulumi.get(__response__, 'master_user_secret'),
        max_allocated_storage=pulumi.get(__response__, 'max_allocated_storage'),
        monitoring_interval=pulumi.get(__response__, 'monitoring_interval'),
        monitoring_role_arn=pulumi.get(__response__, 'monitoring_role_arn'),
        multi_az=pulumi.get(__response__, 'multi_az'),
        network_type=pulumi.get(__response__, 'network_type'),
        option_group_name=pulumi.get(__response__, 'option_group_name'),
        performance_insights_kms_key_id=pulumi.get(__response__, 'performance_insights_kms_key_id'),
        performance_insights_retention_period=pulumi.get(__response__, 'performance_insights_retention_period'),
        preferred_backup_window=pulumi.get(__response__, 'preferred_backup_window'),
        preferred_maintenance_window=pulumi.get(__response__, 'preferred_maintenance_window'),
        processor_features=pulumi.get(__response__, 'processor_features'),
        promotion_tier=pulumi.get(__response__, 'promotion_tier'),
        publicly_accessible=pulumi.get(__response__, 'publicly_accessible'),
        replica_mode=pulumi.get(__response__, 'replica_mode'),
        source_db_cluster_identifier=pulumi.get(__response__, 'source_db_cluster_identifier'),
        storage_throughput=pulumi.get(__response__, 'storage_throughput'),
        storage_type=pulumi.get(__response__, 'storage_type'),
        tags=pulumi.get(__response__, 'tags'),
        tde_credential_arn=pulumi.get(__response__, 'tde_credential_arn'),
        vpc_security_groups=pulumi.get(__response__, 'vpc_security_groups')))
