# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['DbSubnetGroupArgs', 'DbSubnetGroup']

@pulumi.input_type
class DbSubnetGroupArgs:
    def __init__(__self__, *,
                 db_subnet_group_description: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DbSubnetGroup resource.
        :param pulumi.Input[str] db_subnet_group_description: The description for the DB subnet group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The EC2 Subnet IDs for the DB subnet group.
        :param pulumi.Input[str] db_subnet_group_name: The name for the DB subnet group. This value is stored as a lowercase string.
                Constraints:
                 +  Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.
                 +  Must not be default.
                 +  First character must be a letter.
                 
                Example: ``mydbsubnetgroup``
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags to assign to the DB subnet group.
        """
        pulumi.set(__self__, "db_subnet_group_description", db_subnet_group_description)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dbSubnetGroupDescription")
    def db_subnet_group_description(self) -> pulumi.Input[str]:
        """
        The description for the DB subnet group.
        """
        return pulumi.get(self, "db_subnet_group_description")

    @db_subnet_group_description.setter
    def db_subnet_group_description(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_subnet_group_description", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The EC2 Subnet IDs for the DB subnet group.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the DB subnet group. This value is stored as a lowercase string.
         Constraints:
          +  Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.
          +  Must not be default.
          +  First character must be a letter.
          
         Example: ``mydbsubnetgroup``
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags to assign to the DB subnet group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class DbSubnetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_subnet_group_description: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The ``AWS::RDS::DBSubnetGroup`` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
         For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide*.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_subnet_group_description: The description for the DB subnet group.
        :param pulumi.Input[str] db_subnet_group_name: The name for the DB subnet group. This value is stored as a lowercase string.
                Constraints:
                 +  Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.
                 +  Must not be default.
                 +  First character must be a letter.
                 
                Example: ``mydbsubnetgroup``
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The EC2 Subnet IDs for the DB subnet group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags to assign to the DB subnet group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbSubnetGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::RDS::DBSubnetGroup`` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
         For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide*.

        :param str resource_name: The name of the resource.
        :param DbSubnetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbSubnetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_subnet_group_description: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbSubnetGroupArgs.__new__(DbSubnetGroupArgs)

            if db_subnet_group_description is None and not opts.urn:
                raise TypeError("Missing required property 'db_subnet_group_description'")
            __props__.__dict__["db_subnet_group_description"] = db_subnet_group_description
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["dbSubnetGroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DbSubnetGroup, __self__).__init__(
            'aws-native:rds:DbSubnetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DbSubnetGroup':
        """
        Get an existing DbSubnetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DbSubnetGroupArgs.__new__(DbSubnetGroupArgs)

        __props__.__dict__["db_subnet_group_description"] = None
        __props__.__dict__["db_subnet_group_name"] = None
        __props__.__dict__["subnet_ids"] = None
        __props__.__dict__["tags"] = None
        return DbSubnetGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbSubnetGroupDescription")
    def db_subnet_group_description(self) -> pulumi.Output[str]:
        """
        The description for the DB subnet group.
        """
        return pulumi.get(self, "db_subnet_group_description")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name for the DB subnet group. This value is stored as a lowercase string.
         Constraints:
          +  Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.
          +  Must not be default.
          +  First character must be a letter.
          
         Example: ``mydbsubnetgroup``
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The EC2 Subnet IDs for the DB subnet group.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags to assign to the DB subnet group.
        """
        return pulumi.get(self, "tags")

