# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['RefreshScheduleArgs', 'RefreshSchedule']

@pulumi.input_type
class RefreshScheduleArgs:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 data_set_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input['RefreshScheduleMapArgs']] = None):
        """
        The set of arguments for constructing a RefreshSchedule resource.
        :param pulumi.Input[str] aws_account_id: The AWS account ID of the account that you are creating a schedule in.
        :param pulumi.Input[str] data_set_id: The ID of the dataset that you are creating a refresh schedule for.
        :param pulumi.Input['RefreshScheduleMapArgs'] schedule: The refresh schedule of a dataset.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if data_set_id is not None:
            pulumi.set(__self__, "data_set_id", data_set_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID of the account that you are creating a schedule in.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dataset that you are creating a refresh schedule for.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_set_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['RefreshScheduleMapArgs']]:
        """
        The refresh schedule of a dataset.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['RefreshScheduleMapArgs']]):
        pulumi.set(self, "schedule", value)


class RefreshSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 data_set_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['RefreshScheduleMapArgs', 'RefreshScheduleMapArgsDict']]] = None,
                 __props__=None):
        """
        Definition of the AWS::QuickSight::RefreshSchedule Resource Type.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_account_id: The AWS account ID of the account that you are creating a schedule in.
        :param pulumi.Input[str] data_set_id: The ID of the dataset that you are creating a refresh schedule for.
        :param pulumi.Input[Union['RefreshScheduleMapArgs', 'RefreshScheduleMapArgsDict']] schedule: The refresh schedule of a dataset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RefreshScheduleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of the AWS::QuickSight::RefreshSchedule Resource Type.

        :param str resource_name: The name of the resource.
        :param RefreshScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RefreshScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 data_set_id: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['RefreshScheduleMapArgs', 'RefreshScheduleMapArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RefreshScheduleArgs.__new__(RefreshScheduleArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["data_set_id"] = data_set_id
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["awsAccountId", "dataSetId", "schedule.scheduleId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RefreshSchedule, __self__).__init__(
            'aws-native:quicksight:RefreshSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RefreshSchedule':
        """
        Get an existing RefreshSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RefreshScheduleArgs.__new__(RefreshScheduleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_account_id"] = None
        __props__.__dict__["data_set_id"] = None
        __props__.__dict__["schedule"] = None
        return RefreshSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        <p>The Amazon Resource Name (ARN) of the data source.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS account ID of the account that you are creating a schedule in.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the dataset that you are creating a refresh schedule for.
        """
        return pulumi.get(self, "data_set_id")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.RefreshScheduleMap']]:
        """
        The refresh schedule of a dataset.
        """
        return pulumi.get(self, "schedule")

