# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetVpcConnectionResult',
    'AwaitableGetVpcConnectionResult',
    'get_vpc_connection',
    'get_vpc_connection_output',
]

@pulumi.output_type
class GetVpcConnectionResult:
    def __init__(__self__, arn=None, availability_status=None, created_time=None, dns_resolvers=None, last_updated_time=None, name=None, network_interfaces=None, role_arn=None, security_group_ids=None, status=None, tags=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if availability_status and not isinstance(availability_status, str):
            raise TypeError("Expected argument 'availability_status' to be a str")
        pulumi.set(__self__, "availability_status", availability_status)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if dns_resolvers and not isinstance(dns_resolvers, list):
            raise TypeError("Expected argument 'dns_resolvers' to be a list")
        pulumi.set(__self__, "dns_resolvers", dns_resolvers)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_interfaces and not isinstance(network_interfaces, list):
            raise TypeError("Expected argument 'network_interfaces' to be a list")
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        <p>The Amazon Resource Name (ARN) of the VPC connection.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional['VpcConnectionVpcConnectionAvailabilityStatus']:
        """
        The availability status of the VPC connection.
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        <p>The time that the VPC connection was created.</p>
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="dnsResolvers")
    def dns_resolvers(self) -> Optional[Sequence[str]]:
        """
        A list of IP addresses of DNS resolver endpoints for the VPC connection.
        """
        return pulumi.get(self, "dns_resolvers")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        <p>The time that the VPC connection was last updated.</p>
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The display name for the VPC connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.VpcConnectionNetworkInterface']]:
        """
        <p>A list of network interfaces.</p>
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM role associated with the VPC connection.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        The Amazon EC2 security group IDs associated with the VPC connection.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> Optional['VpcConnectionVpcConnectionResourceStatus']:
        """
        The HTTP status of the request.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A map of the key-value pairs for the resource tag or tags assigned to the VPC connection.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        <p>The Amazon EC2 VPC ID associated with the VPC connection.</p>
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetVpcConnectionResult(GetVpcConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcConnectionResult(
            arn=self.arn,
            availability_status=self.availability_status,
            created_time=self.created_time,
            dns_resolvers=self.dns_resolvers,
            last_updated_time=self.last_updated_time,
            name=self.name,
            network_interfaces=self.network_interfaces,
            role_arn=self.role_arn,
            security_group_ids=self.security_group_ids,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_vpc_connection(aws_account_id: Optional[str] = None,
                       vpc_connection_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcConnectionResult:
    """
    Definition of the AWS::QuickSight::VPCConnection Resource Type.


    :param str aws_account_id: The AWS account ID of the account where you want to create a new VPC connection.
    :param str vpc_connection_id: The ID of the VPC connection that you're creating. This ID is a unique identifier for each AWS Region in an AWS account.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['vpcConnectionId'] = vpc_connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:quicksight:getVpcConnection', __args__, opts=opts, typ=GetVpcConnectionResult).value

    return AwaitableGetVpcConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        availability_status=pulumi.get(__ret__, 'availability_status'),
        created_time=pulumi.get(__ret__, 'created_time'),
        dns_resolvers=pulumi.get(__ret__, 'dns_resolvers'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        name=pulumi.get(__ret__, 'name'),
        network_interfaces=pulumi.get(__ret__, 'network_interfaces'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_vpc_connection_output(aws_account_id: Optional[pulumi.Input[str]] = None,
                              vpc_connection_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcConnectionResult]:
    """
    Definition of the AWS::QuickSight::VPCConnection Resource Type.


    :param str aws_account_id: The AWS account ID of the account where you want to create a new VPC connection.
    :param str vpc_connection_id: The ID of the VPC connection that you're creating. This ID is a unique identifier for each AWS Region in an AWS account.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['vpcConnectionId'] = vpc_connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:quicksight:getVpcConnection', __args__, opts=opts, typ=GetVpcConnectionResult)
    return __ret__.apply(lambda __response__: GetVpcConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        availability_status=pulumi.get(__response__, 'availability_status'),
        created_time=pulumi.get(__response__, 'created_time'),
        dns_resolvers=pulumi.get(__response__, 'dns_resolvers'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        name=pulumi.get(__response__, 'name'),
        network_interfaces=pulumi.get(__response__, 'network_interfaces'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
