# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'StreamKinesisConfigurationArgs',
    'StreamKinesisConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class StreamKinesisConfigurationArgsDict(TypedDict):
        aggregation_enabled: NotRequired[pulumi.Input[bool]]
        """
        Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call.

        Default: `True`

        > Record aggregation has important implications for processing records and requires de-aggregation in your stream consumer. To learn more, see [KPL Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html) and [Consumer De-aggregation](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html) in the *Amazon Kinesis Data Streams Developer Guide* .
        """
        stream_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
        """
elif False:
    StreamKinesisConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamKinesisConfigurationArgs:
    def __init__(__self__, *,
                 aggregation_enabled: Optional[pulumi.Input[bool]] = None,
                 stream_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] aggregation_enabled: Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call.
               
               Default: `True`
               
               > Record aggregation has important implications for processing records and requires de-aggregation in your stream consumer. To learn more, see [KPL Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html) and [Consumer De-aggregation](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html) in the *Amazon Kinesis Data Streams Developer Guide* .
        :param pulumi.Input[str] stream_arn: The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
        """
        if aggregation_enabled is not None:
            pulumi.set(__self__, "aggregation_enabled", aggregation_enabled)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="aggregationEnabled")
    def aggregation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call.

        Default: `True`

        > Record aggregation has important implications for processing records and requires de-aggregation in your stream consumer. To learn more, see [KPL Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html) and [Consumer De-aggregation](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html) in the *Amazon Kinesis Data Streams Developer Guide* .
        """
        return pulumi.get(self, "aggregation_enabled")

    @aggregation_enabled.setter
    def aggregation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aggregation_enabled", value)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_arn", value)


