# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PluginArgs', 'Plugin']

@pulumi.input_type
class PluginArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 auth_configuration: pulumi.Input[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgs']],
                 display_name: pulumi.Input[str],
                 type: pulumi.Input['PluginType'],
                 custom_plugin_configuration: Optional[pulumi.Input['PluginCustomPluginConfigurationArgs']] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['PluginState']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Plugin resource.
        :param pulumi.Input[str] application_id: The identifier of the application that will contain the plugin.
        :param pulumi.Input[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgs']] auth_configuration: Authentication configuration information for an Amazon Q Business plugin.
        :param pulumi.Input[str] display_name: The name of the plugin.
        :param pulumi.Input['PluginType'] type: The type of the plugin.
        :param pulumi.Input['PluginCustomPluginConfigurationArgs'] custom_plugin_configuration: Configuration information required to create a custom plugin.
        :param pulumi.Input[str] server_url: The plugin server URL used for configuration.
        :param pulumi.Input['PluginState'] state: The current status of the plugin.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "auth_configuration", auth_configuration)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "type", type)
        if custom_plugin_configuration is not None:
            pulumi.set(__self__, "custom_plugin_configuration", custom_plugin_configuration)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        The identifier of the application that will contain the plugin.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="authConfiguration")
    def auth_configuration(self) -> pulumi.Input[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgs']]:
        """
        Authentication configuration information for an Amazon Q Business plugin.
        """
        return pulumi.get(self, "auth_configuration")

    @auth_configuration.setter
    def auth_configuration(self, value: pulumi.Input[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgs']]):
        pulumi.set(self, "auth_configuration", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The name of the plugin.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['PluginType']:
        """
        The type of the plugin.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['PluginType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="customPluginConfiguration")
    def custom_plugin_configuration(self) -> Optional[pulumi.Input['PluginCustomPluginConfigurationArgs']]:
        """
        Configuration information required to create a custom plugin.
        """
        return pulumi.get(self, "custom_plugin_configuration")

    @custom_plugin_configuration.setter
    def custom_plugin_configuration(self, value: Optional[pulumi.Input['PluginCustomPluginConfigurationArgs']]):
        pulumi.set(self, "custom_plugin_configuration", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[str]]:
        """
        The plugin server URL used for configuration.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['PluginState']]:
        """
        The current status of the plugin.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['PluginState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Plugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 auth_configuration: Optional[pulumi.Input[Union[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration0PropertiesArgsDict'], Union['PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgsDict'], Union['PluginAuthConfiguration2PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgsDict']]]] = None,
                 custom_plugin_configuration: Optional[pulumi.Input[Union['PluginCustomPluginConfigurationArgs', 'PluginCustomPluginConfigurationArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['PluginState']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['PluginType']] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::Plugin Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The identifier of the application that will contain the plugin.
        :param pulumi.Input[Union[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration0PropertiesArgsDict'], Union['PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgsDict'], Union['PluginAuthConfiguration2PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgsDict']]] auth_configuration: Authentication configuration information for an Amazon Q Business plugin.
        :param pulumi.Input[Union['PluginCustomPluginConfigurationArgs', 'PluginCustomPluginConfigurationArgsDict']] custom_plugin_configuration: Configuration information required to create a custom plugin.
        :param pulumi.Input[str] display_name: The name of the plugin.
        :param pulumi.Input[str] server_url: The plugin server URL used for configuration.
        :param pulumi.Input['PluginState'] state: The current status of the plugin.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        :param pulumi.Input['PluginType'] type: The type of the plugin.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::Plugin Resource Type

        :param str resource_name: The name of the resource.
        :param PluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 auth_configuration: Optional[pulumi.Input[Union[Union['PluginAuthConfiguration0PropertiesArgs', 'PluginAuthConfiguration0PropertiesArgsDict'], Union['PluginAuthConfiguration1PropertiesArgs', 'PluginAuthConfiguration1PropertiesArgsDict'], Union['PluginAuthConfiguration2PropertiesArgs', 'PluginAuthConfiguration2PropertiesArgsDict']]]] = None,
                 custom_plugin_configuration: Optional[pulumi.Input[Union['PluginCustomPluginConfigurationArgs', 'PluginCustomPluginConfigurationArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['PluginState']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['PluginType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginArgs.__new__(PluginArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if auth_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'auth_configuration'")
            __props__.__dict__["auth_configuration"] = auth_configuration
            __props__.__dict__["custom_plugin_configuration"] = custom_plugin_configuration
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["server_url"] = server_url
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["build_status"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["plugin_arn"] = None
            __props__.__dict__["plugin_id"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationId", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Plugin, __self__).__init__(
            'aws-native:qbusiness:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PluginArgs.__new__(PluginArgs)

        __props__.__dict__["application_id"] = None
        __props__.__dict__["auth_configuration"] = None
        __props__.__dict__["build_status"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["custom_plugin_configuration"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["plugin_arn"] = None
        __props__.__dict__["plugin_id"] = None
        __props__.__dict__["server_url"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["updated_at"] = None
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        The identifier of the application that will contain the plugin.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="authConfiguration")
    def auth_configuration(self) -> pulumi.Output[Any]:
        """
        Authentication configuration information for an Amazon Q Business plugin.
        """
        return pulumi.get(self, "auth_configuration")

    @property
    @pulumi.getter(name="buildStatus")
    def build_status(self) -> pulumi.Output['PluginBuildStatus']:
        """
        The current status of a plugin. A plugin is modified asynchronously.
        """
        return pulumi.get(self, "build_status")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp for when the plugin was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customPluginConfiguration")
    def custom_plugin_configuration(self) -> pulumi.Output[Optional['outputs.PluginCustomPluginConfiguration']]:
        """
        Configuration information required to create a custom plugin.
        """
        return pulumi.get(self, "custom_plugin_configuration")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The name of the plugin.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="pluginArn")
    def plugin_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of a plugin.
        """
        return pulumi.get(self, "plugin_arn")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[str]:
        """
        The identifier of the plugin.
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[Optional[str]]:
        """
        The plugin server URL used for configuration.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional['PluginState']]:
        """
        The current status of the plugin.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['PluginType']:
        """
        The type of the plugin.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The timestamp for when the plugin was last updated.
        """
        return pulumi.get(self, "updated_at")

