# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationAttachmentsConfiguration',
    'ApplicationAutoSubscriptionConfiguration',
    'ApplicationEncryptionConfiguration',
    'ApplicationPersonalizationConfiguration',
    'ApplicationQAppsConfiguration',
    'DataSourceDocumentAttributeCondition',
    'DataSourceDocumentAttributeTarget',
    'DataSourceDocumentAttributeValue0Properties',
    'DataSourceDocumentAttributeValue1Properties',
    'DataSourceDocumentAttributeValue2Properties',
    'DataSourceDocumentAttributeValue3Properties',
    'DataSourceDocumentEnrichmentConfiguration',
    'DataSourceHookConfiguration',
    'DataSourceInlineDocumentEnrichmentConfiguration',
    'DataSourceVpcConfiguration',
    'IndexCapacityConfiguration',
    'IndexDocumentAttributeConfiguration',
    'IndexStatistics',
    'IndexTextDocumentStatistics',
    'PluginApiSchema0Properties',
    'PluginApiSchema1Properties',
    'PluginAuthConfiguration0Properties',
    'PluginAuthConfiguration1Properties',
    'PluginAuthConfiguration2Properties',
    'PluginBasicAuthConfiguration',
    'PluginCustomPluginConfiguration',
    'PluginNoAuthConfiguration',
    'PluginOAuth2ClientCredentialConfiguration',
    'PluginS3',
    'RetrieverConfiguration0Properties',
    'RetrieverConfiguration1Properties',
    'RetrieverKendraIndexConfiguration',
    'RetrieverNativeIndexConfiguration',
    'WebExperienceIdentityProviderConfiguration0Properties',
    'WebExperienceIdentityProviderConfiguration1Properties',
    'WebExperienceOpenIdConnectProviderConfiguration',
    'WebExperienceSamlProviderConfiguration',
]

@pulumi.output_type
class ApplicationAttachmentsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachmentsControlMode":
            suggest = "attachments_control_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAttachmentsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAttachmentsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAttachmentsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attachments_control_mode: 'ApplicationAttachmentsControlMode'):
        """
        :param 'ApplicationAttachmentsControlMode' attachments_control_mode: Status information about whether file upload functionality is activated or deactivated for your end user.
        """
        pulumi.set(__self__, "attachments_control_mode", attachments_control_mode)

    @property
    @pulumi.getter(name="attachmentsControlMode")
    def attachments_control_mode(self) -> 'ApplicationAttachmentsControlMode':
        """
        Status information about whether file upload functionality is activated or deactivated for your end user.
        """
        return pulumi.get(self, "attachments_control_mode")


@pulumi.output_type
class ApplicationAutoSubscriptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSubscribe":
            suggest = "auto_subscribe"
        elif key == "defaultSubscriptionType":
            suggest = "default_subscription_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAutoSubscriptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAutoSubscriptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAutoSubscriptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_subscribe: 'ApplicationAutoSubscriptionStatus',
                 default_subscription_type: Optional['ApplicationSubscriptionType'] = None):
        """
        :param 'ApplicationAutoSubscriptionStatus' auto_subscribe: Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity federation for user management.
        :param 'ApplicationSubscriptionType' default_subscription_type: Describes the default subscription type assigned to an Amazon Q Business application using IAM identity federation for user management. If the value for `autoSubscribe` is set to `ENABLED` you must select a value for this field.
        """
        pulumi.set(__self__, "auto_subscribe", auto_subscribe)
        if default_subscription_type is not None:
            pulumi.set(__self__, "default_subscription_type", default_subscription_type)

    @property
    @pulumi.getter(name="autoSubscribe")
    def auto_subscribe(self) -> 'ApplicationAutoSubscriptionStatus':
        """
        Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity federation for user management.
        """
        return pulumi.get(self, "auto_subscribe")

    @property
    @pulumi.getter(name="defaultSubscriptionType")
    def default_subscription_type(self) -> Optional['ApplicationSubscriptionType']:
        """
        Describes the default subscription type assigned to an Amazon Q Business application using IAM identity federation for user management. If the value for `autoSubscribe` is set to `ENABLED` you must select a value for this field.
        """
        return pulumi.get(self, "default_subscription_type")


@pulumi.output_type
class ApplicationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        :param str kms_key_id: The identifier of the AWS KMS key. Amazon Q Business doesn't support asymmetric keys.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The identifier of the AWS KMS key. Amazon Q Business doesn't support asymmetric keys.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ApplicationPersonalizationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "personalizationControlMode":
            suggest = "personalization_control_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationPersonalizationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationPersonalizationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationPersonalizationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 personalization_control_mode: 'ApplicationPersonalizationControlMode'):
        """
        :param 'ApplicationPersonalizationControlMode' personalization_control_mode: An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically, location and job information—in your IAM Identity Center instance.
        """
        pulumi.set(__self__, "personalization_control_mode", personalization_control_mode)

    @property
    @pulumi.getter(name="personalizationControlMode")
    def personalization_control_mode(self) -> 'ApplicationPersonalizationControlMode':
        """
        An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically, location and job information—in your IAM Identity Center instance.
        """
        return pulumi.get(self, "personalization_control_mode")


@pulumi.output_type
class ApplicationQAppsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "qAppsControlMode":
            suggest = "q_apps_control_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationQAppsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationQAppsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationQAppsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 q_apps_control_mode: 'ApplicationQAppsControlMode'):
        """
        :param 'ApplicationQAppsControlMode' q_apps_control_mode: Status information about whether end users can create and use Amazon Q Apps in the web experience.
        """
        pulumi.set(__self__, "q_apps_control_mode", q_apps_control_mode)

    @property
    @pulumi.getter(name="qAppsControlMode")
    def q_apps_control_mode(self) -> 'ApplicationQAppsControlMode':
        """
        Status information about whether end users can create and use Amazon Q Apps in the web experience.
        """
        return pulumi.get(self, "q_apps_control_mode")


@pulumi.output_type
class DataSourceDocumentAttributeCondition(dict):
    def __init__(__self__, *,
                 key: str,
                 operator: 'DataSourceDocumentEnrichmentConditionOperator',
                 value: Optional[Any] = None):
        """
        :param str key: The identifier of the document attribute used for the condition.
               
               For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
               
               Amazon Q Business currently doesn't support `_document_body` as an attribute key used for the condition.
        :param 'DataSourceDocumentEnrichmentConditionOperator' operator: The identifier of the document attribute used for the condition.
               
               For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
               
               Amazon Q Business currently does not support `_document_body` as an attribute key used for the condition.
        :param Union['DataSourceDocumentAttributeValue0Properties', 'DataSourceDocumentAttributeValue1Properties', 'DataSourceDocumentAttributeValue2Properties', 'DataSourceDocumentAttributeValue3Properties'] value: The value of a document attribute. You can only provide one value for a document attribute.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The identifier of the document attribute used for the condition.

        For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.

        Amazon Q Business currently doesn't support `_document_body` as an attribute key used for the condition.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> 'DataSourceDocumentEnrichmentConditionOperator':
        """
        The identifier of the document attribute used for the condition.

        For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.

        Amazon Q Business currently does not support `_document_body` as an attribute key used for the condition.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value of a document attribute. You can only provide one value for a document attribute.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataSourceDocumentAttributeTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeValueOperator":
            suggest = "attribute_value_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDocumentAttributeTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDocumentAttributeTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDocumentAttributeTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 attribute_value_operator: Optional['DataSourceAttributeValueOperator'] = None,
                 value: Optional[Any] = None):
        """
        :param str key: The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
        :param 'DataSourceAttributeValueOperator' attribute_value_operator: `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE` .
        :param Union['DataSourceDocumentAttributeValue0Properties', 'DataSourceDocumentAttributeValue1Properties', 'DataSourceDocumentAttributeValue2Properties', 'DataSourceDocumentAttributeValue3Properties'] value: The value of a document attribute. You can only provide one value for a document attribute.
        """
        pulumi.set(__self__, "key", key)
        if attribute_value_operator is not None:
            pulumi.set(__self__, "attribute_value_operator", attribute_value_operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="attributeValueOperator")
    def attribute_value_operator(self) -> Optional['DataSourceAttributeValueOperator']:
        """
        `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE` .
        """
        return pulumi.get(self, "attribute_value_operator")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value of a document attribute. You can only provide one value for a document attribute.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DataSourceDocumentAttributeValue0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDocumentAttributeValue0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDocumentAttributeValue0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDocumentAttributeValue0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_value: str):
        pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> str:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DataSourceDocumentAttributeValue1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringListValue":
            suggest = "string_list_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDocumentAttributeValue1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDocumentAttributeValue1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDocumentAttributeValue1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_list_value: Sequence[str]):
        pulumi.set(__self__, "string_list_value", string_list_value)

    @property
    @pulumi.getter(name="stringListValue")
    def string_list_value(self) -> Sequence[str]:
        return pulumi.get(self, "string_list_value")


@pulumi.output_type
class DataSourceDocumentAttributeValue2Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "longValue":
            suggest = "long_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDocumentAttributeValue2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDocumentAttributeValue2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDocumentAttributeValue2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 long_value: float):
        pulumi.set(__self__, "long_value", long_value)

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> float:
        return pulumi.get(self, "long_value")


@pulumi.output_type
class DataSourceDocumentAttributeValue3Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateValue":
            suggest = "date_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDocumentAttributeValue3Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDocumentAttributeValue3Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDocumentAttributeValue3Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_value: str):
        pulumi.set(__self__, "date_value", date_value)

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> str:
        return pulumi.get(self, "date_value")


@pulumi.output_type
class DataSourceDocumentEnrichmentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inlineConfigurations":
            suggest = "inline_configurations"
        elif key == "postExtractionHookConfiguration":
            suggest = "post_extraction_hook_configuration"
        elif key == "preExtractionHookConfiguration":
            suggest = "pre_extraction_hook_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDocumentEnrichmentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDocumentEnrichmentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDocumentEnrichmentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline_configurations: Optional[Sequence['outputs.DataSourceInlineDocumentEnrichmentConfiguration']] = None,
                 post_extraction_hook_configuration: Optional['outputs.DataSourceHookConfiguration'] = None,
                 pre_extraction_hook_configuration: Optional['outputs.DataSourceHookConfiguration'] = None):
        """
        :param Sequence['DataSourceInlineDocumentEnrichmentConfiguration'] inline_configurations: Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q Business.
        :param 'DataSourceHookConfiguration' post_extraction_hook_configuration: Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Using Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html) .
        :param 'DataSourceHookConfiguration' pre_extraction_hook_configuration: Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Using Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html) .
        """
        if inline_configurations is not None:
            pulumi.set(__self__, "inline_configurations", inline_configurations)
        if post_extraction_hook_configuration is not None:
            pulumi.set(__self__, "post_extraction_hook_configuration", post_extraction_hook_configuration)
        if pre_extraction_hook_configuration is not None:
            pulumi.set(__self__, "pre_extraction_hook_configuration", pre_extraction_hook_configuration)

    @property
    @pulumi.getter(name="inlineConfigurations")
    def inline_configurations(self) -> Optional[Sequence['outputs.DataSourceInlineDocumentEnrichmentConfiguration']]:
        """
        Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Q Business.
        """
        return pulumi.get(self, "inline_configurations")

    @property
    @pulumi.getter(name="postExtractionHookConfiguration")
    def post_extraction_hook_configuration(self) -> Optional['outputs.DataSourceHookConfiguration']:
        """
        Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Using Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html) .
        """
        return pulumi.get(self, "post_extraction_hook_configuration")

    @property
    @pulumi.getter(name="preExtractionHookConfiguration")
    def pre_extraction_hook_configuration(self) -> Optional['outputs.DataSourceHookConfiguration']:
        """
        Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Using Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html) .
        """
        return pulumi.get(self, "pre_extraction_hook_configuration")


@pulumi.output_type
class DataSourceHookConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationCondition":
            suggest = "invocation_condition"
        elif key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invocation_condition: Optional['outputs.DataSourceDocumentAttributeCondition'] = None,
                 lambda_arn: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 s3_bucket_name: Optional[str] = None):
        """
        :param 'DataSourceDocumentAttributeCondition' invocation_condition: The condition used for when a Lambda function should be invoked.
               
               For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business should invoke a function that inserts the current date-time.
        :param str lambda_arn: The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see [IAM roles for Custom Document Enrichment (CDE)](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html#cde-iam-role) .
        :param str role_arn: The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process.
        :param str s3_bucket_name: Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts) .
        """
        if invocation_condition is not None:
            pulumi.set(__self__, "invocation_condition", invocation_condition)
        if lambda_arn is not None:
            pulumi.set(__self__, "lambda_arn", lambda_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)

    @property
    @pulumi.getter(name="invocationCondition")
    def invocation_condition(self) -> Optional['outputs.DataSourceDocumentAttributeCondition']:
        """
        The condition used for when a Lambda function should be invoked.

        For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business should invoke a function that inserts the current date-time.
        """
        return pulumi.get(self, "invocation_condition")

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see [IAM roles for Custom Document Enrichment (CDE)](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html#cde-iam-role) .
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        """
        Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts) .
        """
        return pulumi.get(self, "s3_bucket_name")


@pulumi.output_type
class DataSourceInlineDocumentEnrichmentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentContentOperator":
            suggest = "document_content_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceInlineDocumentEnrichmentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceInlineDocumentEnrichmentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceInlineDocumentEnrichmentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional['outputs.DataSourceDocumentAttributeCondition'] = None,
                 document_content_operator: Optional['DataSourceDocumentContentOperator'] = None,
                 target: Optional['outputs.DataSourceDocumentAttributeTarget'] = None):
        """
        :param 'DataSourceDocumentAttributeCondition' condition: Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business .
        :param 'DataSourceDocumentContentOperator' document_content_operator: `TRUE` to delete content if the condition used for the target attribute is met.
        :param 'DataSourceDocumentAttributeTarget' target: Configuration of the target document attribute or metadata field when ingesting documents into Amazon Q Business . You can also include a value.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if document_content_operator is not None:
            pulumi.set(__self__, "document_content_operator", document_content_operator)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.DataSourceDocumentAttributeCondition']:
        """
        Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Q Business .
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="documentContentOperator")
    def document_content_operator(self) -> Optional['DataSourceDocumentContentOperator']:
        """
        `TRUE` to delete content if the condition used for the target attribute is met.
        """
        return pulumi.get(self, "document_content_operator")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.DataSourceDocumentAttributeTarget']:
        """
        Configuration of the target document attribute or metadata field when ingesting documents into Amazon Q Business . You can also include a value.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class DataSourceVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnet_ids: Sequence[str]):
        """
        :param Sequence[str] security_group_ids: A list of identifiers of security groups within your Amazon VPC. The security groups should enable Amazon Q Business to connect to the data source.
        :param Sequence[str] subnet_ids: A list of identifiers for subnets within your Amazon VPC. The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        A list of identifiers of security groups within your Amazon VPC. The security groups should enable Amazon Q Business to connect to the data source.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        A list of identifiers for subnets within your Amazon VPC. The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class IndexCapacityConfiguration(dict):
    def __init__(__self__, *,
                 units: Optional[float] = None):
        """
        :param float units: The number of storage units configured for an Amazon Q Business index.
        """
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter
    def units(self) -> Optional[float]:
        """
        The number of storage units configured for an Amazon Q Business index.
        """
        return pulumi.get(self, "units")


@pulumi.output_type
class IndexDocumentAttributeConfiguration(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 search: Optional['QBusinessIndexStatus'] = None,
                 type: Optional['IndexAttributeType'] = None):
        """
        :param str name: The name of the document attribute.
        :param 'QBusinessIndexStatus' search: Information about whether the document attribute can be used by an end user to search for information on their web experience.
        :param 'IndexAttributeType' type: The type of document attribute.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if search is not None:
            pulumi.set(__self__, "search", search)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the document attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def search(self) -> Optional['QBusinessIndexStatus']:
        """
        Information about whether the document attribute can be used by an end user to search for information on their web experience.
        """
        return pulumi.get(self, "search")

    @property
    @pulumi.getter
    def type(self) -> Optional['IndexAttributeType']:
        """
        The type of document attribute.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IndexStatistics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textDocumentStatistics":
            suggest = "text_document_statistics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexStatistics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexStatistics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexStatistics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_document_statistics: Optional['outputs.IndexTextDocumentStatistics'] = None):
        """
        :param 'IndexTextDocumentStatistics' text_document_statistics: The number of documents indexed.
        """
        if text_document_statistics is not None:
            pulumi.set(__self__, "text_document_statistics", text_document_statistics)

    @property
    @pulumi.getter(name="textDocumentStatistics")
    def text_document_statistics(self) -> Optional['outputs.IndexTextDocumentStatistics']:
        """
        The number of documents indexed.
        """
        return pulumi.get(self, "text_document_statistics")


@pulumi.output_type
class IndexTextDocumentStatistics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexedTextBytes":
            suggest = "indexed_text_bytes"
        elif key == "indexedTextDocumentCount":
            suggest = "indexed_text_document_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexTextDocumentStatistics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexTextDocumentStatistics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexTextDocumentStatistics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 indexed_text_bytes: Optional[float] = None,
                 indexed_text_document_count: Optional[float] = None):
        """
        :param float indexed_text_bytes: The total size, in bytes, of the indexed documents.
        :param float indexed_text_document_count: The number of text documents indexed.
        """
        if indexed_text_bytes is not None:
            pulumi.set(__self__, "indexed_text_bytes", indexed_text_bytes)
        if indexed_text_document_count is not None:
            pulumi.set(__self__, "indexed_text_document_count", indexed_text_document_count)

    @property
    @pulumi.getter(name="indexedTextBytes")
    def indexed_text_bytes(self) -> Optional[float]:
        """
        The total size, in bytes, of the indexed documents.
        """
        return pulumi.get(self, "indexed_text_bytes")

    @property
    @pulumi.getter(name="indexedTextDocumentCount")
    def indexed_text_document_count(self) -> Optional[float]:
        """
        The number of text documents indexed.
        """
        return pulumi.get(self, "indexed_text_document_count")


@pulumi.output_type
class PluginApiSchema0Properties(dict):
    def __init__(__self__, *,
                 payload: str):
        pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter
    def payload(self) -> str:
        return pulumi.get(self, "payload")


@pulumi.output_type
class PluginApiSchema1Properties(dict):
    def __init__(__self__, *,
                 s3: 'outputs.PluginS3'):
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.PluginS3':
        return pulumi.get(self, "s3")


@pulumi.output_type
class PluginAuthConfiguration0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuthConfiguration":
            suggest = "basic_auth_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginAuthConfiguration0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginAuthConfiguration0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginAuthConfiguration0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth_configuration: 'outputs.PluginBasicAuthConfiguration'):
        pulumi.set(__self__, "basic_auth_configuration", basic_auth_configuration)

    @property
    @pulumi.getter(name="basicAuthConfiguration")
    def basic_auth_configuration(self) -> 'outputs.PluginBasicAuthConfiguration':
        return pulumi.get(self, "basic_auth_configuration")


@pulumi.output_type
class PluginAuthConfiguration1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oAuth2ClientCredentialConfiguration":
            suggest = "o_auth2_client_credential_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginAuthConfiguration1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginAuthConfiguration1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginAuthConfiguration1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_auth2_client_credential_configuration: 'outputs.PluginOAuth2ClientCredentialConfiguration'):
        pulumi.set(__self__, "o_auth2_client_credential_configuration", o_auth2_client_credential_configuration)

    @property
    @pulumi.getter(name="oAuth2ClientCredentialConfiguration")
    def o_auth2_client_credential_configuration(self) -> 'outputs.PluginOAuth2ClientCredentialConfiguration':
        return pulumi.get(self, "o_auth2_client_credential_configuration")


@pulumi.output_type
class PluginAuthConfiguration2Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noAuthConfiguration":
            suggest = "no_auth_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginAuthConfiguration2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginAuthConfiguration2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginAuthConfiguration2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 no_auth_configuration: 'outputs.PluginNoAuthConfiguration'):
        pulumi.set(__self__, "no_auth_configuration", no_auth_configuration)

    @property
    @pulumi.getter(name="noAuthConfiguration")
    def no_auth_configuration(self) -> 'outputs.PluginNoAuthConfiguration':
        return pulumi.get(self, "no_auth_configuration")


@pulumi.output_type
class PluginBasicAuthConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginBasicAuthConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginBasicAuthConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginBasicAuthConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 secret_arn: str):
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> str:
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class PluginCustomPluginConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiSchema":
            suggest = "api_schema"
        elif key == "apiSchemaType":
            suggest = "api_schema_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginCustomPluginConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginCustomPluginConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginCustomPluginConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_schema: Any,
                 api_schema_type: 'PluginApiSchemaType',
                 description: str):
        """
        :param Union['PluginApiSchema0Properties', 'PluginApiSchema1Properties'] api_schema: Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema.
        :param 'PluginApiSchemaType' api_schema_type: The type of OpenAPI schema to use.
        :param str description: A description for your custom plugin configuration.
        """
        pulumi.set(__self__, "api_schema", api_schema)
        pulumi.set(__self__, "api_schema_type", api_schema_type)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> Any:
        """
        Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema.
        """
        return pulumi.get(self, "api_schema")

    @property
    @pulumi.getter(name="apiSchemaType")
    def api_schema_type(self) -> 'PluginApiSchemaType':
        """
        The type of OpenAPI schema to use.
        """
        return pulumi.get(self, "api_schema_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for your custom plugin configuration.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PluginNoAuthConfiguration(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class PluginOAuth2ClientCredentialConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginOAuth2ClientCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginOAuth2ClientCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginOAuth2ClientCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 secret_arn: str):
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> str:
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class PluginS3(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class RetrieverConfiguration0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nativeIndexConfiguration":
            suggest = "native_index_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetrieverConfiguration0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetrieverConfiguration0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetrieverConfiguration0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 native_index_configuration: 'outputs.RetrieverNativeIndexConfiguration'):
        pulumi.set(__self__, "native_index_configuration", native_index_configuration)

    @property
    @pulumi.getter(name="nativeIndexConfiguration")
    def native_index_configuration(self) -> 'outputs.RetrieverNativeIndexConfiguration':
        return pulumi.get(self, "native_index_configuration")


@pulumi.output_type
class RetrieverConfiguration1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kendraIndexConfiguration":
            suggest = "kendra_index_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetrieverConfiguration1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetrieverConfiguration1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetrieverConfiguration1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kendra_index_configuration: 'outputs.RetrieverKendraIndexConfiguration'):
        pulumi.set(__self__, "kendra_index_configuration", kendra_index_configuration)

    @property
    @pulumi.getter(name="kendraIndexConfiguration")
    def kendra_index_configuration(self) -> 'outputs.RetrieverKendraIndexConfiguration':
        return pulumi.get(self, "kendra_index_configuration")


@pulumi.output_type
class RetrieverKendraIndexConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexId":
            suggest = "index_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetrieverKendraIndexConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetrieverKendraIndexConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetrieverKendraIndexConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_id: str):
        pulumi.set(__self__, "index_id", index_id)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> str:
        return pulumi.get(self, "index_id")


@pulumi.output_type
class RetrieverNativeIndexConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexId":
            suggest = "index_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetrieverNativeIndexConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetrieverNativeIndexConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetrieverNativeIndexConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_id: str):
        pulumi.set(__self__, "index_id", index_id)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> str:
        return pulumi.get(self, "index_id")


@pulumi.output_type
class WebExperienceIdentityProviderConfiguration0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samlConfiguration":
            suggest = "saml_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebExperienceIdentityProviderConfiguration0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebExperienceIdentityProviderConfiguration0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebExperienceIdentityProviderConfiguration0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 saml_configuration: 'outputs.WebExperienceSamlProviderConfiguration'):
        pulumi.set(__self__, "saml_configuration", saml_configuration)

    @property
    @pulumi.getter(name="samlConfiguration")
    def saml_configuration(self) -> 'outputs.WebExperienceSamlProviderConfiguration':
        return pulumi.get(self, "saml_configuration")


@pulumi.output_type
class WebExperienceIdentityProviderConfiguration1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openIdConnectConfiguration":
            suggest = "open_id_connect_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebExperienceIdentityProviderConfiguration1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebExperienceIdentityProviderConfiguration1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebExperienceIdentityProviderConfiguration1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_id_connect_configuration: 'outputs.WebExperienceOpenIdConnectProviderConfiguration'):
        pulumi.set(__self__, "open_id_connect_configuration", open_id_connect_configuration)

    @property
    @pulumi.getter(name="openIdConnectConfiguration")
    def open_id_connect_configuration(self) -> 'outputs.WebExperienceOpenIdConnectProviderConfiguration':
        return pulumi.get(self, "open_id_connect_configuration")


@pulumi.output_type
class WebExperienceOpenIdConnectProviderConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretsArn":
            suggest = "secrets_arn"
        elif key == "secretsRole":
            suggest = "secrets_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebExperienceOpenIdConnectProviderConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebExperienceOpenIdConnectProviderConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebExperienceOpenIdConnectProviderConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secrets_arn: str,
                 secrets_role: str):
        pulumi.set(__self__, "secrets_arn", secrets_arn)
        pulumi.set(__self__, "secrets_role", secrets_role)

    @property
    @pulumi.getter(name="secretsArn")
    def secrets_arn(self) -> str:
        return pulumi.get(self, "secrets_arn")

    @property
    @pulumi.getter(name="secretsRole")
    def secrets_role(self) -> str:
        return pulumi.get(self, "secrets_role")


@pulumi.output_type
class WebExperienceSamlProviderConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationUrl":
            suggest = "authentication_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebExperienceSamlProviderConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebExperienceSamlProviderConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebExperienceSamlProviderConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_url: str):
        pulumi.set(__self__, "authentication_url", authentication_url)

    @property
    @pulumi.getter(name="authenticationUrl")
    def authentication_url(self) -> str:
        return pulumi.get(self, "authentication_url")


