# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRetrieverResult',
    'AwaitableGetRetrieverResult',
    'get_retriever',
    'get_retriever_output',
]

@pulumi.output_type
class GetRetrieverResult:
    def __init__(__self__, configuration=None, created_at=None, display_name=None, retriever_arn=None, retriever_id=None, role_arn=None, status=None, tags=None, updated_at=None):
        if configuration and not isinstance(configuration, dict):
            raise TypeError("Expected argument 'configuration' to be a dict")
        pulumi.set(__self__, "configuration", configuration)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if retriever_arn and not isinstance(retriever_arn, str):
            raise TypeError("Expected argument 'retriever_arn' to be a str")
        pulumi.set(__self__, "retriever_arn", retriever_arn)
        if retriever_id and not isinstance(retriever_id, str):
            raise TypeError("Expected argument 'retriever_id' to be a str")
        pulumi.set(__self__, "retriever_id", retriever_id)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        Provides information on how the retriever used for your Amazon Q Business application is configured.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The Unix timestamp when the retriever was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of your retriever.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="retrieverArn")
    def retriever_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
        """
        return pulumi.get(self, "retriever_arn")

    @property
    @pulumi.getter(name="retrieverId")
    def retriever_id(self) -> Optional[str]:
        """
        The identifier of the retriever used by your Amazon Q Business application.
        """
        return pulumi.get(self, "retriever_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional['RetrieverStatus']:
        """
        The status of your retriever.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The Unix timestamp when the retriever was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetRetrieverResult(GetRetrieverResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRetrieverResult(
            configuration=self.configuration,
            created_at=self.created_at,
            display_name=self.display_name,
            retriever_arn=self.retriever_arn,
            retriever_id=self.retriever_id,
            role_arn=self.role_arn,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at)


def get_retriever(application_id: Optional[str] = None,
                  retriever_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRetrieverResult:
    """
    Definition of AWS::QBusiness::Retriever Resource Type


    :param str application_id: The identifier of the Amazon Q Business application using the retriever.
    :param str retriever_id: The identifier of the retriever used by your Amazon Q Business application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['retrieverId'] = retriever_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:qbusiness:getRetriever', __args__, opts=opts, typ=GetRetrieverResult).value

    return AwaitableGetRetrieverResult(
        configuration=pulumi.get(__ret__, 'configuration'),
        created_at=pulumi.get(__ret__, 'created_at'),
        display_name=pulumi.get(__ret__, 'display_name'),
        retriever_arn=pulumi.get(__ret__, 'retriever_arn'),
        retriever_id=pulumi.get(__ret__, 'retriever_id'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_retriever_output(application_id: Optional[pulumi.Input[str]] = None,
                         retriever_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRetrieverResult]:
    """
    Definition of AWS::QBusiness::Retriever Resource Type


    :param str application_id: The identifier of the Amazon Q Business application using the retriever.
    :param str retriever_id: The identifier of the retriever used by your Amazon Q Business application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['retrieverId'] = retriever_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:qbusiness:getRetriever', __args__, opts=opts, typ=GetRetrieverResult)
    return __ret__.apply(lambda __response__: GetRetrieverResult(
        configuration=pulumi.get(__response__, 'configuration'),
        created_at=pulumi.get(__response__, 'created_at'),
        display_name=pulumi.get(__response__, 'display_name'),
        retriever_arn=pulumi.get(__response__, 'retriever_arn'),
        retriever_id=pulumi.get(__response__, 'retriever_id'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
