# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetIndexResult',
    'AwaitableGetIndexResult',
    'get_index',
    'get_index_output',
]

@pulumi.output_type
class GetIndexResult:
    def __init__(__self__, capacity_configuration=None, created_at=None, description=None, display_name=None, document_attribute_configurations=None, index_arn=None, index_id=None, index_statistics=None, status=None, tags=None, updated_at=None):
        if capacity_configuration and not isinstance(capacity_configuration, dict):
            raise TypeError("Expected argument 'capacity_configuration' to be a dict")
        pulumi.set(__self__, "capacity_configuration", capacity_configuration)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if document_attribute_configurations and not isinstance(document_attribute_configurations, list):
            raise TypeError("Expected argument 'document_attribute_configurations' to be a list")
        pulumi.set(__self__, "document_attribute_configurations", document_attribute_configurations)
        if index_arn and not isinstance(index_arn, str):
            raise TypeError("Expected argument 'index_arn' to be a str")
        pulumi.set(__self__, "index_arn", index_arn)
        if index_id and not isinstance(index_id, str):
            raise TypeError("Expected argument 'index_id' to be a str")
        pulumi.set(__self__, "index_id", index_id)
        if index_statistics and not isinstance(index_statistics, dict):
            raise TypeError("Expected argument 'index_statistics' to be a dict")
        pulumi.set(__self__, "index_statistics", index_statistics)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="capacityConfiguration")
    def capacity_configuration(self) -> Optional['outputs.IndexCapacityConfiguration']:
        """
        The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
        """
        return pulumi.get(self, "capacity_configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The Unix timestamp when the index was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the Amazon Q Business index.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the index.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="documentAttributeConfigurations")
    def document_attribute_configurations(self) -> Optional[Sequence['outputs.IndexDocumentAttributeConfiguration']]:
        """
        Configuration information for document attributes. Document attributes are metadata or fields associated with your documents. For example, the company department name associated with each document.

        For more information, see [Understanding document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html) .
        """
        return pulumi.get(self, "document_attribute_configurations")

    @property
    @pulumi.getter(name="indexArn")
    def index_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an Amazon Q Business index.
        """
        return pulumi.get(self, "index_arn")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> Optional[str]:
        """
        The identifier for the index.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="indexStatistics")
    def index_statistics(self) -> Optional['outputs.IndexStatistics']:
        return pulumi.get(self, "index_statistics")

    @property
    @pulumi.getter
    def status(self) -> Optional['IndexStatus']:
        """
        The current status of the index. When the status is `ACTIVE` , the index is ready.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The Unix timestamp when the index was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetIndexResult(GetIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexResult(
            capacity_configuration=self.capacity_configuration,
            created_at=self.created_at,
            description=self.description,
            display_name=self.display_name,
            document_attribute_configurations=self.document_attribute_configurations,
            index_arn=self.index_arn,
            index_id=self.index_id,
            index_statistics=self.index_statistics,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at)


def get_index(application_id: Optional[str] = None,
              index_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexResult:
    """
    Definition of AWS::QBusiness::Index Resource Type


    :param str application_id: The identifier of the Amazon Q Business application using the index.
    :param str index_id: The identifier for the index.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['indexId'] = index_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:qbusiness:getIndex', __args__, opts=opts, typ=GetIndexResult).value

    return AwaitableGetIndexResult(
        capacity_configuration=pulumi.get(__ret__, 'capacity_configuration'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        document_attribute_configurations=pulumi.get(__ret__, 'document_attribute_configurations'),
        index_arn=pulumi.get(__ret__, 'index_arn'),
        index_id=pulumi.get(__ret__, 'index_id'),
        index_statistics=pulumi.get(__ret__, 'index_statistics'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_index_output(application_id: Optional[pulumi.Input[str]] = None,
                     index_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIndexResult]:
    """
    Definition of AWS::QBusiness::Index Resource Type


    :param str application_id: The identifier of the Amazon Q Business application using the index.
    :param str index_id: The identifier for the index.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['indexId'] = index_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:qbusiness:getIndex', __args__, opts=opts, typ=GetIndexResult)
    return __ret__.apply(lambda __response__: GetIndexResult(
        capacity_configuration=pulumi.get(__response__, 'capacity_configuration'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        document_attribute_configurations=pulumi.get(__response__, 'document_attribute_configurations'),
        index_arn=pulumi.get(__response__, 'index_arn'),
        index_id=pulumi.get(__response__, 'index_id'),
        index_statistics=pulumi.get(__response__, 'index_statistics'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
