# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, application_arn=None, application_id=None, attachments_configuration=None, auto_subscription_configuration=None, created_at=None, description=None, display_name=None, identity_center_application_arn=None, personalization_configuration=None, q_apps_configuration=None, role_arn=None, status=None, tags=None, updated_at=None):
        if application_arn and not isinstance(application_arn, str):
            raise TypeError("Expected argument 'application_arn' to be a str")
        pulumi.set(__self__, "application_arn", application_arn)
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if attachments_configuration and not isinstance(attachments_configuration, dict):
            raise TypeError("Expected argument 'attachments_configuration' to be a dict")
        pulumi.set(__self__, "attachments_configuration", attachments_configuration)
        if auto_subscription_configuration and not isinstance(auto_subscription_configuration, dict):
            raise TypeError("Expected argument 'auto_subscription_configuration' to be a dict")
        pulumi.set(__self__, "auto_subscription_configuration", auto_subscription_configuration)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if identity_center_application_arn and not isinstance(identity_center_application_arn, str):
            raise TypeError("Expected argument 'identity_center_application_arn' to be a str")
        pulumi.set(__self__, "identity_center_application_arn", identity_center_application_arn)
        if personalization_configuration and not isinstance(personalization_configuration, dict):
            raise TypeError("Expected argument 'personalization_configuration' to be a dict")
        pulumi.set(__self__, "personalization_configuration", personalization_configuration)
        if q_apps_configuration and not isinstance(q_apps_configuration, dict):
            raise TypeError("Expected argument 'q_apps_configuration' to be a dict")
        pulumi.set(__self__, "q_apps_configuration", q_apps_configuration)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q Business application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The identifier for the Amazon Q Business application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="attachmentsConfiguration")
    def attachments_configuration(self) -> Optional['outputs.ApplicationAttachmentsConfiguration']:
        """
        Configuration information for the file upload during chat feature.
        """
        return pulumi.get(self, "attachments_configuration")

    @property
    @pulumi.getter(name="autoSubscriptionConfiguration")
    def auto_subscription_configuration(self) -> Optional['outputs.ApplicationAutoSubscriptionConfiguration']:
        """
        Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
        """
        return pulumi.get(self, "auto_subscription_configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The Unix timestamp when the Amazon Q Business application was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the Amazon Q Business application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the Amazon Q Business application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q Business application.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @property
    @pulumi.getter(name="personalizationConfiguration")
    def personalization_configuration(self) -> Optional['outputs.ApplicationPersonalizationConfiguration']:
        """
        Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html) .
        """
        return pulumi.get(self, "personalization_configuration")

    @property
    @pulumi.getter(name="qAppsConfiguration")
    def q_apps_configuration(self) -> Optional['outputs.ApplicationQAppsConfiguration']:
        """
        Configuration information about Amazon Q Apps.
        """
        return pulumi.get(self, "q_apps_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics. If this property is not specified, Amazon Q Business will create a [service linked role (SLR)](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions) and use it as the application's role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional['ApplicationStatus']:
        """
        The status of the Amazon Q Business application. The application is ready to use when the status is `ACTIVE` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The Unix timestamp when the Amazon Q Business application was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_arn=self.application_arn,
            application_id=self.application_id,
            attachments_configuration=self.attachments_configuration,
            auto_subscription_configuration=self.auto_subscription_configuration,
            created_at=self.created_at,
            description=self.description,
            display_name=self.display_name,
            identity_center_application_arn=self.identity_center_application_arn,
            personalization_configuration=self.personalization_configuration,
            q_apps_configuration=self.q_apps_configuration,
            role_arn=self.role_arn,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at)


def get_application(application_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Definition of AWS::QBusiness::Application Resource Type


    :param str application_id: The identifier for the Amazon Q Business application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:qbusiness:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_arn=pulumi.get(__ret__, 'application_arn'),
        application_id=pulumi.get(__ret__, 'application_id'),
        attachments_configuration=pulumi.get(__ret__, 'attachments_configuration'),
        auto_subscription_configuration=pulumi.get(__ret__, 'auto_subscription_configuration'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        identity_center_application_arn=pulumi.get(__ret__, 'identity_center_application_arn'),
        personalization_configuration=pulumi.get(__ret__, 'personalization_configuration'),
        q_apps_configuration=pulumi.get(__ret__, 'q_apps_configuration'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_application_output(application_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Definition of AWS::QBusiness::Application Resource Type


    :param str application_id: The identifier for the Amazon Q Business application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:qbusiness:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        application_arn=pulumi.get(__response__, 'application_arn'),
        application_id=pulumi.get(__response__, 'application_id'),
        attachments_configuration=pulumi.get(__response__, 'attachments_configuration'),
        auto_subscription_configuration=pulumi.get(__response__, 'auto_subscription_configuration'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        identity_center_application_arn=pulumi.get(__response__, 'identity_center_application_arn'),
        personalization_configuration=pulumi.get(__response__, 'personalization_configuration'),
        q_apps_configuration=pulumi.get(__response__, 'q_apps_configuration'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
