# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InAppTemplateArgs', 'InAppTemplate']

@pulumi.input_type
class InAppTemplateArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[Sequence[pulumi.Input['InAppTemplateInAppMessageContentArgs']]]] = None,
                 custom_config: Optional[Any] = None,
                 layout: Optional[pulumi.Input['InAppTemplateLayout']] = None,
                 tags: Optional[Any] = None,
                 template_description: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InAppTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['InAppTemplateInAppMessageContentArgs']]] content: An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
        :param Any custom_config: Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        :param pulumi.Input['InAppTemplateLayout'] layout: A string that determines the appearance of the in-app message. You can specify one of the following:
               
               - `BOTTOM_BANNER` – a message that appears as a banner at the bottom of the page.
               - `TOP_BANNER` – a message that appears as a banner at the top of the page.
               - `OVERLAYS` – a message that covers entire screen.
               - `MOBILE_FEED` – a message that appears in a window in front of the page.
               - `MIDDLE_BANNER` – a message that appears as a banner in the middle of the page.
               - `CAROUSEL` – a scrollable layout of up to five unique messages.
        :param Any tags: An array of key-value pairs to apply to this resource.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        :param pulumi.Input[str] template_description: An optional description of the in-app template.
        :param pulumi.Input[str] template_name: The name of the in-app message template.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)
        if layout is not None:
            pulumi.set(__self__, "layout", layout)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_description is not None:
            pulumi.set(__self__, "template_description", template_description)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InAppTemplateInAppMessageContentArgs']]]]:
        """
        An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InAppTemplateInAppMessageContentArgs']]]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[Any]:
        """
        Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "custom_config")

    @custom_config.setter
    def custom_config(self, value: Optional[Any]):
        pulumi.set(self, "custom_config", value)

    @property
    @pulumi.getter
    def layout(self) -> Optional[pulumi.Input['InAppTemplateLayout']]:
        """
        A string that determines the appearance of the in-app message. You can specify one of the following:

        - `BOTTOM_BANNER` – a message that appears as a banner at the bottom of the page.
        - `TOP_BANNER` – a message that appears as a banner at the top of the page.
        - `OVERLAYS` – a message that covers entire screen.
        - `MOBILE_FEED` – a message that appears in a window in front of the page.
        - `MIDDLE_BANNER` – a message that appears as a banner in the middle of the page.
        - `CAROUSEL` – a scrollable layout of up to five unique messages.
        """
        return pulumi.get(self, "layout")

    @layout.setter
    def layout(self, value: Optional[pulumi.Input['InAppTemplateLayout']]):
        pulumi.set(self, "layout", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Any]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the in-app template.
        """
        return pulumi.get(self, "template_description")

    @template_description.setter
    def template_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_description", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the in-app message template.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)


class InAppTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InAppTemplateInAppMessageContentArgs', 'InAppTemplateInAppMessageContentArgsDict']]]]] = None,
                 custom_config: Optional[Any] = None,
                 layout: Optional[pulumi.Input['InAppTemplateLayout']] = None,
                 tags: Optional[Any] = None,
                 template_description: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Pinpoint::InAppTemplate

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InAppTemplateInAppMessageContentArgs', 'InAppTemplateInAppMessageContentArgsDict']]]] content: An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
        :param Any custom_config: Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        :param pulumi.Input['InAppTemplateLayout'] layout: A string that determines the appearance of the in-app message. You can specify one of the following:
               
               - `BOTTOM_BANNER` – a message that appears as a banner at the bottom of the page.
               - `TOP_BANNER` – a message that appears as a banner at the top of the page.
               - `OVERLAYS` – a message that covers entire screen.
               - `MOBILE_FEED` – a message that appears in a window in front of the page.
               - `MIDDLE_BANNER` – a message that appears as a banner in the middle of the page.
               - `CAROUSEL` – a scrollable layout of up to five unique messages.
        :param Any tags: An array of key-value pairs to apply to this resource.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        :param pulumi.Input[str] template_description: An optional description of the in-app template.
        :param pulumi.Input[str] template_name: The name of the in-app message template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InAppTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Pinpoint::InAppTemplate

        :param str resource_name: The name of the resource.
        :param InAppTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InAppTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InAppTemplateInAppMessageContentArgs', 'InAppTemplateInAppMessageContentArgsDict']]]]] = None,
                 custom_config: Optional[Any] = None,
                 layout: Optional[pulumi.Input['InAppTemplateLayout']] = None,
                 tags: Optional[Any] = None,
                 template_description: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InAppTemplateArgs.__new__(InAppTemplateArgs)

            __props__.__dict__["content"] = content
            __props__.__dict__["custom_config"] = custom_config
            __props__.__dict__["layout"] = layout
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_description"] = template_description
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["templateName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InAppTemplate, __self__).__init__(
            'aws-native:pinpoint:InAppTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InAppTemplate':
        """
        Get an existing InAppTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InAppTemplateArgs.__new__(InAppTemplateArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["content"] = None
        __props__.__dict__["custom_config"] = None
        __props__.__dict__["layout"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["template_description"] = None
        __props__.__dict__["template_name"] = None
        return InAppTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the message template.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[Sequence['outputs.InAppTemplateInAppMessageContent']]]:
        """
        An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> pulumi.Output[Optional[Any]]:
        """
        Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "custom_config")

    @property
    @pulumi.getter
    def layout(self) -> pulumi.Output[Optional['InAppTemplateLayout']]:
        """
        A string that determines the appearance of the in-app message. You can specify one of the following:

        - `BOTTOM_BANNER` – a message that appears as a banner at the bottom of the page.
        - `TOP_BANNER` – a message that appears as a banner at the top of the page.
        - `OVERLAYS` – a message that covers entire screen.
        - `MOBILE_FEED` – a message that appears in a window in front of the page.
        - `MIDDLE_BANNER` – a message that appears as a banner in the middle of the page.
        - `CAROUSEL` – a scrollable layout of up to five unique messages.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Any]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Pinpoint::InAppTemplate` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of the in-app template.
        """
        return pulumi.get(self, "template_description")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[str]:
        """
        The name of the in-app message template.
        """
        return pulumi.get(self, "template_name")

