# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetChallengeResult',
    'AwaitableGetChallengeResult',
    'get_challenge',
    'get_challenge_output',
]

@pulumi.output_type
class GetChallengeResult:
    def __init__(__self__, challenge_arn=None, tags=None):
        if challenge_arn and not isinstance(challenge_arn, str):
            raise TypeError("Expected argument 'challenge_arn' to be a str")
        pulumi.set(__self__, "challenge_arn", challenge_arn)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="challengeArn")
    def challenge_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the challenge.
        """
        return pulumi.get(self, "challenge_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "tags")


class AwaitableGetChallengeResult(GetChallengeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChallengeResult(
            challenge_arn=self.challenge_arn,
            tags=self.tags)


def get_challenge(challenge_arn: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChallengeResult:
    """
    Represents a SCEP Challenge that is used for certificate enrollment


    :param str challenge_arn: The Amazon Resource Name (ARN) of the challenge.
    """
    __args__ = dict()
    __args__['challengeArn'] = challenge_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:pcaconnectorscep:getChallenge', __args__, opts=opts, typ=GetChallengeResult).value

    return AwaitableGetChallengeResult(
        challenge_arn=pulumi.get(__ret__, 'challenge_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_challenge_output(challenge_arn: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChallengeResult]:
    """
    Represents a SCEP Challenge that is used for certificate enrollment


    :param str challenge_arn: The Amazon Resource Name (ARN) of the challenge.
    """
    __args__ = dict()
    __args__['challengeArn'] = challenge_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:pcaconnectorscep:getChallenge', __args__, opts=opts, typ=GetChallengeResult)
    return __ret__.apply(lambda __response__: GetChallengeResult(
        challenge_arn=pulumi.get(__response__, 'challenge_arn'),
        tags=pulumi.get(__response__, 'tags')))
