# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TemplateGroupAccessControlEntryArgs', 'TemplateGroupAccessControlEntry']

@pulumi.input_type
class TemplateGroupAccessControlEntryArgs:
    def __init__(__self__, *,
                 access_rights: pulumi.Input['TemplateGroupAccessControlEntryAccessRightsArgs'],
                 group_display_name: pulumi.Input[str],
                 group_security_identifier: Optional[pulumi.Input[str]] = None,
                 template_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TemplateGroupAccessControlEntry resource.
        :param pulumi.Input['TemplateGroupAccessControlEntryAccessRightsArgs'] access_rights: Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
        :param pulumi.Input[str] group_display_name: Name of the Active Directory group. This name does not need to match the group name in Active Directory.
        :param pulumi.Input[str] group_security_identifier: Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
        :param pulumi.Input[str] template_arn: The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html) .
        """
        pulumi.set(__self__, "access_rights", access_rights)
        pulumi.set(__self__, "group_display_name", group_display_name)
        if group_security_identifier is not None:
            pulumi.set(__self__, "group_security_identifier", group_security_identifier)
        if template_arn is not None:
            pulumi.set(__self__, "template_arn", template_arn)

    @property
    @pulumi.getter(name="accessRights")
    def access_rights(self) -> pulumi.Input['TemplateGroupAccessControlEntryAccessRightsArgs']:
        """
        Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
        """
        return pulumi.get(self, "access_rights")

    @access_rights.setter
    def access_rights(self, value: pulumi.Input['TemplateGroupAccessControlEntryAccessRightsArgs']):
        pulumi.set(self, "access_rights", value)

    @property
    @pulumi.getter(name="groupDisplayName")
    def group_display_name(self) -> pulumi.Input[str]:
        """
        Name of the Active Directory group. This name does not need to match the group name in Active Directory.
        """
        return pulumi.get(self, "group_display_name")

    @group_display_name.setter
    def group_display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_display_name", value)

    @property
    @pulumi.getter(name="groupSecurityIdentifier")
    def group_security_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
        """
        return pulumi.get(self, "group_security_identifier")

    @group_security_identifier.setter
    def group_security_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_security_identifier", value)

    @property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html) .
        """
        return pulumi.get(self, "template_arn")

    @template_arn.setter
    def template_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_arn", value)


class TemplateGroupAccessControlEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_rights: Optional[pulumi.Input[Union['TemplateGroupAccessControlEntryAccessRightsArgs', 'TemplateGroupAccessControlEntryAccessRightsArgsDict']]] = None,
                 group_display_name: Optional[pulumi.Input[str]] = None,
                 group_security_identifier: Optional[pulumi.Input[str]] = None,
                 template_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::PCAConnectorAD::TemplateGroupAccessControlEntry Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TemplateGroupAccessControlEntryAccessRightsArgs', 'TemplateGroupAccessControlEntryAccessRightsArgsDict']] access_rights: Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
        :param pulumi.Input[str] group_display_name: Name of the Active Directory group. This name does not need to match the group name in Active Directory.
        :param pulumi.Input[str] group_security_identifier: Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
        :param pulumi.Input[str] template_arn: The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateGroupAccessControlEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::PCAConnectorAD::TemplateGroupAccessControlEntry Resource Type

        :param str resource_name: The name of the resource.
        :param TemplateGroupAccessControlEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateGroupAccessControlEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_rights: Optional[pulumi.Input[Union['TemplateGroupAccessControlEntryAccessRightsArgs', 'TemplateGroupAccessControlEntryAccessRightsArgsDict']]] = None,
                 group_display_name: Optional[pulumi.Input[str]] = None,
                 group_security_identifier: Optional[pulumi.Input[str]] = None,
                 template_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateGroupAccessControlEntryArgs.__new__(TemplateGroupAccessControlEntryArgs)

            if access_rights is None and not opts.urn:
                raise TypeError("Missing required property 'access_rights'")
            __props__.__dict__["access_rights"] = access_rights
            if group_display_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_display_name'")
            __props__.__dict__["group_display_name"] = group_display_name
            __props__.__dict__["group_security_identifier"] = group_security_identifier
            __props__.__dict__["template_arn"] = template_arn
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["groupSecurityIdentifier", "templateArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TemplateGroupAccessControlEntry, __self__).__init__(
            'aws-native:pcaconnectorad:TemplateGroupAccessControlEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TemplateGroupAccessControlEntry':
        """
        Get an existing TemplateGroupAccessControlEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TemplateGroupAccessControlEntryArgs.__new__(TemplateGroupAccessControlEntryArgs)

        __props__.__dict__["access_rights"] = None
        __props__.__dict__["group_display_name"] = None
        __props__.__dict__["group_security_identifier"] = None
        __props__.__dict__["template_arn"] = None
        return TemplateGroupAccessControlEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessRights")
    def access_rights(self) -> pulumi.Output['outputs.TemplateGroupAccessControlEntryAccessRights']:
        """
        Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
        """
        return pulumi.get(self, "access_rights")

    @property
    @pulumi.getter(name="groupDisplayName")
    def group_display_name(self) -> pulumi.Output[str]:
        """
        Name of the Active Directory group. This name does not need to match the group name in Active Directory.
        """
        return pulumi.get(self, "group_display_name")

    @property
    @pulumi.getter(name="groupSecurityIdentifier")
    def group_security_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
        """
        return pulumi.get(self, "group_security_identifier")

    @property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html) .
        """
        return pulumi.get(self, "template_arn")

