# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TemplateArgs', 'Template']

@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 connector_arn: pulumi.Input[str],
                 definition: pulumi.Input[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition1PropertiesArgs', 'TemplateDefinition2PropertiesArgs']],
                 name: Optional[pulumi.Input[str]] = None,
                 reenroll_all_certificate_holders: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Template resource.
        :param pulumi.Input[str] connector_arn: The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
        :param pulumi.Input[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition1PropertiesArgs', 'TemplateDefinition2PropertiesArgs']] definition: Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
        :param pulumi.Input[str] name: Name of the templates. Template names must be unique.
        :param pulumi.Input[bool] reenroll_all_certificate_holders: This setting allows the major version of a template to be increased automatically. All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Metadata assigned to a template consisting of a key-value pair.
        """
        pulumi.set(__self__, "connector_arn", connector_arn)
        pulumi.set(__self__, "definition", definition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reenroll_all_certificate_holders is not None:
            pulumi.set(__self__, "reenroll_all_certificate_holders", reenroll_all_certificate_holders)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
        """
        return pulumi.get(self, "connector_arn")

    @connector_arn.setter
    def connector_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector_arn", value)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition1PropertiesArgs', 'TemplateDefinition2PropertiesArgs']]:
        """
        Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition1PropertiesArgs', 'TemplateDefinition2PropertiesArgs']]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the templates. Template names must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reenrollAllCertificateHolders")
    def reenroll_all_certificate_holders(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting allows the major version of a template to be increased automatically. All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
        """
        return pulumi.get(self, "reenroll_all_certificate_holders")

    @reenroll_all_certificate_holders.setter
    def reenroll_all_certificate_holders(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reenroll_all_certificate_holders", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata assigned to a template consisting of a key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Template(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_arn: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[Union[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition0PropertiesArgsDict'], Union['TemplateDefinition1PropertiesArgs', 'TemplateDefinition1PropertiesArgsDict'], Union['TemplateDefinition2PropertiesArgs', 'TemplateDefinition2PropertiesArgsDict']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reenroll_all_certificate_holders: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Represents a template that defines certificate configurations, both for issuance and client handling

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connector_arn: The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
        :param pulumi.Input[Union[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition0PropertiesArgsDict'], Union['TemplateDefinition1PropertiesArgs', 'TemplateDefinition1PropertiesArgsDict'], Union['TemplateDefinition2PropertiesArgs', 'TemplateDefinition2PropertiesArgsDict']]] definition: Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
        :param pulumi.Input[str] name: Name of the templates. Template names must be unique.
        :param pulumi.Input[bool] reenroll_all_certificate_holders: This setting allows the major version of a template to be increased automatically. All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Metadata assigned to a template consisting of a key-value pair.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a template that defines certificate configurations, both for issuance and client handling

        :param str resource_name: The name of the resource.
        :param TemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_arn: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[Union[Union['TemplateDefinition0PropertiesArgs', 'TemplateDefinition0PropertiesArgsDict'], Union['TemplateDefinition1PropertiesArgs', 'TemplateDefinition1PropertiesArgsDict'], Union['TemplateDefinition2PropertiesArgs', 'TemplateDefinition2PropertiesArgsDict']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reenroll_all_certificate_holders: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateArgs.__new__(TemplateArgs)

            if connector_arn is None and not opts.urn:
                raise TypeError("Missing required property 'connector_arn'")
            __props__.__dict__["connector_arn"] = connector_arn
            if definition is None and not opts.urn:
                raise TypeError("Missing required property 'definition'")
            __props__.__dict__["definition"] = definition
            __props__.__dict__["name"] = name
            __props__.__dict__["reenroll_all_certificate_holders"] = reenroll_all_certificate_holders
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["connectorArn", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Template, __self__).__init__(
            'aws-native:pcaconnectorad:Template',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Template':
        """
        Get an existing Template resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TemplateArgs.__new__(TemplateArgs)

        __props__.__dict__["connector_arn"] = None
        __props__.__dict__["definition"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["reenroll_all_certificate_holders"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["template_arn"] = None
        return Template(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
        """
        return pulumi.get(self, "connector_arn")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output[Any]:
        """
        Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the templates. Template names must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reenrollAllCertificateHolders")
    def reenroll_all_certificate_holders(self) -> pulumi.Output[Optional[bool]]:
        """
        This setting allows the major version of a template to be increased automatically. All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.
        """
        return pulumi.get(self, "reenroll_all_certificate_holders")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Metadata assigned to a template consisting of a key-value pair.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html) .
        """
        return pulumi.get(self, "template_arn")

