# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'KeyAttributesArgs',
    'KeyAttributesArgsDict',
    'KeyModesOfUseArgs',
    'KeyModesOfUseArgsDict',
]

MYPY = False

if not MYPY:
    class KeyAttributesArgsDict(TypedDict):
        key_algorithm: pulumi.Input['KeyAlgorithm']
        """
        The key algorithm to be use during creation of an AWS Payment Cryptography key.

        For symmetric keys, AWS Payment Cryptography supports `AES` and `TDES` algorithms. For asymmetric keys, AWS Payment Cryptography supports `RSA` and `ECC_NIST` algorithms.
        """
        key_class: pulumi.Input['KeyClass']
        """
        The type of AWS Payment Cryptography key to create, which determines the classiﬁcation of the cryptographic method and whether AWS Payment Cryptography key contains a symmetric key or an asymmetric key pair.
        """
        key_modes_of_use: pulumi.Input['KeyModesOfUseArgsDict']
        """
        The list of cryptographic operations that you can perform using the key.
        """
        key_usage: pulumi.Input['KeyUsage']
        """
        The cryptographic usage of an AWS Payment Cryptography key as deﬁned in section A.5.2 of the TR-31 spec.
        """
elif False:
    KeyAttributesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyAttributesArgs:
    def __init__(__self__, *,
                 key_algorithm: pulumi.Input['KeyAlgorithm'],
                 key_class: pulumi.Input['KeyClass'],
                 key_modes_of_use: pulumi.Input['KeyModesOfUseArgs'],
                 key_usage: pulumi.Input['KeyUsage']):
        """
        :param pulumi.Input['KeyAlgorithm'] key_algorithm: The key algorithm to be use during creation of an AWS Payment Cryptography key.
               
               For symmetric keys, AWS Payment Cryptography supports `AES` and `TDES` algorithms. For asymmetric keys, AWS Payment Cryptography supports `RSA` and `ECC_NIST` algorithms.
        :param pulumi.Input['KeyClass'] key_class: The type of AWS Payment Cryptography key to create, which determines the classiﬁcation of the cryptographic method and whether AWS Payment Cryptography key contains a symmetric key or an asymmetric key pair.
        :param pulumi.Input['KeyModesOfUseArgs'] key_modes_of_use: The list of cryptographic operations that you can perform using the key.
        :param pulumi.Input['KeyUsage'] key_usage: The cryptographic usage of an AWS Payment Cryptography key as deﬁned in section A.5.2 of the TR-31 spec.
        """
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "key_class", key_class)
        pulumi.set(__self__, "key_modes_of_use", key_modes_of_use)
        pulumi.set(__self__, "key_usage", key_usage)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Input['KeyAlgorithm']:
        """
        The key algorithm to be use during creation of an AWS Payment Cryptography key.

        For symmetric keys, AWS Payment Cryptography supports `AES` and `TDES` algorithms. For asymmetric keys, AWS Payment Cryptography supports `RSA` and `ECC_NIST` algorithms.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: pulumi.Input['KeyAlgorithm']):
        pulumi.set(self, "key_algorithm", value)

    @property
    @pulumi.getter(name="keyClass")
    def key_class(self) -> pulumi.Input['KeyClass']:
        """
        The type of AWS Payment Cryptography key to create, which determines the classiﬁcation of the cryptographic method and whether AWS Payment Cryptography key contains a symmetric key or an asymmetric key pair.
        """
        return pulumi.get(self, "key_class")

    @key_class.setter
    def key_class(self, value: pulumi.Input['KeyClass']):
        pulumi.set(self, "key_class", value)

    @property
    @pulumi.getter(name="keyModesOfUse")
    def key_modes_of_use(self) -> pulumi.Input['KeyModesOfUseArgs']:
        """
        The list of cryptographic operations that you can perform using the key.
        """
        return pulumi.get(self, "key_modes_of_use")

    @key_modes_of_use.setter
    def key_modes_of_use(self, value: pulumi.Input['KeyModesOfUseArgs']):
        pulumi.set(self, "key_modes_of_use", value)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> pulumi.Input['KeyUsage']:
        """
        The cryptographic usage of an AWS Payment Cryptography key as deﬁned in section A.5.2 of the TR-31 spec.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: pulumi.Input['KeyUsage']):
        pulumi.set(self, "key_usage", value)


if not MYPY:
    class KeyModesOfUseArgsDict(TypedDict):
        decrypt: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to decrypt data.
        """
        derive_key: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to derive new keys.
        """
        encrypt: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to encrypt data.
        """
        generate: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        """
        no_restrictions: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by `KeyUsage` .
        """
        sign: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used for signing.
        """
        unwrap: NotRequired[pulumi.Input[bool]]
        verify: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to verify signatures.
        """
        wrap: NotRequired[pulumi.Input[bool]]
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
elif False:
    KeyModesOfUseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyModesOfUseArgs:
    def __init__(__self__, *,
                 decrypt: Optional[pulumi.Input[bool]] = None,
                 derive_key: Optional[pulumi.Input[bool]] = None,
                 encrypt: Optional[pulumi.Input[bool]] = None,
                 generate: Optional[pulumi.Input[bool]] = None,
                 no_restrictions: Optional[pulumi.Input[bool]] = None,
                 sign: Optional[pulumi.Input[bool]] = None,
                 unwrap: Optional[pulumi.Input[bool]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 wrap: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] decrypt: Speciﬁes whether an AWS Payment Cryptography key can be used to decrypt data.
        :param pulumi.Input[bool] derive_key: Speciﬁes whether an AWS Payment Cryptography key can be used to derive new keys.
        :param pulumi.Input[bool] encrypt: Speciﬁes whether an AWS Payment Cryptography key can be used to encrypt data.
        :param pulumi.Input[bool] generate: Speciﬁes whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        :param pulumi.Input[bool] no_restrictions: Speciﬁes whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by `KeyUsage` .
        :param pulumi.Input[bool] sign: Speciﬁes whether an AWS Payment Cryptography key can be used for signing.
        :param pulumi.Input[bool] verify: Speciﬁes whether an AWS Payment Cryptography key can be used to verify signatures.
        :param pulumi.Input[bool] wrap: Speciﬁes whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
        if decrypt is not None:
            pulumi.set(__self__, "decrypt", decrypt)
        if derive_key is not None:
            pulumi.set(__self__, "derive_key", derive_key)
        if encrypt is not None:
            pulumi.set(__self__, "encrypt", encrypt)
        if generate is not None:
            pulumi.set(__self__, "generate", generate)
        if no_restrictions is not None:
            pulumi.set(__self__, "no_restrictions", no_restrictions)
        if sign is not None:
            pulumi.set(__self__, "sign", sign)
        if unwrap is not None:
            pulumi.set(__self__, "unwrap", unwrap)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)
        if wrap is not None:
            pulumi.set(__self__, "wrap", wrap)

    @property
    @pulumi.getter
    def decrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to decrypt data.
        """
        return pulumi.get(self, "decrypt")

    @decrypt.setter
    def decrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "decrypt", value)

    @property
    @pulumi.getter(name="deriveKey")
    def derive_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to derive new keys.
        """
        return pulumi.get(self, "derive_key")

    @derive_key.setter
    def derive_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "derive_key", value)

    @property
    @pulumi.getter
    def encrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to encrypt data.
        """
        return pulumi.get(self, "encrypt")

    @encrypt.setter
    def encrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt", value)

    @property
    @pulumi.getter
    def generate(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        """
        return pulumi.get(self, "generate")

    @generate.setter
    def generate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate", value)

    @property
    @pulumi.getter(name="noRestrictions")
    def no_restrictions(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by `KeyUsage` .
        """
        return pulumi.get(self, "no_restrictions")

    @no_restrictions.setter
    def no_restrictions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_restrictions", value)

    @property
    @pulumi.getter
    def sign(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used for signing.
        """
        return pulumi.get(self, "sign")

    @sign.setter
    def sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign", value)

    @property
    @pulumi.getter
    def unwrap(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "unwrap")

    @unwrap.setter
    def unwrap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unwrap", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to verify signatures.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)

    @property
    @pulumi.getter
    def wrap(self) -> Optional[pulumi.Input[bool]]:
        """
        Speciﬁes whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
        return pulumi.get(self, "wrap")

    @wrap.setter
    def wrap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wrap", value)


