# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    def __init__(__self__, arn=None, backup_retention_count=None, disable_automated_backup=None, endpoint=None, preferred_backup_window=None, preferred_maintenance_window=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if backup_retention_count and not isinstance(backup_retention_count, int):
            raise TypeError("Expected argument 'backup_retention_count' to be a int")
        pulumi.set(__self__, "backup_retention_count", backup_retention_count)
        if disable_automated_backup and not isinstance(disable_automated_backup, bool):
            raise TypeError("Expected argument 'disable_automated_backup' to be a bool")
        pulumi.set(__self__, "disable_automated_backup", disable_automated_backup)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if preferred_backup_window and not isinstance(preferred_backup_window, str):
            raise TypeError("Expected argument 'preferred_backup_window' to be a str")
        pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window and not isinstance(preferred_maintenance_window, str):
            raise TypeError("Expected argument 'preferred_maintenance_window' to be a str")
        pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the server, such as `arn:aws:OpsWorksCM:us-east-1:123456789012:server/server-a1bzhi` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="backupRetentionCount")
    def backup_retention_count(self) -> Optional[int]:
        """
        The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1` .
        """
        return pulumi.get(self, "backup_retention_count")

    @property
    @pulumi.getter(name="disableAutomatedBackup")
    def disable_automated_backup(self) -> Optional[bool]:
        """
        Enable or disable scheduled backups. Valid values are `true` or `false` . The default value is `true` .
        """
        return pulumi.get(self, "disable_automated_backup")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        A DNS name that can be used to access the engine. Example: `myserver-asdfghjkl.us-east-1.opsworks.io` .
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[str]:
        """
        The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:

        - `HH:MM` for daily backups
        - `DDD:HH:MM` for weekly backups

        `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.

        *Example:* `08:00` , which represents a daily start time of 08:00 UTC.

        *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[str]:
        """
        The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM` . `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.

        *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        """
        return pulumi.get(self, "preferred_maintenance_window")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            arn=self.arn,
            backup_retention_count=self.backup_retention_count,
            disable_automated_backup=self.disable_automated_backup,
            endpoint=self.endpoint,
            preferred_backup_window=self.preferred_backup_window,
            preferred_maintenance_window=self.preferred_maintenance_window)


def get_server(server_name: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Resource Type definition for AWS::OpsWorksCM::Server


    :param str server_name: The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
    """
    __args__ = dict()
    __args__['serverName'] = server_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opsworkscm:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        arn=pulumi.get(__ret__, 'arn'),
        backup_retention_count=pulumi.get(__ret__, 'backup_retention_count'),
        disable_automated_backup=pulumi.get(__ret__, 'disable_automated_backup'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        preferred_backup_window=pulumi.get(__ret__, 'preferred_backup_window'),
        preferred_maintenance_window=pulumi.get(__ret__, 'preferred_maintenance_window'))
def get_server_output(server_name: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerResult]:
    """
    Resource Type definition for AWS::OpsWorksCM::Server


    :param str server_name: The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
    """
    __args__ = dict()
    __args__['serverName'] = server_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opsworkscm:getServer', __args__, opts=opts, typ=GetServerResult)
    return __ret__.apply(lambda __response__: GetServerResult(
        arn=pulumi.get(__response__, 'arn'),
        backup_retention_count=pulumi.get(__response__, 'backup_retention_count'),
        disable_automated_backup=pulumi.get(__response__, 'disable_automated_backup'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        preferred_backup_window=pulumi.get(__response__, 'preferred_backup_window'),
        preferred_maintenance_window=pulumi.get(__response__, 'preferred_maintenance_window')))
