# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DomainAdvancedSecurityOptionsInputArgs',
    'DomainAdvancedSecurityOptionsInputArgsDict',
    'DomainClusterConfigArgs',
    'DomainClusterConfigArgsDict',
    'DomainCognitoOptionsArgs',
    'DomainCognitoOptionsArgsDict',
    'DomainColdStorageOptionsArgs',
    'DomainColdStorageOptionsArgsDict',
    'DomainEbsOptionsArgs',
    'DomainEbsOptionsArgsDict',
    'DomainEncryptionAtRestOptionsArgs',
    'DomainEncryptionAtRestOptionsArgsDict',
    'DomainEndpointOptionsArgs',
    'DomainEndpointOptionsArgsDict',
    'DomainIdpArgs',
    'DomainIdpArgsDict',
    'DomainJwtOptionsArgs',
    'DomainJwtOptionsArgsDict',
    'DomainLogPublishingOptionArgs',
    'DomainLogPublishingOptionArgsDict',
    'DomainMasterUserOptionsArgs',
    'DomainMasterUserOptionsArgsDict',
    'DomainNodeToNodeEncryptionOptionsArgs',
    'DomainNodeToNodeEncryptionOptionsArgsDict',
    'DomainOffPeakWindowOptionsArgs',
    'DomainOffPeakWindowOptionsArgsDict',
    'DomainOffPeakWindowArgs',
    'DomainOffPeakWindowArgsDict',
    'DomainSamlOptionsArgs',
    'DomainSamlOptionsArgsDict',
    'DomainSnapshotOptionsArgs',
    'DomainSnapshotOptionsArgsDict',
    'DomainSoftwareUpdateOptionsArgs',
    'DomainSoftwareUpdateOptionsArgsDict',
    'DomainVpcOptionsArgs',
    'DomainVpcOptionsArgsDict',
    'DomainWindowStartTimeArgs',
    'DomainWindowStartTimeArgsDict',
    'DomainZoneAwarenessConfigArgs',
    'DomainZoneAwarenessConfigArgsDict',
]

MYPY = False

if not MYPY:
    class DomainAdvancedSecurityOptionsInputArgsDict(TypedDict):
        anonymous_auth_disable_date: NotRequired[pulumi.Input[str]]
        """
        Date and time when the migration period will be disabled. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing) .
        """
        anonymous_auth_enabled: NotRequired[pulumi.Input[bool]]
        """
        True to enable a 30-day migration period during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing) .
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        True to enable fine-grained access control. You must also enable encryption of data at rest and node-to-node encryption. See [Fine-grained access control in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html) .
        """
        internal_user_database_enabled: NotRequired[pulumi.Input[bool]]
        """
        True to enable the internal user database.
        """
        jwt_options: NotRequired[pulumi.Input['DomainJwtOptionsArgsDict']]
        """
        Container for information about the JWT configuration of the Amazon OpenSearch Service.
        """
        master_user_options: NotRequired[pulumi.Input['DomainMasterUserOptionsArgsDict']]
        """
        Specifies information about the master user.
        """
        saml_options: NotRequired[pulumi.Input['DomainSamlOptionsArgsDict']]
        """
        Container for information about the SAML configuration for OpenSearch Dashboards.
        """
elif False:
    DomainAdvancedSecurityOptionsInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAdvancedSecurityOptionsInputArgs:
    def __init__(__self__, *,
                 anonymous_auth_disable_date: Optional[pulumi.Input[str]] = None,
                 anonymous_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 internal_user_database_enabled: Optional[pulumi.Input[bool]] = None,
                 jwt_options: Optional[pulumi.Input['DomainJwtOptionsArgs']] = None,
                 master_user_options: Optional[pulumi.Input['DomainMasterUserOptionsArgs']] = None,
                 saml_options: Optional[pulumi.Input['DomainSamlOptionsArgs']] = None):
        """
        :param pulumi.Input[str] anonymous_auth_disable_date: Date and time when the migration period will be disabled. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing) .
        :param pulumi.Input[bool] anonymous_auth_enabled: True to enable a 30-day migration period during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing) .
        :param pulumi.Input[bool] enabled: True to enable fine-grained access control. You must also enable encryption of data at rest and node-to-node encryption. See [Fine-grained access control in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html) .
        :param pulumi.Input[bool] internal_user_database_enabled: True to enable the internal user database.
        :param pulumi.Input['DomainJwtOptionsArgs'] jwt_options: Container for information about the JWT configuration of the Amazon OpenSearch Service.
        :param pulumi.Input['DomainMasterUserOptionsArgs'] master_user_options: Specifies information about the master user.
        :param pulumi.Input['DomainSamlOptionsArgs'] saml_options: Container for information about the SAML configuration for OpenSearch Dashboards.
        """
        if anonymous_auth_disable_date is not None:
            pulumi.set(__self__, "anonymous_auth_disable_date", anonymous_auth_disable_date)
        if anonymous_auth_enabled is not None:
            pulumi.set(__self__, "anonymous_auth_enabled", anonymous_auth_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if internal_user_database_enabled is not None:
            pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)
        if jwt_options is not None:
            pulumi.set(__self__, "jwt_options", jwt_options)
        if master_user_options is not None:
            pulumi.set(__self__, "master_user_options", master_user_options)
        if saml_options is not None:
            pulumi.set(__self__, "saml_options", saml_options)

    @property
    @pulumi.getter(name="anonymousAuthDisableDate")
    def anonymous_auth_disable_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time when the migration period will be disabled. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing) .
        """
        return pulumi.get(self, "anonymous_auth_disable_date")

    @anonymous_auth_disable_date.setter
    def anonymous_auth_disable_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "anonymous_auth_disable_date", value)

    @property
    @pulumi.getter(name="anonymousAuthEnabled")
    def anonymous_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True to enable a 30-day migration period during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing) .
        """
        return pulumi.get(self, "anonymous_auth_enabled")

    @anonymous_auth_enabled.setter
    def anonymous_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "anonymous_auth_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True to enable fine-grained access control. You must also enable encryption of data at rest and node-to-node encryption. See [Fine-grained access control in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html) .
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True to enable the internal user database.
        """
        return pulumi.get(self, "internal_user_database_enabled")

    @internal_user_database_enabled.setter
    def internal_user_database_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal_user_database_enabled", value)

    @property
    @pulumi.getter(name="jwtOptions")
    def jwt_options(self) -> Optional[pulumi.Input['DomainJwtOptionsArgs']]:
        """
        Container for information about the JWT configuration of the Amazon OpenSearch Service.
        """
        return pulumi.get(self, "jwt_options")

    @jwt_options.setter
    def jwt_options(self, value: Optional[pulumi.Input['DomainJwtOptionsArgs']]):
        pulumi.set(self, "jwt_options", value)

    @property
    @pulumi.getter(name="masterUserOptions")
    def master_user_options(self) -> Optional[pulumi.Input['DomainMasterUserOptionsArgs']]:
        """
        Specifies information about the master user.
        """
        return pulumi.get(self, "master_user_options")

    @master_user_options.setter
    def master_user_options(self, value: Optional[pulumi.Input['DomainMasterUserOptionsArgs']]):
        pulumi.set(self, "master_user_options", value)

    @property
    @pulumi.getter(name="samlOptions")
    def saml_options(self) -> Optional[pulumi.Input['DomainSamlOptionsArgs']]:
        """
        Container for information about the SAML configuration for OpenSearch Dashboards.
        """
        return pulumi.get(self, "saml_options")

    @saml_options.setter
    def saml_options(self, value: Optional[pulumi.Input['DomainSamlOptionsArgs']]):
        pulumi.set(self, "saml_options", value)


if not MYPY:
    class DomainClusterConfigArgsDict(TypedDict):
        cold_storage_options: NotRequired[pulumi.Input['DomainColdStorageOptionsArgsDict']]
        """
        Container for cold storage configuration options.
        """
        dedicated_master_count: NotRequired[pulumi.Input[int]]
        """
        The number of instances to use for the master node. If you specify this property, you must specify `true` for the `DedicatedMasterEnabled` property.
        """
        dedicated_master_enabled: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to use a dedicated master node for the OpenSearch Service domain. A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See [Dedicated master nodes in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html) .
        """
        dedicated_master_type: NotRequired[pulumi.Input[str]]
        """
        The hardware configuration of the computer that hosts the dedicated master node, such as `m3.medium.search` . If you specify this property, you must specify `true` for the `DedicatedMasterEnabled` property. For valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) .
        """
        instance_count: NotRequired[pulumi.Input[int]]
        """
        The number of data nodes (instances) to use in the OpenSearch Service domain.
        """
        instance_type: NotRequired[pulumi.Input[str]]
        """
        The instance type for your data nodes, such as `m3.medium.search` . For valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) .
        """
        multi_az_with_standby_enabled: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether Multi-AZ with Standby deployment option is enabled. For more information, see [Multi-AZ with Standby](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html#managedomains-za-standby) .
        """
        warm_count: NotRequired[pulumi.Input[int]]
        """
        The number of warm nodes in the cluster.
        """
        warm_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether to enable UltraWarm storage for the cluster. See [UltraWarm storage for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ultrawarm.html) .
        """
        warm_type: NotRequired[pulumi.Input[str]]
        """
        The instance type for the cluster's warm nodes.
        """
        zone_awareness_config: NotRequired[pulumi.Input['DomainZoneAwarenessConfigArgsDict']]
        """
        Specifies zone awareness configuration options. Only use if `ZoneAwarenessEnabled` is `true` .
        """
        zone_awareness_enabled: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to enable zone awareness for the OpenSearch Service domain. When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html) .
        """
elif False:
    DomainClusterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigArgs:
    def __init__(__self__, *,
                 cold_storage_options: Optional[pulumi.Input['DomainColdStorageOptionsArgs']] = None,
                 dedicated_master_count: Optional[pulumi.Input[int]] = None,
                 dedicated_master_enabled: Optional[pulumi.Input[bool]] = None,
                 dedicated_master_type: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 multi_az_with_standby_enabled: Optional[pulumi.Input[bool]] = None,
                 warm_count: Optional[pulumi.Input[int]] = None,
                 warm_enabled: Optional[pulumi.Input[bool]] = None,
                 warm_type: Optional[pulumi.Input[str]] = None,
                 zone_awareness_config: Optional[pulumi.Input['DomainZoneAwarenessConfigArgs']] = None,
                 zone_awareness_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['DomainColdStorageOptionsArgs'] cold_storage_options: Container for cold storage configuration options.
        :param pulumi.Input[int] dedicated_master_count: The number of instances to use for the master node. If you specify this property, you must specify `true` for the `DedicatedMasterEnabled` property.
        :param pulumi.Input[bool] dedicated_master_enabled: Indicates whether to use a dedicated master node for the OpenSearch Service domain. A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See [Dedicated master nodes in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html) .
        :param pulumi.Input[str] dedicated_master_type: The hardware configuration of the computer that hosts the dedicated master node, such as `m3.medium.search` . If you specify this property, you must specify `true` for the `DedicatedMasterEnabled` property. For valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) .
        :param pulumi.Input[int] instance_count: The number of data nodes (instances) to use in the OpenSearch Service domain.
        :param pulumi.Input[str] instance_type: The instance type for your data nodes, such as `m3.medium.search` . For valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) .
        :param pulumi.Input[bool] multi_az_with_standby_enabled: Indicates whether Multi-AZ with Standby deployment option is enabled. For more information, see [Multi-AZ with Standby](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html#managedomains-za-standby) .
        :param pulumi.Input[int] warm_count: The number of warm nodes in the cluster.
        :param pulumi.Input[bool] warm_enabled: Whether to enable UltraWarm storage for the cluster. See [UltraWarm storage for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ultrawarm.html) .
        :param pulumi.Input[str] warm_type: The instance type for the cluster's warm nodes.
        :param pulumi.Input['DomainZoneAwarenessConfigArgs'] zone_awareness_config: Specifies zone awareness configuration options. Only use if `ZoneAwarenessEnabled` is `true` .
        :param pulumi.Input[bool] zone_awareness_enabled: Indicates whether to enable zone awareness for the OpenSearch Service domain. When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html) .
        """
        if cold_storage_options is not None:
            pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        if dedicated_master_count is not None:
            pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        if dedicated_master_enabled is not None:
            pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        if dedicated_master_type is not None:
            pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if multi_az_with_standby_enabled is not None:
            pulumi.set(__self__, "multi_az_with_standby_enabled", multi_az_with_standby_enabled)
        if warm_count is not None:
            pulumi.set(__self__, "warm_count", warm_count)
        if warm_enabled is not None:
            pulumi.set(__self__, "warm_enabled", warm_enabled)
        if warm_type is not None:
            pulumi.set(__self__, "warm_type", warm_type)
        if zone_awareness_config is not None:
            pulumi.set(__self__, "zone_awareness_config", zone_awareness_config)
        if zone_awareness_enabled is not None:
            pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)

    @property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Optional[pulumi.Input['DomainColdStorageOptionsArgs']]:
        """
        Container for cold storage configuration options.
        """
        return pulumi.get(self, "cold_storage_options")

    @cold_storage_options.setter
    def cold_storage_options(self, value: Optional[pulumi.Input['DomainColdStorageOptionsArgs']]):
        pulumi.set(self, "cold_storage_options", value)

    @property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances to use for the master node. If you specify this property, you must specify `true` for the `DedicatedMasterEnabled` property.
        """
        return pulumi.get(self, "dedicated_master_count")

    @dedicated_master_count.setter
    def dedicated_master_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dedicated_master_count", value)

    @property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use a dedicated master node for the OpenSearch Service domain. A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See [Dedicated master nodes in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html) .
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @dedicated_master_enabled.setter
    def dedicated_master_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dedicated_master_enabled", value)

    @property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> Optional[pulumi.Input[str]]:
        """
        The hardware configuration of the computer that hosts the dedicated master node, such as `m3.medium.search` . If you specify this property, you must specify `true` for the `DedicatedMasterEnabled` property. For valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) .
        """
        return pulumi.get(self, "dedicated_master_type")

    @dedicated_master_type.setter
    def dedicated_master_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_master_type", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of data nodes (instances) to use in the OpenSearch Service domain.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type for your data nodes, such as `m3.medium.search` . For valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) .
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="multiAzWithStandbyEnabled")
    def multi_az_with_standby_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Multi-AZ with Standby deployment option is enabled. For more information, see [Multi-AZ with Standby](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html#managedomains-za-standby) .
        """
        return pulumi.get(self, "multi_az_with_standby_enabled")

    @multi_az_with_standby_enabled.setter
    def multi_az_with_standby_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az_with_standby_enabled", value)

    @property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of warm nodes in the cluster.
        """
        return pulumi.get(self, "warm_count")

    @warm_count.setter
    def warm_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_count", value)

    @property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable UltraWarm storage for the cluster. See [UltraWarm storage for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ultrawarm.html) .
        """
        return pulumi.get(self, "warm_enabled")

    @warm_enabled.setter
    def warm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "warm_enabled", value)

    @property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type for the cluster's warm nodes.
        """
        return pulumi.get(self, "warm_type")

    @warm_type.setter
    def warm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warm_type", value)

    @property
    @pulumi.getter(name="zoneAwarenessConfig")
    def zone_awareness_config(self) -> Optional[pulumi.Input['DomainZoneAwarenessConfigArgs']]:
        """
        Specifies zone awareness configuration options. Only use if `ZoneAwarenessEnabled` is `true` .
        """
        return pulumi.get(self, "zone_awareness_config")

    @zone_awareness_config.setter
    def zone_awareness_config(self, value: Optional[pulumi.Input['DomainZoneAwarenessConfigArgs']]):
        pulumi.set(self, "zone_awareness_config", value)

    @property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable zone awareness for the OpenSearch Service domain. When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html) .
        """
        return pulumi.get(self, "zone_awareness_enabled")

    @zone_awareness_enabled.setter
    def zone_awareness_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "zone_awareness_enabled", value)


if not MYPY:
    class DomainCognitoOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards. See [Amazon Cognito authentication for OpenSearch Dashboards](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html) .
        """
        identity_pool_id: NotRequired[pulumi.Input[str]]
        """
        The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.

        Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The `AmazonOpenSearchServiceCognitoAccess` role that allows OpenSearch Service to configure your user pool and identity pool.

        Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
        user_pool_id: NotRequired[pulumi.Input[str]]
        """
        The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.

        Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
elif False:
    DomainCognitoOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainCognitoOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 identity_pool_id: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards. See [Amazon Cognito authentication for OpenSearch Dashboards](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html) .
        :param pulumi.Input[str] identity_pool_id: The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
               
               Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        :param pulumi.Input[str] role_arn: The `AmazonOpenSearchServiceCognitoAccess` role that allows OpenSearch Service to configure your user pool and identity pool.
               
               Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        :param pulumi.Input[str] user_pool_id: The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
               
               Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if identity_pool_id is not None:
            pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards. See [Amazon Cognito authentication for OpenSearch Dashboards](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html) .
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.

        Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_pool_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The `AmazonOpenSearchServiceCognitoAccess` role that allows OpenSearch Service to configure your user pool and identity pool.

        Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.

        Required if you enabled Cognito Authentication for OpenSearch Dashboards.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_pool_id", value)


if not MYPY:
    class DomainColdStorageOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether to enable or disable cold storage on the domain. You must enable UltraWarm storage to enable cold storage.
        """
elif False:
    DomainColdStorageOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainColdStorageOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether to enable or disable cold storage on the domain. You must enable UltraWarm storage to enable cold storage.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable or disable cold storage on the domain. You must enable UltraWarm storage to enable cold storage.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainEbsOptionsArgsDict(TypedDict):
        ebs_enabled: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
        """
        iops: NotRequired[pulumi.Input[int]]
        """
        The number of I/O operations per second (IOPS) that the volume supports. This property applies only to the `gp3` and provisioned IOPS EBS volume types.
        """
        throughput: NotRequired[pulumi.Input[int]]
        """
        The throughput (in MiB/s) of the EBS volumes attached to data nodes. Applies only to the `gp3` volume type.
        """
        volume_size: NotRequired[pulumi.Input[int]]
        """
        The size (in GiB) of the EBS volume for each data node. The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see [EBS volume size limits](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource) in the *Amazon OpenSearch Service Developer Guide* .
        """
        volume_type: NotRequired[pulumi.Input[str]]
        """
        The EBS volume type to use with the OpenSearch Service domain. If you choose `gp3` , you must also specify values for `Iops` and `Throughput` . For more information about each type, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) in the *Amazon EC2 User Guide for Linux Instances* .
        """
elif False:
    DomainEbsOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEbsOptionsArgs:
    def __init__(__self__, *,
                 ebs_enabled: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] ebs_enabled: Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
        :param pulumi.Input[int] iops: The number of I/O operations per second (IOPS) that the volume supports. This property applies only to the `gp3` and provisioned IOPS EBS volume types.
        :param pulumi.Input[int] throughput: The throughput (in MiB/s) of the EBS volumes attached to data nodes. Applies only to the `gp3` volume type.
        :param pulumi.Input[int] volume_size: The size (in GiB) of the EBS volume for each data node. The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see [EBS volume size limits](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource) in the *Amazon OpenSearch Service Developer Guide* .
        :param pulumi.Input[str] volume_type: The EBS volume type to use with the OpenSearch Service domain. If you choose `gp3` , you must also specify values for `Iops` and `Throughput` . For more information about each type, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) in the *Amazon EC2 User Guide for Linux Instances* .
        """
        if ebs_enabled is not None:
            pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @ebs_enabled.setter
    def ebs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_enabled", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The number of I/O operations per second (IOPS) that the volume supports. This property applies only to the `gp3` and provisioned IOPS EBS volume types.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The throughput (in MiB/s) of the EBS volumes attached to data nodes. Applies only to the `gp3` volume type.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size (in GiB) of the EBS volume for each data node. The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see [EBS volume size limits](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource) in the *Amazon OpenSearch Service Developer Guide* .
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The EBS volume type to use with the OpenSearch Service domain. If you choose `gp3` , you must also specify values for `Iops` and `Throughput` . For more information about each type, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) in the *Amazon EC2 User Guide for Linux Instances* .
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class DomainEncryptionAtRestOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Specify `true` to enable encryption at rest. Required if you enable fine-grained access control in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .

        If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
        """
        kms_key_id: NotRequired[pulumi.Input[str]]
        """
        The KMS key ID. Takes the form `1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a` . Required if you enable encryption at rest.

        You can also use `keyAlias` as a value.

        If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
        """
elif False:
    DomainEncryptionAtRestOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEncryptionAtRestOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Specify `true` to enable encryption at rest. Required if you enable fine-grained access control in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
               
               If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
        :param pulumi.Input[str] kms_key_id: The KMS key ID. Takes the form `1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a` . Required if you enable encryption at rest.
               
               You can also use `keyAlias` as a value.
               
               If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify `true` to enable encryption at rest. Required if you enable fine-grained access control in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .

        If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key ID. Takes the form `1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a` . Required if you enable encryption at rest.

        You can also use `keyAlias` as a value.

        If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


if not MYPY:
    class DomainEndpointOptionsArgsDict(TypedDict):
        custom_endpoint: NotRequired[pulumi.Input[str]]
        """
        The fully qualified URL for your custom endpoint. Required if you enabled a custom endpoint for the domain.
        """
        custom_endpoint_certificate_arn: NotRequired[pulumi.Input[str]]
        """
        The AWS Certificate Manager ARN for your domain's SSL/TLS certificate. Required if you enabled a custom endpoint for the domain.
        """
        custom_endpoint_enabled: NotRequired[pulumi.Input[bool]]
        """
        True to enable a custom endpoint for the domain. If enabled, you must also provide values for `CustomEndpoint` and `CustomEndpointCertificateArn` .
        """
        enforce_https: NotRequired[pulumi.Input[bool]]
        """
        True to require that all traffic to the domain arrive over HTTPS. Required if you enable fine-grained access control in [AdvancedSecurityOptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
        tls_security_policy: NotRequired[pulumi.Input[str]]
        """
        The minimum TLS version required for traffic to the domain. The policy can be one of the following values:

        - *Policy-Min-TLS-1-0-2019-07:* TLS security policy that supports TLS version 1.0 to TLS version 1.2
        - *Policy-Min-TLS-1-2-2019-07:* TLS security policy that supports only TLS version 1.2
        - *Policy-Min-TLS-1-2-PFS-2023-10:* TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
        """
elif False:
    DomainEndpointOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEndpointOptionsArgs:
    def __init__(__self__, *,
                 custom_endpoint: Optional[pulumi.Input[str]] = None,
                 custom_endpoint_certificate_arn: Optional[pulumi.Input[str]] = None,
                 custom_endpoint_enabled: Optional[pulumi.Input[bool]] = None,
                 enforce_https: Optional[pulumi.Input[bool]] = None,
                 tls_security_policy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] custom_endpoint: The fully qualified URL for your custom endpoint. Required if you enabled a custom endpoint for the domain.
        :param pulumi.Input[str] custom_endpoint_certificate_arn: The AWS Certificate Manager ARN for your domain's SSL/TLS certificate. Required if you enabled a custom endpoint for the domain.
        :param pulumi.Input[bool] custom_endpoint_enabled: True to enable a custom endpoint for the domain. If enabled, you must also provide values for `CustomEndpoint` and `CustomEndpointCertificateArn` .
        :param pulumi.Input[bool] enforce_https: True to require that all traffic to the domain arrive over HTTPS. Required if you enable fine-grained access control in [AdvancedSecurityOptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        :param pulumi.Input[str] tls_security_policy: The minimum TLS version required for traffic to the domain. The policy can be one of the following values:
               
               - *Policy-Min-TLS-1-0-2019-07:* TLS security policy that supports TLS version 1.0 to TLS version 1.2
               - *Policy-Min-TLS-1-2-2019-07:* TLS security policy that supports only TLS version 1.2
               - *Policy-Min-TLS-1-2-PFS-2023-10:* TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
        """
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if custom_endpoint_certificate_arn is not None:
            pulumi.set(__self__, "custom_endpoint_certificate_arn", custom_endpoint_certificate_arn)
        if custom_endpoint_enabled is not None:
            pulumi.set(__self__, "custom_endpoint_enabled", custom_endpoint_enabled)
        if enforce_https is not None:
            pulumi.set(__self__, "enforce_https", enforce_https)
        if tls_security_policy is not None:
            pulumi.set(__self__, "tls_security_policy", tls_security_policy)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL for your custom endpoint. Required if you enabled a custom endpoint for the domain.
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="customEndpointCertificateArn")
    def custom_endpoint_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Certificate Manager ARN for your domain's SSL/TLS certificate. Required if you enabled a custom endpoint for the domain.
        """
        return pulumi.get(self, "custom_endpoint_certificate_arn")

    @custom_endpoint_certificate_arn.setter
    def custom_endpoint_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_endpoint_certificate_arn", value)

    @property
    @pulumi.getter(name="customEndpointEnabled")
    def custom_endpoint_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True to enable a custom endpoint for the domain. If enabled, you must also provide values for `CustomEndpoint` and `CustomEndpointCertificateArn` .
        """
        return pulumi.get(self, "custom_endpoint_enabled")

    @custom_endpoint_enabled.setter
    def custom_endpoint_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_endpoint_enabled", value)

    @property
    @pulumi.getter(name="enforceHttps")
    def enforce_https(self) -> Optional[pulumi.Input[bool]]:
        """
        True to require that all traffic to the domain arrive over HTTPS. Required if you enable fine-grained access control in [AdvancedSecurityOptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
        return pulumi.get(self, "enforce_https")

    @enforce_https.setter
    def enforce_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_https", value)

    @property
    @pulumi.getter(name="tlsSecurityPolicy")
    def tls_security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum TLS version required for traffic to the domain. The policy can be one of the following values:

        - *Policy-Min-TLS-1-0-2019-07:* TLS security policy that supports TLS version 1.0 to TLS version 1.2
        - *Policy-Min-TLS-1-2-2019-07:* TLS security policy that supports only TLS version 1.2
        - *Policy-Min-TLS-1-2-PFS-2023-10:* TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
        """
        return pulumi.get(self, "tls_security_policy")

    @tls_security_policy.setter
    def tls_security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_security_policy", value)


if not MYPY:
    class DomainIdpArgsDict(TypedDict):
        entity_id: pulumi.Input[str]
        """
        The unique entity ID of the application in the SAML identity provider.
        """
        metadata_content: pulumi.Input[str]
        """
        The metadata of the SAML application, in XML format.
        """
elif False:
    DomainIdpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainIdpArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[str],
                 metadata_content: pulumi.Input[str]):
        """
        :param pulumi.Input[str] entity_id: The unique entity ID of the application in the SAML identity provider.
        :param pulumi.Input[str] metadata_content: The metadata of the SAML application, in XML format.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "metadata_content", metadata_content)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[str]:
        """
        The unique entity ID of the application in the SAML identity provider.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="metadataContent")
    def metadata_content(self) -> pulumi.Input[str]:
        """
        The metadata of the SAML application, in XML format.
        """
        return pulumi.get(self, "metadata_content")

    @metadata_content.setter
    def metadata_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata_content", value)


if not MYPY:
    class DomainJwtOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        public_key: NotRequired[pulumi.Input[str]]
        roles_key: NotRequired[pulumi.Input[str]]
        subject_key: NotRequired[pulumi.Input[str]]
elif False:
    DomainJwtOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainJwtOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 roles_key: Optional[pulumi.Input[str]] = None,
                 subject_key: Optional[pulumi.Input[str]] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "roles_key")

    @roles_key.setter
    def roles_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "roles_key", value)

    @property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subject_key")

    @subject_key.setter
    def subject_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_key", value)


if not MYPY:
    class DomainLogPublishingOptionArgsDict(TypedDict):
        cloud_watch_logs_log_group_arn: NotRequired[pulumi.Input[str]]
        enabled: NotRequired[pulumi.Input[bool]]
elif False:
    DomainLogPublishingOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainLogPublishingOptionArgs:
    def __init__(__self__, *,
                 cloud_watch_logs_log_group_arn: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        if cloud_watch_logs_log_group_arn is not None:
            pulumi.set(__self__, "cloud_watch_logs_log_group_arn", cloud_watch_logs_log_group_arn)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroupArn")
    def cloud_watch_logs_log_group_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_watch_logs_log_group_arn")

    @cloud_watch_logs_log_group_arn.setter
    def cloud_watch_logs_log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_watch_logs_log_group_arn", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainMasterUserOptionsArgsDict(TypedDict):
        master_user_arn: NotRequired[pulumi.Input[str]]
        """
        Amazon Resource Name (ARN) for the master user. The ARN can point to an IAM user or role. This property is required for Amazon Cognito to work, and it must match the role configured for Cognito. Only specify if `InternalUserDatabaseEnabled` is false in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
        master_user_name: NotRequired[pulumi.Input[str]]
        """
        Username for the master user. Only specify if `InternalUserDatabaseEnabled` is true in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .

        If you don't want to specify this value directly within the template, you can use a [dynamic reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) instead.
        """
        master_user_password: NotRequired[pulumi.Input[str]]
        """
        Password for the master user. Only specify if `InternalUserDatabaseEnabled` is true in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .

        If you don't want to specify this value directly within the template, you can use a [dynamic reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) instead.
        """
elif False:
    DomainMasterUserOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainMasterUserOptionsArgs:
    def __init__(__self__, *,
                 master_user_arn: Optional[pulumi.Input[str]] = None,
                 master_user_name: Optional[pulumi.Input[str]] = None,
                 master_user_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] master_user_arn: Amazon Resource Name (ARN) for the master user. The ARN can point to an IAM user or role. This property is required for Amazon Cognito to work, and it must match the role configured for Cognito. Only specify if `InternalUserDatabaseEnabled` is false in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        :param pulumi.Input[str] master_user_name: Username for the master user. Only specify if `InternalUserDatabaseEnabled` is true in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
               
               If you don't want to specify this value directly within the template, you can use a [dynamic reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) instead.
        :param pulumi.Input[str] master_user_password: Password for the master user. Only specify if `InternalUserDatabaseEnabled` is true in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
               
               If you don't want to specify this value directly within the template, you can use a [dynamic reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) instead.
        """
        if master_user_arn is not None:
            pulumi.set(__self__, "master_user_arn", master_user_arn)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)

    @property
    @pulumi.getter(name="masterUserArn")
    def master_user_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) for the master user. The ARN can point to an IAM user or role. This property is required for Amazon Cognito to work, and it must match the role configured for Cognito. Only specify if `InternalUserDatabaseEnabled` is false in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
        return pulumi.get(self, "master_user_arn")

    @master_user_arn.setter
    def master_user_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_arn", value)

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username for the master user. Only specify if `InternalUserDatabaseEnabled` is true in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .

        If you don't want to specify this value directly within the template, you can use a [dynamic reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) instead.
        """
        return pulumi.get(self, "master_user_name")

    @master_user_name.setter
    def master_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_name", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the master user. Only specify if `InternalUserDatabaseEnabled` is true in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .

        If you don't want to specify this value directly within the template, you can use a [dynamic reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) instead.
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_password", value)


if not MYPY:
    class DomainNodeToNodeEncryptionOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Specifies to enable or disable node-to-node encryption on the domain. Required if you enable fine-grained access control in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
elif False:
    DomainNodeToNodeEncryptionOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNodeToNodeEncryptionOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies to enable or disable node-to-node encryption on the domain. Required if you enable fine-grained access control in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies to enable or disable node-to-node encryption on the domain. Required if you enable fine-grained access control in [AdvancedSecurityOptionsInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html) .
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainOffPeakWindowOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether off-peak window settings are enabled for the domain.
        """
        off_peak_window: NotRequired[pulumi.Input['DomainOffPeakWindowArgsDict']]
        """
        Off-peak window settings for the domain.
        """
elif False:
    DomainOffPeakWindowOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainOffPeakWindowOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 off_peak_window: Optional[pulumi.Input['DomainOffPeakWindowArgs']] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies whether off-peak window settings are enabled for the domain.
        :param pulumi.Input['DomainOffPeakWindowArgs'] off_peak_window: Off-peak window settings for the domain.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if off_peak_window is not None:
            pulumi.set(__self__, "off_peak_window", off_peak_window)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether off-peak window settings are enabled for the domain.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="offPeakWindow")
    def off_peak_window(self) -> Optional[pulumi.Input['DomainOffPeakWindowArgs']]:
        """
        Off-peak window settings for the domain.
        """
        return pulumi.get(self, "off_peak_window")

    @off_peak_window.setter
    def off_peak_window(self, value: Optional[pulumi.Input['DomainOffPeakWindowArgs']]):
        pulumi.set(self, "off_peak_window", value)


if not MYPY:
    class DomainOffPeakWindowArgsDict(TypedDict):
        window_start_time: NotRequired[pulumi.Input['DomainWindowStartTimeArgsDict']]
        """
        The desired start time for an off-peak maintenance window.
        """
elif False:
    DomainOffPeakWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainOffPeakWindowArgs:
    def __init__(__self__, *,
                 window_start_time: Optional[pulumi.Input['DomainWindowStartTimeArgs']] = None):
        """
        :param pulumi.Input['DomainWindowStartTimeArgs'] window_start_time: The desired start time for an off-peak maintenance window.
        """
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[pulumi.Input['DomainWindowStartTimeArgs']]:
        """
        The desired start time for an off-peak maintenance window.
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: Optional[pulumi.Input['DomainWindowStartTimeArgs']]):
        pulumi.set(self, "window_start_time", value)


if not MYPY:
    class DomainSamlOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        True to enable SAML authentication for a domain.
        """
        idp: NotRequired[pulumi.Input['DomainIdpArgsDict']]
        """
        The SAML Identity Provider's information.
        """
        master_backend_role: NotRequired[pulumi.Input[str]]
        """
        The backend role that the SAML master user is mapped to.
        """
        master_user_name: NotRequired[pulumi.Input[str]]
        """
        The SAML master user name, which is stored in the domain's internal user database.
        """
        roles_key: NotRequired[pulumi.Input[str]]
        """
        Element of the SAML assertion to use for backend roles. Default is `roles` .
        """
        session_timeout_minutes: NotRequired[pulumi.Input[int]]
        """
        The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
        """
        subject_key: NotRequired[pulumi.Input[str]]
        """
        Element of the SAML assertion to use for the user name. Default is `NameID` .
        """
elif False:
    DomainSamlOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSamlOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp: Optional[pulumi.Input['DomainIdpArgs']] = None,
                 master_backend_role: Optional[pulumi.Input[str]] = None,
                 master_user_name: Optional[pulumi.Input[str]] = None,
                 roles_key: Optional[pulumi.Input[str]] = None,
                 session_timeout_minutes: Optional[pulumi.Input[int]] = None,
                 subject_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: True to enable SAML authentication for a domain.
        :param pulumi.Input['DomainIdpArgs'] idp: The SAML Identity Provider's information.
        :param pulumi.Input[str] master_backend_role: The backend role that the SAML master user is mapped to.
        :param pulumi.Input[str] master_user_name: The SAML master user name, which is stored in the domain's internal user database.
        :param pulumi.Input[str] roles_key: Element of the SAML assertion to use for backend roles. Default is `roles` .
        :param pulumi.Input[int] session_timeout_minutes: The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
        :param pulumi.Input[str] subject_key: Element of the SAML assertion to use for the user name. Default is `NameID` .
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp is not None:
            pulumi.set(__self__, "idp", idp)
        if master_backend_role is not None:
            pulumi.set(__self__, "master_backend_role", master_backend_role)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if session_timeout_minutes is not None:
            pulumi.set(__self__, "session_timeout_minutes", session_timeout_minutes)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True to enable SAML authentication for a domain.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def idp(self) -> Optional[pulumi.Input['DomainIdpArgs']]:
        """
        The SAML Identity Provider's information.
        """
        return pulumi.get(self, "idp")

    @idp.setter
    def idp(self, value: Optional[pulumi.Input['DomainIdpArgs']]):
        pulumi.set(self, "idp", value)

    @property
    @pulumi.getter(name="masterBackendRole")
    def master_backend_role(self) -> Optional[pulumi.Input[str]]:
        """
        The backend role that the SAML master user is mapped to.
        """
        return pulumi.get(self, "master_backend_role")

    @master_backend_role.setter
    def master_backend_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_backend_role", value)

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The SAML master user name, which is stored in the domain's internal user database.
        """
        return pulumi.get(self, "master_user_name")

    @master_user_name.setter
    def master_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_name", value)

    @property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[pulumi.Input[str]]:
        """
        Element of the SAML assertion to use for backend roles. Default is `roles` .
        """
        return pulumi.get(self, "roles_key")

    @roles_key.setter
    def roles_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "roles_key", value)

    @property
    @pulumi.getter(name="sessionTimeoutMinutes")
    def session_timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.
        """
        return pulumi.get(self, "session_timeout_minutes")

    @session_timeout_minutes.setter
    def session_timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout_minutes", value)

    @property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[pulumi.Input[str]]:
        """
        Element of the SAML assertion to use for the user name. Default is `NameID` .
        """
        return pulumi.get(self, "subject_key")

    @subject_key.setter
    def subject_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_key", value)


if not MYPY:
    class DomainSnapshotOptionsArgsDict(TypedDict):
        automated_snapshot_start_hour: NotRequired[pulumi.Input[int]]
        """
        The hour in UTC during which the service takes an automated daily snapshot of the indexes in the OpenSearch Service domain. For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
        """
elif False:
    DomainSnapshotOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSnapshotOptionsArgs:
    def __init__(__self__, *,
                 automated_snapshot_start_hour: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] automated_snapshot_start_hour: The hour in UTC during which the service takes an automated daily snapshot of the indexes in the OpenSearch Service domain. For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
        """
        if automated_snapshot_start_hour is not None:
            pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> Optional[pulumi.Input[int]]:
        """
        The hour in UTC during which the service takes an automated daily snapshot of the indexes in the OpenSearch Service domain. For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")

    @automated_snapshot_start_hour.setter
    def automated_snapshot_start_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automated_snapshot_start_hour", value)


if not MYPY:
    class DomainSoftwareUpdateOptionsArgsDict(TypedDict):
        auto_software_update_enabled: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether automatic service software updates are enabled for the domain.
        """
elif False:
    DomainSoftwareUpdateOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSoftwareUpdateOptionsArgs:
    def __init__(__self__, *,
                 auto_software_update_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] auto_software_update_enabled: Specifies whether automatic service software updates are enabled for the domain.
        """
        if auto_software_update_enabled is not None:
            pulumi.set(__self__, "auto_software_update_enabled", auto_software_update_enabled)

    @property
    @pulumi.getter(name="autoSoftwareUpdateEnabled")
    def auto_software_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether automatic service software updates are enabled for the domain.
        """
        return pulumi.get(self, "auto_software_update_enabled")

    @auto_software_update_enabled.setter
    def auto_software_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_software_update_enabled", value)


if not MYPY:
    class DomainVpcOptionsArgsDict(TypedDict):
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of security group IDs that are associated with the VPC endpoints for the domain. If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see [Security groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon VPC User Guide* .
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Provide one subnet ID for each Availability Zone that your domain uses. For example, you must specify three subnet IDs for a three-AZ domain. To learn more, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .

        If you specify more than one subnet, you must also configure `ZoneAwarenessEnabled` and `ZoneAwarenessConfig` within [ClusterConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html) , otherwise you'll see the error "You must specify exactly one subnet" during template creation.
        """
elif False:
    DomainVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainVpcOptionsArgs:
    def __init__(__self__, *,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The list of security group IDs that are associated with the VPC endpoints for the domain. If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see [Security groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon VPC User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Provide one subnet ID for each Availability Zone that your domain uses. For example, you must specify three subnet IDs for a three-AZ domain. To learn more, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .
               
               If you specify more than one subnet, you must also configure `ZoneAwarenessEnabled` and `ZoneAwarenessConfig` within [ClusterConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html) , otherwise you'll see the error "You must specify exactly one subnet" during template creation.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of security group IDs that are associated with the VPC endpoints for the domain. If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see [Security groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon VPC User Guide* .
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Provide one subnet ID for each Availability Zone that your domain uses. For example, you must specify three subnet IDs for a three-AZ domain. To learn more, see [VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the *Amazon VPC User Guide* .

        If you specify more than one subnet, you must also configure `ZoneAwarenessEnabled` and `ZoneAwarenessConfig` within [ClusterConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html) , otherwise you'll see the error "You must specify exactly one subnet" during template creation.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


if not MYPY:
    class DomainWindowStartTimeArgsDict(TypedDict):
        hours: pulumi.Input[int]
        """
        The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time. For example, 17 refers to 5:00 P.M. UTC. The minimum value is 0 and the maximum value is 23.
        """
        minutes: pulumi.Input[int]
        """
        The start minute of the window, in UTC. The minimum value is 0 and the maximum value is 59.
        """
elif False:
    DomainWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: pulumi.Input[int],
                 minutes: pulumi.Input[int]):
        """
        :param pulumi.Input[int] hours: The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time. For example, 17 refers to 5:00 P.M. UTC. The minimum value is 0 and the maximum value is 23.
        :param pulumi.Input[int] minutes: The start minute of the window, in UTC. The minimum value is 0 and the maximum value is 59.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[int]:
        """
        The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time. For example, 17 refers to 5:00 P.M. UTC. The minimum value is 0 and the maximum value is 23.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[int]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[int]:
        """
        The start minute of the window, in UTC. The minimum value is 0 and the maximum value is 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "minutes", value)


if not MYPY:
    class DomainZoneAwarenessConfigArgsDict(TypedDict):
        availability_zone_count: NotRequired[pulumi.Input[int]]
        """
        If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.

        Valid values are `2` and `3` . Default is 2.
        """
elif False:
    DomainZoneAwarenessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainZoneAwarenessConfigArgs:
    def __init__(__self__, *,
                 availability_zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] availability_zone_count: If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
               
               Valid values are `2` and `3` . Default is 2.
        """
        if availability_zone_count is not None:
            pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.

        Valid values are `2` and `3` . Default is 2.
        """
        return pulumi.get(self, "availability_zone_count")

    @availability_zone_count.setter
    def availability_zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "availability_zone_count", value)


