# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetLifecyclePolicyResult',
    'AwaitableGetLifecyclePolicyResult',
    'get_lifecycle_policy',
    'get_lifecycle_policy_output',
]

@pulumi.output_type
class GetLifecyclePolicyResult:
    def __init__(__self__, description=None, policy=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        The JSON policy document that is the content for the policy
        """
        return pulumi.get(self, "policy")


class AwaitableGetLifecyclePolicyResult(GetLifecyclePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLifecyclePolicyResult(
            description=self.description,
            policy=self.policy)


def get_lifecycle_policy(name: Optional[str] = None,
                         type: Optional['LifecyclePolicyType'] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLifecyclePolicyResult:
    """
    Amazon OpenSearchServerless lifecycle policy resource


    :param str name: The name of the policy
    :param 'LifecyclePolicyType' type: The type of lifecycle policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getLifecyclePolicy', __args__, opts=opts, typ=GetLifecyclePolicyResult).value

    return AwaitableGetLifecyclePolicyResult(
        description=pulumi.get(__ret__, 'description'),
        policy=pulumi.get(__ret__, 'policy'))
def get_lifecycle_policy_output(name: Optional[pulumi.Input[str]] = None,
                                type: Optional[pulumi.Input['LifecyclePolicyType']] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLifecyclePolicyResult]:
    """
    Amazon OpenSearchServerless lifecycle policy resource


    :param str name: The name of the policy
    :param 'LifecyclePolicyType' type: The type of lifecycle policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchserverless:getLifecyclePolicy', __args__, opts=opts, typ=GetLifecyclePolicyResult)
    return __ret__.apply(lambda __response__: GetLifecyclePolicyResult(
        description=pulumi.get(__response__, 'description'),
        policy=pulumi.get(__response__, 'policy')))
