# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetCollectionResult',
    'AwaitableGetCollectionResult',
    'get_collection',
    'get_collection_output',
]

@pulumi.output_type
class GetCollectionResult:
    def __init__(__self__, arn=None, collection_endpoint=None, dashboard_endpoint=None, description=None, id=None, standby_replicas=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if collection_endpoint and not isinstance(collection_endpoint, str):
            raise TypeError("Expected argument 'collection_endpoint' to be a str")
        pulumi.set(__self__, "collection_endpoint", collection_endpoint)
        if dashboard_endpoint and not isinstance(dashboard_endpoint, str):
            raise TypeError("Expected argument 'dashboard_endpoint' to be a str")
        pulumi.set(__self__, "dashboard_endpoint", dashboard_endpoint)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if standby_replicas and not isinstance(standby_replicas, str):
            raise TypeError("Expected argument 'standby_replicas' to be a str")
        pulumi.set(__self__, "standby_replicas", standby_replicas)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the collection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collectionEndpoint")
    def collection_endpoint(self) -> Optional[str]:
        """
        The endpoint for the collection.
        """
        return pulumi.get(self, "collection_endpoint")

    @property
    @pulumi.getter(name="dashboardEndpoint")
    def dashboard_endpoint(self) -> Optional[str]:
        """
        The OpenSearch Dashboards endpoint for the collection.
        """
        return pulumi.get(self, "dashboard_endpoint")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the collection
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the collection
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="standbyReplicas")
    def standby_replicas(self) -> Optional['CollectionStandbyReplicas']:
        """
        Indicates whether to use standby replicas for the collection. You can't update this property after the collection is already created. If you attempt to modify this property, the collection continues to use the original value.
        """
        return pulumi.get(self, "standby_replicas")


class AwaitableGetCollectionResult(GetCollectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCollectionResult(
            arn=self.arn,
            collection_endpoint=self.collection_endpoint,
            dashboard_endpoint=self.dashboard_endpoint,
            description=self.description,
            id=self.id,
            standby_replicas=self.standby_replicas)


def get_collection(id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCollectionResult:
    """
    Amazon OpenSearchServerless collection resource


    :param str id: The identifier of the collection
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getCollection', __args__, opts=opts, typ=GetCollectionResult).value

    return AwaitableGetCollectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        collection_endpoint=pulumi.get(__ret__, 'collection_endpoint'),
        dashboard_endpoint=pulumi.get(__ret__, 'dashboard_endpoint'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        standby_replicas=pulumi.get(__ret__, 'standby_replicas'))
def get_collection_output(id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCollectionResult]:
    """
    Amazon OpenSearchServerless collection resource


    :param str id: The identifier of the collection
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchserverless:getCollection', __args__, opts=opts, typ=GetCollectionResult)
    return __ret__.apply(lambda __response__: GetCollectionResult(
        arn=pulumi.get(__response__, 'arn'),
        collection_endpoint=pulumi.get(__response__, 'collection_endpoint'),
        dashboard_endpoint=pulumi.get(__response__, 'dashboard_endpoint'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        standby_replicas=pulumi.get(__response__, 'standby_replicas')))
