# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'LaunchProfileStreamConfiguration',
    'LaunchProfileStreamConfigurationSessionBackup',
    'LaunchProfileStreamConfigurationSessionStorage',
    'LaunchProfileStreamingSessionStorageRoot',
    'LaunchProfileVolumeConfiguration',
    'StreamingImageEncryptionConfiguration',
    'StudioComponentActiveDirectoryComputerAttribute',
    'StudioComponentActiveDirectoryConfiguration',
    'StudioComponentComputeFarmConfiguration',
    'StudioComponentConfiguration0Properties',
    'StudioComponentConfiguration1Properties',
    'StudioComponentConfiguration2Properties',
    'StudioComponentConfiguration3Properties',
    'StudioComponentInitializationScript',
    'StudioComponentLicenseServiceConfiguration',
    'StudioComponentScriptParameterKeyValue',
    'StudioComponentSharedFileSystemConfiguration',
    'StudioEncryptionConfiguration',
]

@pulumi.output_type
class LaunchProfileStreamConfiguration(dict):
    """
    <p>A configuration for a streaming session.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clipboardMode":
            suggest = "clipboard_mode"
        elif key == "ec2InstanceTypes":
            suggest = "ec2_instance_types"
        elif key == "streamingImageIds":
            suggest = "streaming_image_ids"
        elif key == "automaticTerminationMode":
            suggest = "automatic_termination_mode"
        elif key == "maxSessionLengthInMinutes":
            suggest = "max_session_length_in_minutes"
        elif key == "maxStoppedSessionLengthInMinutes":
            suggest = "max_stopped_session_length_in_minutes"
        elif key == "sessionBackup":
            suggest = "session_backup"
        elif key == "sessionPersistenceMode":
            suggest = "session_persistence_mode"
        elif key == "sessionStorage":
            suggest = "session_storage"
        elif key == "volumeConfiguration":
            suggest = "volume_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchProfileStreamConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchProfileStreamConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchProfileStreamConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clipboard_mode: 'LaunchProfileStreamingClipboardMode',
                 ec2_instance_types: Sequence['LaunchProfileStreamingInstanceType'],
                 streaming_image_ids: Sequence[str],
                 automatic_termination_mode: Optional['LaunchProfileAutomaticTerminationMode'] = None,
                 max_session_length_in_minutes: Optional[float] = None,
                 max_stopped_session_length_in_minutes: Optional[float] = None,
                 session_backup: Optional['outputs.LaunchProfileStreamConfigurationSessionBackup'] = None,
                 session_persistence_mode: Optional['LaunchProfileSessionPersistenceMode'] = None,
                 session_storage: Optional['outputs.LaunchProfileStreamConfigurationSessionStorage'] = None,
                 volume_configuration: Optional['outputs.LaunchProfileVolumeConfiguration'] = None):
        """
        <p>A configuration for a streaming session.</p>
        :param 'LaunchProfileStreamingClipboardMode' clipboard_mode: Allows or deactivates the use of the system clipboard to copy and paste between the streaming session and streaming client.
        :param Sequence['LaunchProfileStreamingInstanceType'] ec2_instance_types: <p>The EC2 instance types that users can select from when launching a streaming session
                           with this launch profile.</p>
        :param Sequence[str] streaming_image_ids: <p>The streaming images that users can select from when launching a streaming session
                           with this launch profile.</p>
        :param 'LaunchProfileAutomaticTerminationMode' automatic_termination_mode: Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a `STOPPED` state.
               
               - When `ACTIVATED` , the streaming session is scheduled for termination after being in the `STOPPED` state for the time specified in `maxStoppedSessionLengthInMinutes` .
               - When `DEACTIVATED` , the streaming session can remain in the `STOPPED` state indefinitely.
               
               This parameter is only allowed when `sessionPersistenceMode` is `ACTIVATED` . When allowed, the default value for this parameter is `DEACTIVATED` .
        :param float max_session_length_in_minutes: <p>The length of time, in minutes, that a streaming session can be active before it is
                           stopped or terminated. After this point, Nimble Studio automatically terminates or
                           stops the session. The default length of time is 690 minutes, and the maximum length of
                           time is 30 days.</p>
        :param float max_stopped_session_length_in_minutes: <p>Integer that determines if you can start and stop your sessions and how long a session
                           can stay in the <code>STOPPED</code> state. The default value is 0. The maximum value is
                           5760.</p>
                        <p>This field is allowed only when <code>sessionPersistenceMode</code> is
                               <code>ACTIVATED</code> and <code>automaticTerminationMode</code> is
                               <code>ACTIVATED</code>.</p>
                        <p>If the value is set to 0, your sessions can’t be <code>STOPPED</code>. If you then
                           call <code>StopStreamingSession</code>, the session fails. If the time that a session
                           stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code>
                           value, the session will automatically be terminated (instead of
                           <code>STOPPED</code>).</p>
                        <p>If the value is set to a positive number, the session can be stopped. You can call
                               <code>StopStreamingSession</code> to stop sessions in the <code>READY</code> state.
                           If the time that a session stays in the <code>READY</code> state exceeds the
                               <code>maxSessionLengthInMinutes</code> value, the session will automatically be
                           stopped (instead of terminated).</p>
        :param 'LaunchProfileStreamConfigurationSessionBackup' session_backup: Information about the streaming session backup.
        :param 'LaunchProfileSessionPersistenceMode' session_persistence_mode: Determine if a streaming session created from this launch profile can configure persistent storage. This means that `volumeConfiguration` and `automaticTerminationMode` are configured.
        :param 'LaunchProfileStreamConfigurationSessionStorage' session_storage: The upload storage for a streaming session.
        :param 'LaunchProfileVolumeConfiguration' volume_configuration: Custom volume configuration for the root volumes that are attached to streaming sessions.
               
               This parameter is only allowed when `sessionPersistenceMode` is `ACTIVATED` .
        """
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "ec2_instance_types", ec2_instance_types)
        pulumi.set(__self__, "streaming_image_ids", streaming_image_ids)
        if automatic_termination_mode is not None:
            pulumi.set(__self__, "automatic_termination_mode", automatic_termination_mode)
        if max_session_length_in_minutes is not None:
            pulumi.set(__self__, "max_session_length_in_minutes", max_session_length_in_minutes)
        if max_stopped_session_length_in_minutes is not None:
            pulumi.set(__self__, "max_stopped_session_length_in_minutes", max_stopped_session_length_in_minutes)
        if session_backup is not None:
            pulumi.set(__self__, "session_backup", session_backup)
        if session_persistence_mode is not None:
            pulumi.set(__self__, "session_persistence_mode", session_persistence_mode)
        if session_storage is not None:
            pulumi.set(__self__, "session_storage", session_storage)
        if volume_configuration is not None:
            pulumi.set(__self__, "volume_configuration", volume_configuration)

    @property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> 'LaunchProfileStreamingClipboardMode':
        """
        Allows or deactivates the use of the system clipboard to copy and paste between the streaming session and streaming client.
        """
        return pulumi.get(self, "clipboard_mode")

    @property
    @pulumi.getter(name="ec2InstanceTypes")
    def ec2_instance_types(self) -> Sequence['LaunchProfileStreamingInstanceType']:
        """
        <p>The EC2 instance types that users can select from when launching a streaming session
                    with this launch profile.</p>
        """
        return pulumi.get(self, "ec2_instance_types")

    @property
    @pulumi.getter(name="streamingImageIds")
    def streaming_image_ids(self) -> Sequence[str]:
        """
        <p>The streaming images that users can select from when launching a streaming session
                    with this launch profile.</p>
        """
        return pulumi.get(self, "streaming_image_ids")

    @property
    @pulumi.getter(name="automaticTerminationMode")
    def automatic_termination_mode(self) -> Optional['LaunchProfileAutomaticTerminationMode']:
        """
        Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a `STOPPED` state.

        - When `ACTIVATED` , the streaming session is scheduled for termination after being in the `STOPPED` state for the time specified in `maxStoppedSessionLengthInMinutes` .
        - When `DEACTIVATED` , the streaming session can remain in the `STOPPED` state indefinitely.

        This parameter is only allowed when `sessionPersistenceMode` is `ACTIVATED` . When allowed, the default value for this parameter is `DEACTIVATED` .
        """
        return pulumi.get(self, "automatic_termination_mode")

    @property
    @pulumi.getter(name="maxSessionLengthInMinutes")
    def max_session_length_in_minutes(self) -> Optional[float]:
        """
        <p>The length of time, in minutes, that a streaming session can be active before it is
                    stopped or terminated. After this point, Nimble Studio automatically terminates or
                    stops the session. The default length of time is 690 minutes, and the maximum length of
                    time is 30 days.</p>
        """
        return pulumi.get(self, "max_session_length_in_minutes")

    @property
    @pulumi.getter(name="maxStoppedSessionLengthInMinutes")
    def max_stopped_session_length_in_minutes(self) -> Optional[float]:
        """
        <p>Integer that determines if you can start and stop your sessions and how long a session
                    can stay in the <code>STOPPED</code> state. The default value is 0. The maximum value is
                    5760.</p>
                 <p>This field is allowed only when <code>sessionPersistenceMode</code> is
                        <code>ACTIVATED</code> and <code>automaticTerminationMode</code> is
                        <code>ACTIVATED</code>.</p>
                 <p>If the value is set to 0, your sessions can’t be <code>STOPPED</code>. If you then
                    call <code>StopStreamingSession</code>, the session fails. If the time that a session
                    stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code>
                    value, the session will automatically be terminated (instead of
                    <code>STOPPED</code>).</p>
                 <p>If the value is set to a positive number, the session can be stopped. You can call
                        <code>StopStreamingSession</code> to stop sessions in the <code>READY</code> state.
                    If the time that a session stays in the <code>READY</code> state exceeds the
                        <code>maxSessionLengthInMinutes</code> value, the session will automatically be
                    stopped (instead of terminated).</p>
        """
        return pulumi.get(self, "max_stopped_session_length_in_minutes")

    @property
    @pulumi.getter(name="sessionBackup")
    def session_backup(self) -> Optional['outputs.LaunchProfileStreamConfigurationSessionBackup']:
        """
        Information about the streaming session backup.
        """
        return pulumi.get(self, "session_backup")

    @property
    @pulumi.getter(name="sessionPersistenceMode")
    def session_persistence_mode(self) -> Optional['LaunchProfileSessionPersistenceMode']:
        """
        Determine if a streaming session created from this launch profile can configure persistent storage. This means that `volumeConfiguration` and `automaticTerminationMode` are configured.
        """
        return pulumi.get(self, "session_persistence_mode")

    @property
    @pulumi.getter(name="sessionStorage")
    def session_storage(self) -> Optional['outputs.LaunchProfileStreamConfigurationSessionStorage']:
        """
        The upload storage for a streaming session.
        """
        return pulumi.get(self, "session_storage")

    @property
    @pulumi.getter(name="volumeConfiguration")
    def volume_configuration(self) -> Optional['outputs.LaunchProfileVolumeConfiguration']:
        """
        Custom volume configuration for the root volumes that are attached to streaming sessions.

        This parameter is only allowed when `sessionPersistenceMode` is `ACTIVATED` .
        """
        return pulumi.get(self, "volume_configuration")


@pulumi.output_type
class LaunchProfileStreamConfigurationSessionBackup(dict):
    """
    <p>Configures how streaming sessions are backed up when launched from this launch
                profile.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBackupsToRetain":
            suggest = "max_backups_to_retain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchProfileStreamConfigurationSessionBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchProfileStreamConfigurationSessionBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchProfileStreamConfigurationSessionBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_backups_to_retain: Optional[float] = None,
                 mode: Optional['LaunchProfileSessionBackupMode'] = None):
        """
        <p>Configures how streaming sessions are backed up when launched from this launch
                    profile.</p>
        :param float max_backups_to_retain: <p>The maximum number of backups that each streaming session created from this launch
                           profile can have.</p>
        :param 'LaunchProfileSessionBackupMode' mode: Specifies how artists sessions are backed up.
               
               Configures backups for streaming sessions launched with this launch profile. The default value is `DEACTIVATED` , which means that backups are deactivated. To allow backups, set this value to `AUTOMATIC` .
        """
        if max_backups_to_retain is not None:
            pulumi.set(__self__, "max_backups_to_retain", max_backups_to_retain)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="maxBackupsToRetain")
    def max_backups_to_retain(self) -> Optional[float]:
        """
        <p>The maximum number of backups that each streaming session created from this launch
                    profile can have.</p>
        """
        return pulumi.get(self, "max_backups_to_retain")

    @property
    @pulumi.getter
    def mode(self) -> Optional['LaunchProfileSessionBackupMode']:
        """
        Specifies how artists sessions are backed up.

        Configures backups for streaming sessions launched with this launch profile. The default value is `DEACTIVATED` , which means that backups are deactivated. To allow backups, set this value to `AUTOMATIC` .
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class LaunchProfileStreamConfigurationSessionStorage(dict):
    """
    <p>The configuration for a streaming session’s upload storage.</p>
    """
    def __init__(__self__, *,
                 mode: Sequence['LaunchProfileStreamingSessionStorageMode'],
                 root: Optional['outputs.LaunchProfileStreamingSessionStorageRoot'] = None):
        """
        <p>The configuration for a streaming session’s upload storage.</p>
        :param Sequence['LaunchProfileStreamingSessionStorageMode'] mode: <p>Allows artists to upload files to their workstations. The only valid option is
                               <code>UPLOAD</code>.</p>
        :param 'LaunchProfileStreamingSessionStorageRoot' root: The configuration for the upload storage root of the streaming session.
        """
        pulumi.set(__self__, "mode", mode)
        if root is not None:
            pulumi.set(__self__, "root", root)

    @property
    @pulumi.getter
    def mode(self) -> Sequence['LaunchProfileStreamingSessionStorageMode']:
        """
        <p>Allows artists to upload files to their workstations. The only valid option is
                        <code>UPLOAD</code>.</p>
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def root(self) -> Optional['outputs.LaunchProfileStreamingSessionStorageRoot']:
        """
        The configuration for the upload storage root of the streaming session.
        """
        return pulumi.get(self, "root")


@pulumi.output_type
class LaunchProfileStreamingSessionStorageRoot(dict):
    """
    <p>The upload storage root location (folder) on streaming workstations where files are
                uploaded.</p>
    """
    def __init__(__self__, *,
                 linux: Optional[str] = None,
                 windows: Optional[str] = None):
        """
        <p>The upload storage root location (folder) on streaming workstations where files are
                    uploaded.</p>
        :param str linux: <p>The folder path in Linux workstations where files are uploaded.</p>
        :param str windows: <p>The folder path in Windows workstations where files are uploaded.</p>
        """
        if linux is not None:
            pulumi.set(__self__, "linux", linux)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter
    def linux(self) -> Optional[str]:
        """
        <p>The folder path in Linux workstations where files are uploaded.</p>
        """
        return pulumi.get(self, "linux")

    @property
    @pulumi.getter
    def windows(self) -> Optional[str]:
        """
        <p>The folder path in Windows workstations where files are uploaded.</p>
        """
        return pulumi.get(self, "windows")


@pulumi.output_type
class LaunchProfileVolumeConfiguration(dict):
    """
    <p>Custom volume configuration for the root volumes that are attached to streaming
                sessions.</p>
             <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is
                    <code>ACTIVATED</code>.</p>
    """
    def __init__(__self__, *,
                 iops: Optional[float] = None,
                 size: Optional[float] = None,
                 throughput: Optional[float] = None):
        """
        <p>Custom volume configuration for the root volumes that are attached to streaming
                    sessions.</p>
                 <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is
                        <code>ACTIVATED</code>.</p>
        :param float iops: <p>The number of I/O operations per second for the root volume that is attached to
                           streaming session.</p>
        :param float size: <p>The size of the root volume that is attached to the streaming session. The root volume
                           size is measured in GiBs.</p>
        :param float throughput: <p>The throughput to provision for the root volume that is attached to the streaming
                           session. The throughput is measured in MiB/s.</p>
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter
    def iops(self) -> Optional[float]:
        """
        <p>The number of I/O operations per second for the root volume that is attached to
                    streaming session.</p>
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def size(self) -> Optional[float]:
        """
        <p>The size of the root volume that is attached to the streaming session. The root volume
                    size is measured in GiBs.</p>
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[float]:
        """
        <p>The throughput to provision for the root volume that is attached to the streaming
                    session. The throughput is measured in MiB/s.</p>
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class StreamingImageEncryptionConfiguration(dict):
    """
    <p>TODO</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingImageEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingImageEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingImageEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_type: 'StreamingImageEncryptionConfigurationKeyType',
                 key_arn: Optional[str] = None):
        """
        <p>TODO</p>
        :param 'StreamingImageEncryptionConfigurationKeyType' key_type: The type of KMS key that is used to encrypt studio data.
        :param str key_arn: <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        """
        pulumi.set(__self__, "key_type", key_type)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> 'StreamingImageEncryptionConfigurationKeyType':
        """
        The type of KMS key that is used to encrypt studio data.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[str]:
        """
        <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        """
        return pulumi.get(self, "key_arn")


@pulumi.output_type
class StudioComponentActiveDirectoryComputerAttribute(dict):
    """
    <p>An LDAP attribute of an Active Directory computer account, in the form of a name:value
                pair.</p>
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        <p>An LDAP attribute of an Active Directory computer account, in the form of a name:value
                    pair.</p>
        :param str name: <p>The name for the LDAP attribute.</p>
        :param str value: <p>The value for the LDAP attribute.</p>
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        <p>The name for the LDAP attribute.</p>
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        <p>The value for the LDAP attribute.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StudioComponentActiveDirectoryConfiguration(dict):
    """
    <p>The configuration for a Microsoft Active Directory (Microsoft AD) studio
                resource.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerAttributes":
            suggest = "computer_attributes"
        elif key == "directoryId":
            suggest = "directory_id"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_attributes: Optional[Sequence['outputs.StudioComponentActiveDirectoryComputerAttribute']] = None,
                 directory_id: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        <p>The configuration for a Microsoft Active Directory (Microsoft AD) studio
                    resource.</p>
        :param Sequence['StudioComponentActiveDirectoryComputerAttribute'] computer_attributes: <p>A collection of custom attributes for an Active Directory computer.</p>
        :param str directory_id: <p>The directory ID of the Directory Service for Microsoft Active Directory to access
                           using this studio component.</p>
        :param str organizational_unit_distinguished_name: <p>The distinguished name (DN) and organizational unit (OU) of an Active Directory
                           computer.</p>
        """
        if computer_attributes is not None:
            pulumi.set(__self__, "computer_attributes", computer_attributes)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="computerAttributes")
    def computer_attributes(self) -> Optional[Sequence['outputs.StudioComponentActiveDirectoryComputerAttribute']]:
        """
        <p>A collection of custom attributes for an Active Directory computer.</p>
        """
        return pulumi.get(self, "computer_attributes")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[str]:
        """
        <p>The directory ID of the Directory Service for Microsoft Active Directory to access
                    using this studio component.</p>
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        <p>The distinguished name (DN) and organizational unit (OU) of an Active Directory
                    computer.</p>
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class StudioComponentComputeFarmConfiguration(dict):
    """
    <p>The configuration for a render farm that is associated with a studio resource.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryUser":
            suggest = "active_directory_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentComputeFarmConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentComputeFarmConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentComputeFarmConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_user: Optional[str] = None,
                 endpoint: Optional[str] = None):
        """
        <p>The configuration for a render farm that is associated with a studio resource.</p>
        :param str active_directory_user: <p>The name of an Active Directory user that is used on ComputeFarm worker
                           instances.</p>
        :param str endpoint: <p>The endpoint of the ComputeFarm that is accessed by the studio component
                           resource.</p>
        """
        if active_directory_user is not None:
            pulumi.set(__self__, "active_directory_user", active_directory_user)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="activeDirectoryUser")
    def active_directory_user(self) -> Optional[str]:
        """
        <p>The name of an Active Directory user that is used on ComputeFarm worker
                    instances.</p>
        """
        return pulumi.get(self, "active_directory_user")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        <p>The endpoint of the ComputeFarm that is accessed by the studio component
                    resource.</p>
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class StudioComponentConfiguration0Properties(dict):
    """
    <p>The configuration of the studio component, based on component type.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryConfiguration":
            suggest = "active_directory_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentConfiguration0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentConfiguration0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentConfiguration0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_configuration: 'outputs.StudioComponentActiveDirectoryConfiguration'):
        """
        <p>The configuration of the studio component, based on component type.</p>
        """
        pulumi.set(__self__, "active_directory_configuration", active_directory_configuration)

    @property
    @pulumi.getter(name="activeDirectoryConfiguration")
    def active_directory_configuration(self) -> 'outputs.StudioComponentActiveDirectoryConfiguration':
        return pulumi.get(self, "active_directory_configuration")


@pulumi.output_type
class StudioComponentConfiguration1Properties(dict):
    """
    <p>The configuration of the studio component, based on component type.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeFarmConfiguration":
            suggest = "compute_farm_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentConfiguration1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentConfiguration1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentConfiguration1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_farm_configuration: 'outputs.StudioComponentComputeFarmConfiguration'):
        """
        <p>The configuration of the studio component, based on component type.</p>
        """
        pulumi.set(__self__, "compute_farm_configuration", compute_farm_configuration)

    @property
    @pulumi.getter(name="computeFarmConfiguration")
    def compute_farm_configuration(self) -> 'outputs.StudioComponentComputeFarmConfiguration':
        return pulumi.get(self, "compute_farm_configuration")


@pulumi.output_type
class StudioComponentConfiguration2Properties(dict):
    """
    <p>The configuration of the studio component, based on component type.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "licenseServiceConfiguration":
            suggest = "license_service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentConfiguration2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentConfiguration2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentConfiguration2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 license_service_configuration: 'outputs.StudioComponentLicenseServiceConfiguration'):
        """
        <p>The configuration of the studio component, based on component type.</p>
        """
        pulumi.set(__self__, "license_service_configuration", license_service_configuration)

    @property
    @pulumi.getter(name="licenseServiceConfiguration")
    def license_service_configuration(self) -> 'outputs.StudioComponentLicenseServiceConfiguration':
        return pulumi.get(self, "license_service_configuration")


@pulumi.output_type
class StudioComponentConfiguration3Properties(dict):
    """
    <p>The configuration of the studio component, based on component type.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharedFileSystemConfiguration":
            suggest = "shared_file_system_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentConfiguration3Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentConfiguration3Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentConfiguration3Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shared_file_system_configuration: 'outputs.StudioComponentSharedFileSystemConfiguration'):
        """
        <p>The configuration of the studio component, based on component type.</p>
        """
        pulumi.set(__self__, "shared_file_system_configuration", shared_file_system_configuration)

    @property
    @pulumi.getter(name="sharedFileSystemConfiguration")
    def shared_file_system_configuration(self) -> 'outputs.StudioComponentSharedFileSystemConfiguration':
        return pulumi.get(self, "shared_file_system_configuration")


@pulumi.output_type
class StudioComponentInitializationScript(dict):
    """
    <p>Initialization scripts for studio components.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchProfileProtocolVersion":
            suggest = "launch_profile_protocol_version"
        elif key == "runContext":
            suggest = "run_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentInitializationScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentInitializationScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentInitializationScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_profile_protocol_version: Optional[str] = None,
                 platform: Optional['StudioComponentLaunchProfilePlatform'] = None,
                 run_context: Optional['StudioComponentInitializationScriptRunContext'] = None,
                 script: Optional[str] = None):
        """
        <p>Initialization scripts for studio components.</p>
        :param str launch_profile_protocol_version: <p>The version number of the protocol that is used by the launch profile. The only valid
                           version is "2021-03-31".</p>
        :param 'StudioComponentLaunchProfilePlatform' platform: The platform of the initialization script, either Windows or Linux.
        :param 'StudioComponentInitializationScriptRunContext' run_context: The method to use when running the initialization script.
        :param str script: <p>The initialization script.</p>
        """
        if launch_profile_protocol_version is not None:
            pulumi.set(__self__, "launch_profile_protocol_version", launch_profile_protocol_version)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if run_context is not None:
            pulumi.set(__self__, "run_context", run_context)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter(name="launchProfileProtocolVersion")
    def launch_profile_protocol_version(self) -> Optional[str]:
        """
        <p>The version number of the protocol that is used by the launch profile. The only valid
                    version is "2021-03-31".</p>
        """
        return pulumi.get(self, "launch_profile_protocol_version")

    @property
    @pulumi.getter
    def platform(self) -> Optional['StudioComponentLaunchProfilePlatform']:
        """
        The platform of the initialization script, either Windows or Linux.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="runContext")
    def run_context(self) -> Optional['StudioComponentInitializationScriptRunContext']:
        """
        The method to use when running the initialization script.
        """
        return pulumi.get(self, "run_context")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        <p>The initialization script.</p>
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class StudioComponentLicenseServiceConfiguration(dict):
    """
    <p>The configuration for a license service that is associated with a studio
                resource.</p>
    """
    def __init__(__self__, *,
                 endpoint: Optional[str] = None):
        """
        <p>The configuration for a license service that is associated with a studio
                    resource.</p>
        :param str endpoint: <p>The endpoint of the license service that is accessed by the studio component
                           resource.</p>
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        <p>The endpoint of the license service that is accessed by the studio component
                    resource.</p>
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class StudioComponentScriptParameterKeyValue(dict):
    """
    <p>A parameter for a studio component script, in the form of a key:value pair.</p>
    """
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        <p>A parameter for a studio component script, in the form of a key:value pair.</p>
        :param str key: <p>A script parameter key.</p>
        :param str value: <p>A script parameter value.</p>
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        <p>A script parameter key.</p>
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        <p>A script parameter value.</p>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StudioComponentSharedFileSystemConfiguration(dict):
    """
    <p>The configuration for a shared file storage system that is associated with a studio
                resource.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "linuxMountPoint":
            suggest = "linux_mount_point"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "windowsMountDrive":
            suggest = "windows_mount_drive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentSharedFileSystemConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentSharedFileSystemConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentSharedFileSystemConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[str] = None,
                 file_system_id: Optional[str] = None,
                 linux_mount_point: Optional[str] = None,
                 share_name: Optional[str] = None,
                 windows_mount_drive: Optional[str] = None):
        """
        <p>The configuration for a shared file storage system that is associated with a studio
                    resource.</p>
        :param str endpoint: <p>The endpoint of the shared file system that is accessed by the studio component
                           resource.</p>
        :param str file_system_id: <p>The unique identifier for a file system.</p>
        :param str linux_mount_point: <p>The mount location for a shared file system on a Linux virtual workstation.</p>
        :param str share_name: <p>The name of the file share.</p>
        :param str windows_mount_drive: <p>The mount location for a shared file system on a Windows virtual workstation.</p>
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if linux_mount_point is not None:
            pulumi.set(__self__, "linux_mount_point", linux_mount_point)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if windows_mount_drive is not None:
            pulumi.set(__self__, "windows_mount_drive", windows_mount_drive)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        <p>The endpoint of the shared file system that is accessed by the studio component
                    resource.</p>
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        <p>The unique identifier for a file system.</p>
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="linuxMountPoint")
    def linux_mount_point(self) -> Optional[str]:
        """
        <p>The mount location for a shared file system on a Linux virtual workstation.</p>
        """
        return pulumi.get(self, "linux_mount_point")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[str]:
        """
        <p>The name of the file share.</p>
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="windowsMountDrive")
    def windows_mount_drive(self) -> Optional[str]:
        """
        <p>The mount location for a shared file system on a Windows virtual workstation.</p>
        """
        return pulumi.get(self, "windows_mount_drive")


@pulumi.output_type
class StudioEncryptionConfiguration(dict):
    """
    <p>Configuration of the encryption method that is used for the studio.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_type: 'StudioEncryptionConfigurationKeyType',
                 key_arn: Optional[str] = None):
        """
        <p>Configuration of the encryption method that is used for the studio.</p>
        :param 'StudioEncryptionConfigurationKeyType' key_type: The type of KMS key that is used to encrypt studio data.
        :param str key_arn: <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        """
        pulumi.set(__self__, "key_type", key_type)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> 'StudioEncryptionConfigurationKeyType':
        """
        The type of KMS key that is used to encrypt studio data.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[str]:
        """
        <p>The ARN for a KMS key that is used to encrypt studio data.</p>
        """
        return pulumi.get(self, "key_arn")


