# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectAttachmentOptionsArgs',
    'ConnectAttachmentOptionsArgsDict',
    'ConnectAttachmentProposedNetworkFunctionGroupChangeArgs',
    'ConnectAttachmentProposedNetworkFunctionGroupChangeArgsDict',
    'ConnectAttachmentProposedSegmentChangeArgs',
    'ConnectAttachmentProposedSegmentChangeArgsDict',
    'ConnectAttachmentTagArgs',
    'ConnectAttachmentTagArgsDict',
    'ConnectPeerBgpOptionsArgs',
    'ConnectPeerBgpOptionsArgsDict',
    'DeviceAwsLocationArgs',
    'DeviceAwsLocationArgsDict',
    'DeviceLocationArgs',
    'DeviceLocationArgsDict',
    'LinkBandwidthArgs',
    'LinkBandwidthArgsDict',
    'SiteLocationArgs',
    'SiteLocationArgsDict',
    'SiteToSiteVpnAttachmentProposedNetworkFunctionGroupChangeArgs',
    'SiteToSiteVpnAttachmentProposedNetworkFunctionGroupChangeArgsDict',
    'SiteToSiteVpnAttachmentProposedSegmentChangeArgs',
    'SiteToSiteVpnAttachmentProposedSegmentChangeArgsDict',
    'SiteToSiteVpnAttachmentTagArgs',
    'SiteToSiteVpnAttachmentTagArgsDict',
    'TransitGatewayRouteTableAttachmentProposedNetworkFunctionGroupChangeArgs',
    'TransitGatewayRouteTableAttachmentProposedNetworkFunctionGroupChangeArgsDict',
    'TransitGatewayRouteTableAttachmentProposedSegmentChangeArgs',
    'TransitGatewayRouteTableAttachmentProposedSegmentChangeArgsDict',
    'TransitGatewayRouteTableAttachmentTagArgs',
    'TransitGatewayRouteTableAttachmentTagArgsDict',
    'VpcAttachmentProposedNetworkFunctionGroupChangeArgs',
    'VpcAttachmentProposedNetworkFunctionGroupChangeArgsDict',
    'VpcAttachmentProposedSegmentChangeArgs',
    'VpcAttachmentProposedSegmentChangeArgsDict',
    'VpcAttachmentTagArgs',
    'VpcAttachmentTagArgsDict',
    'VpcAttachmentVpcOptionsArgs',
    'VpcAttachmentVpcOptionsArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectAttachmentOptionsArgsDict(TypedDict):
        """
        Connect attachment options for protocol
        """
        protocol: NotRequired[pulumi.Input[str]]
        """
        Tunnel protocol for connect attachment
        """
elif False:
    ConnectAttachmentOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectAttachmentOptionsArgs:
    def __init__(__self__, *,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        Connect attachment options for protocol
        :param pulumi.Input[str] protocol: Tunnel protocol for connect attachment
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel protocol for connect attachment
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class ConnectAttachmentProposedNetworkFunctionGroupChangeArgsDict(TypedDict):
        """
        The attachment to move from one network function group to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        network_function_group_name: NotRequired[pulumi.Input[str]]
        """
        The name of the network function group to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the network function group.
        """
elif False:
    ConnectAttachmentProposedNetworkFunctionGroupChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectAttachmentProposedNetworkFunctionGroupChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 network_function_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one network function group to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] network_function_group_name: The name of the network function group to change.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]] tags: The key-value tags that changed for the network function group.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if network_function_group_name is not None:
            pulumi.set(__self__, "network_function_group_name", network_function_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="networkFunctionGroupName")
    def network_function_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network function group to change.
        """
        return pulumi.get(self, "network_function_group_name")

    @network_function_group_name.setter
    def network_function_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_function_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the network function group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class ConnectAttachmentProposedSegmentChangeArgsDict(TypedDict):
        """
        The attachment to move from one segment to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        segment_name: NotRequired[pulumi.Input[str]]
        """
        The name of the segment to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgsDict']]]]
        """
        The list of key-value tags that changed for the segment.
        """
elif False:
    ConnectAttachmentProposedSegmentChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectAttachmentProposedSegmentChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 segment_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one segment to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] segment_name: The name of the segment to change.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]] tags: The list of key-value tags that changed for the segment.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the segment to change.
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]]]:
        """
        The list of key-value tags that changed for the segment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class ConnectAttachmentTagArgsDict(TypedDict):
        """
        A key-value pair to associate with a resource.
        """
        key: pulumi.Input[str]
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        value: pulumi.Input[str]
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
elif False:
    ConnectAttachmentTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectAttachmentTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ConnectPeerBgpOptionsArgsDict(TypedDict):
        """
        Bgp options
        """
        peer_asn: NotRequired[pulumi.Input[float]]
        """
        The Peer ASN of the BGP.
        """
elif False:
    ConnectPeerBgpOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectPeerBgpOptionsArgs:
    def __init__(__self__, *,
                 peer_asn: Optional[pulumi.Input[float]] = None):
        """
        Bgp options
        :param pulumi.Input[float] peer_asn: The Peer ASN of the BGP.
        """
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[float]]:
        """
        The Peer ASN of the BGP.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "peer_asn", value)


if not MYPY:
    class DeviceAwsLocationArgsDict(TypedDict):
        """
        The Amazon Web Services location of the device, if applicable.
        """
        subnet_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the subnet that the device is located in.
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
elif False:
    DeviceAwsLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAwsLocationArgs:
    def __init__(__self__, *,
                 subnet_arn: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The Amazon Web Services location of the device, if applicable.
        :param pulumi.Input[str] subnet_arn: The Amazon Resource Name (ARN) of the subnet that the device is located in.
        :param pulumi.Input[str] zone: The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        if subnet_arn is not None:
            pulumi.set(__self__, "subnet_arn", subnet_arn)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the subnet that the device is located in.
        """
        return pulumi.get(self, "subnet_arn")

    @subnet_arn.setter
    def subnet_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_arn", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class DeviceLocationArgsDict(TypedDict):
        """
        The site location.
        """
        address: NotRequired[pulumi.Input[str]]
        """
        The physical address.
        """
        latitude: NotRequired[pulumi.Input[str]]
        """
        The latitude.
        """
        longitude: NotRequired[pulumi.Input[str]]
        """
        The longitude.
        """
elif False:
    DeviceLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceLocationArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[str]] = None):
        """
        The site location.
        :param pulumi.Input[str] address: The physical address.
        :param pulumi.Input[str] latitude: The latitude.
        :param pulumi.Input[str] longitude: The longitude.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The physical address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[str]]:
        """
        The latitude.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[str]]:
        """
        The longitude.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "longitude", value)


if not MYPY:
    class LinkBandwidthArgsDict(TypedDict):
        """
        The bandwidth for the link.
        """
        download_speed: NotRequired[pulumi.Input[int]]
        """
        Download speed in Mbps.
        """
        upload_speed: NotRequired[pulumi.Input[int]]
        """
        Upload speed in Mbps.
        """
elif False:
    LinkBandwidthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LinkBandwidthArgs:
    def __init__(__self__, *,
                 download_speed: Optional[pulumi.Input[int]] = None,
                 upload_speed: Optional[pulumi.Input[int]] = None):
        """
        The bandwidth for the link.
        :param pulumi.Input[int] download_speed: Download speed in Mbps.
        :param pulumi.Input[int] upload_speed: Upload speed in Mbps.
        """
        if download_speed is not None:
            pulumi.set(__self__, "download_speed", download_speed)
        if upload_speed is not None:
            pulumi.set(__self__, "upload_speed", upload_speed)

    @property
    @pulumi.getter(name="downloadSpeed")
    def download_speed(self) -> Optional[pulumi.Input[int]]:
        """
        Download speed in Mbps.
        """
        return pulumi.get(self, "download_speed")

    @download_speed.setter
    def download_speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "download_speed", value)

    @property
    @pulumi.getter(name="uploadSpeed")
    def upload_speed(self) -> Optional[pulumi.Input[int]]:
        """
        Upload speed in Mbps.
        """
        return pulumi.get(self, "upload_speed")

    @upload_speed.setter
    def upload_speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "upload_speed", value)


if not MYPY:
    class SiteLocationArgsDict(TypedDict):
        """
        The location of the site
        """
        address: NotRequired[pulumi.Input[str]]
        """
        The physical address.
        """
        latitude: NotRequired[pulumi.Input[str]]
        """
        The latitude.
        """
        longitude: NotRequired[pulumi.Input[str]]
        """
        The longitude.
        """
elif False:
    SiteLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SiteLocationArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[str]] = None):
        """
        The location of the site
        :param pulumi.Input[str] address: The physical address.
        :param pulumi.Input[str] latitude: The latitude.
        :param pulumi.Input[str] longitude: The longitude.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The physical address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[str]]:
        """
        The latitude.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[str]]:
        """
        The longitude.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "longitude", value)


if not MYPY:
    class SiteToSiteVpnAttachmentProposedNetworkFunctionGroupChangeArgsDict(TypedDict):
        """
        The attachment to move from one network function group to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        network_function_group_name: NotRequired[pulumi.Input[str]]
        """
        The name of the network function group to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the network function group.
        """
elif False:
    SiteToSiteVpnAttachmentProposedNetworkFunctionGroupChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SiteToSiteVpnAttachmentProposedNetworkFunctionGroupChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 network_function_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one network function group to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] network_function_group_name: The name of the network function group to change.
        :param pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]] tags: The key-value tags that changed for the network function group.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if network_function_group_name is not None:
            pulumi.set(__self__, "network_function_group_name", network_function_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="networkFunctionGroupName")
    def network_function_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network function group to change.
        """
        return pulumi.get(self, "network_function_group_name")

    @network_function_group_name.setter
    def network_function_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_function_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the network function group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class SiteToSiteVpnAttachmentProposedSegmentChangeArgsDict(TypedDict):
        """
        The attachment to move from one segment to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        segment_name: NotRequired[pulumi.Input[str]]
        """
        The name of the segment to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the segment.
        """
elif False:
    SiteToSiteVpnAttachmentProposedSegmentChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SiteToSiteVpnAttachmentProposedSegmentChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 segment_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one segment to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] segment_name: The name of the segment to change.
        :param pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]] tags: The key-value tags that changed for the segment.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the segment to change.
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the segment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SiteToSiteVpnAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class SiteToSiteVpnAttachmentTagArgsDict(TypedDict):
        """
        A key-value pair to associate with a resource.
        """
        key: pulumi.Input[str]
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        value: pulumi.Input[str]
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
elif False:
    SiteToSiteVpnAttachmentTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SiteToSiteVpnAttachmentTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TransitGatewayRouteTableAttachmentProposedNetworkFunctionGroupChangeArgsDict(TypedDict):
        """
        The attachment to move from one network function group to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        network_function_group_name: NotRequired[pulumi.Input[str]]
        """
        The name of the network function group to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the network function group.
        """
elif False:
    TransitGatewayRouteTableAttachmentProposedNetworkFunctionGroupChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TransitGatewayRouteTableAttachmentProposedNetworkFunctionGroupChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 network_function_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one network function group to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] network_function_group_name: The name of the network function group to change.
        :param pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]] tags: The key-value tags that changed for the network function group.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if network_function_group_name is not None:
            pulumi.set(__self__, "network_function_group_name", network_function_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="networkFunctionGroupName")
    def network_function_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network function group to change.
        """
        return pulumi.get(self, "network_function_group_name")

    @network_function_group_name.setter
    def network_function_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_function_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the network function group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class TransitGatewayRouteTableAttachmentProposedSegmentChangeArgsDict(TypedDict):
        """
        The attachment to move from one segment to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        segment_name: NotRequired[pulumi.Input[str]]
        """
        The name of the segment to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the segment.
        """
elif False:
    TransitGatewayRouteTableAttachmentProposedSegmentChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TransitGatewayRouteTableAttachmentProposedSegmentChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 segment_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one segment to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] segment_name: The name of the segment to change.
        :param pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]] tags: The key-value tags that changed for the segment.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the segment to change.
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the segment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayRouteTableAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class TransitGatewayRouteTableAttachmentTagArgsDict(TypedDict):
        """
        A key-value pair to associate with a resource.
        """
        key: pulumi.Input[str]
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        value: pulumi.Input[str]
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
elif False:
    TransitGatewayRouteTableAttachmentTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TransitGatewayRouteTableAttachmentTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class VpcAttachmentProposedNetworkFunctionGroupChangeArgsDict(TypedDict):
        """
        The attachment to move from one network function group to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        network_function_group_name: NotRequired[pulumi.Input[str]]
        """
        The name of the network function group to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the network function group.
        """
elif False:
    VpcAttachmentProposedNetworkFunctionGroupChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcAttachmentProposedNetworkFunctionGroupChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 network_function_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one network function group to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] network_function_group_name: The name of the network function group to change.
        :param pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]] tags: The key-value tags that changed for the network function group.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if network_function_group_name is not None:
            pulumi.set(__self__, "network_function_group_name", network_function_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="networkFunctionGroupName")
    def network_function_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network function group to change.
        """
        return pulumi.get(self, "network_function_group_name")

    @network_function_group_name.setter
    def network_function_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_function_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the network function group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class VpcAttachmentProposedSegmentChangeArgsDict(TypedDict):
        """
        The attachment to move from one segment to another.
        """
        attachment_policy_rule_number: NotRequired[pulumi.Input[int]]
        """
        The rule number in the policy document that applies to this change.
        """
        segment_name: NotRequired[pulumi.Input[str]]
        """
        The name of the segment to change.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgsDict']]]]
        """
        The key-value tags that changed for the segment.
        """
elif False:
    VpcAttachmentProposedSegmentChangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcAttachmentProposedSegmentChangeArgs:
    def __init__(__self__, *,
                 attachment_policy_rule_number: Optional[pulumi.Input[int]] = None,
                 segment_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]]] = None):
        """
        The attachment to move from one segment to another.
        :param pulumi.Input[int] attachment_policy_rule_number: The rule number in the policy document that applies to this change.
        :param pulumi.Input[str] segment_name: The name of the segment to change.
        :param pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]] tags: The key-value tags that changed for the segment.
        """
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        The rule number in the policy document that applies to this change.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the segment to change.
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]]]:
        """
        The key-value tags that changed for the segment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcAttachmentTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class VpcAttachmentTagArgsDict(TypedDict):
        """
        A key-value pair to associate with a resource.
        """
        key: pulumi.Input[str]
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        value: pulumi.Input[str]
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
elif False:
    VpcAttachmentTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcAttachmentTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class VpcAttachmentVpcOptionsArgsDict(TypedDict):
        """
        Vpc options of the attachment.
        """
        appliance_mode_support: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to enable ApplianceModeSupport Support for Vpc Attachment. Valid Values: true | false
        """
        ipv6_support: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to enable Ipv6 Support for Vpc Attachment. Valid Values: enable | disable
        """
elif False:
    VpcAttachmentVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcAttachmentVpcOptionsArgs:
    def __init__(__self__, *,
                 appliance_mode_support: Optional[pulumi.Input[bool]] = None,
                 ipv6_support: Optional[pulumi.Input[bool]] = None):
        """
        Vpc options of the attachment.
        :param pulumi.Input[bool] appliance_mode_support: Indicates whether to enable ApplianceModeSupport Support for Vpc Attachment. Valid Values: true | false
        :param pulumi.Input[bool] ipv6_support: Indicates whether to enable Ipv6 Support for Vpc Attachment. Valid Values: enable | disable
        """
        if appliance_mode_support is not None:
            pulumi.set(__self__, "appliance_mode_support", appliance_mode_support)
        if ipv6_support is not None:
            pulumi.set(__self__, "ipv6_support", ipv6_support)

    @property
    @pulumi.getter(name="applianceModeSupport")
    def appliance_mode_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable ApplianceModeSupport Support for Vpc Attachment. Valid Values: true | false
        """
        return pulumi.get(self, "appliance_mode_support")

    @appliance_mode_support.setter
    def appliance_mode_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "appliance_mode_support", value)

    @property
    @pulumi.getter(name="ipv6Support")
    def ipv6_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable Ipv6 Support for Vpc Attachment. Valid Values: enable | disable
        """
        return pulumi.get(self, "ipv6_support")

    @ipv6_support.setter
    def ipv6_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_support", value)


