# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTlsInspectionConfigurationResult',
    'AwaitableGetTlsInspectionConfigurationResult',
    'get_tls_inspection_configuration',
    'get_tls_inspection_configuration_output',
]

@pulumi.output_type
class GetTlsInspectionConfigurationResult:
    def __init__(__self__, description=None, tags=None, tls_inspection_configuration=None, tls_inspection_configuration_arn=None, tls_inspection_configuration_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tls_inspection_configuration and not isinstance(tls_inspection_configuration, dict):
            raise TypeError("Expected argument 'tls_inspection_configuration' to be a dict")
        pulumi.set(__self__, "tls_inspection_configuration", tls_inspection_configuration)
        if tls_inspection_configuration_arn and not isinstance(tls_inspection_configuration_arn, str):
            raise TypeError("Expected argument 'tls_inspection_configuration_arn' to be a str")
        pulumi.set(__self__, "tls_inspection_configuration_arn", tls_inspection_configuration_arn)
        if tls_inspection_configuration_id and not isinstance(tls_inspection_configuration_id, str):
            raise TypeError("Expected argument 'tls_inspection_configuration_id' to be a str")
        pulumi.set(__self__, "tls_inspection_configuration_id", tls_inspection_configuration_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the TLS inspection configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The key:value pairs to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsInspectionConfiguration")
    def tls_inspection_configuration(self) -> Optional['outputs.TlsInspectionConfigurationTlsInspectionConfiguration']:
        """
        The object that defines a TLS inspection configuration. AWS Network Firewall uses TLS inspection configurations to decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, AWS Network Firewall inspects the traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using AWS Certificate Manager , create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall. For more information about using TLS inspection configurations, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *AWS Network Firewall Developer Guide* .
        """
        return pulumi.get(self, "tls_inspection_configuration")

    @property
    @pulumi.getter(name="tlsInspectionConfigurationArn")
    def tls_inspection_configuration_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the TLS inspection configuration.
        """
        return pulumi.get(self, "tls_inspection_configuration_arn")

    @property
    @pulumi.getter(name="tlsInspectionConfigurationId")
    def tls_inspection_configuration_id(self) -> Optional[str]:
        """
        A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create and list commands. You provide it to operations such as update and delete.
        """
        return pulumi.get(self, "tls_inspection_configuration_id")


class AwaitableGetTlsInspectionConfigurationResult(GetTlsInspectionConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTlsInspectionConfigurationResult(
            description=self.description,
            tags=self.tags,
            tls_inspection_configuration=self.tls_inspection_configuration,
            tls_inspection_configuration_arn=self.tls_inspection_configuration_arn,
            tls_inspection_configuration_id=self.tls_inspection_configuration_id)


def get_tls_inspection_configuration(tls_inspection_configuration_arn: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTlsInspectionConfigurationResult:
    """
    Resource type definition for AWS::NetworkFirewall::TLSInspectionConfiguration


    :param str tls_inspection_configuration_arn: The Amazon Resource Name (ARN) of the TLS inspection configuration.
    """
    __args__ = dict()
    __args__['tlsInspectionConfigurationArn'] = tls_inspection_configuration_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:networkfirewall:getTlsInspectionConfiguration', __args__, opts=opts, typ=GetTlsInspectionConfigurationResult).value

    return AwaitableGetTlsInspectionConfigurationResult(
        description=pulumi.get(__ret__, 'description'),
        tags=pulumi.get(__ret__, 'tags'),
        tls_inspection_configuration=pulumi.get(__ret__, 'tls_inspection_configuration'),
        tls_inspection_configuration_arn=pulumi.get(__ret__, 'tls_inspection_configuration_arn'),
        tls_inspection_configuration_id=pulumi.get(__ret__, 'tls_inspection_configuration_id'))
def get_tls_inspection_configuration_output(tls_inspection_configuration_arn: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTlsInspectionConfigurationResult]:
    """
    Resource type definition for AWS::NetworkFirewall::TLSInspectionConfiguration


    :param str tls_inspection_configuration_arn: The Amazon Resource Name (ARN) of the TLS inspection configuration.
    """
    __args__ = dict()
    __args__['tlsInspectionConfigurationArn'] = tls_inspection_configuration_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:networkfirewall:getTlsInspectionConfiguration', __args__, opts=opts, typ=GetTlsInspectionConfigurationResult)
    return __ret__.apply(lambda __response__: GetTlsInspectionConfigurationResult(
        description=pulumi.get(__response__, 'description'),
        tags=pulumi.get(__response__, 'tags'),
        tls_inspection_configuration=pulumi.get(__response__, 'tls_inspection_configuration'),
        tls_inspection_configuration_arn=pulumi.get(__response__, 'tls_inspection_configuration_arn'),
        tls_inspection_configuration_id=pulumi.get(__response__, 'tls_inspection_configuration_id')))
