# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['DbClusterArgs', 'DbCluster']

@pulumi.input_type
class DbClusterArgs:
    def __init__(__self__, *,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_instance_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[int]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 serverless_scaling_configuration: Optional[pulumi.Input['DbClusterServerlessScalingConfigurationArgs']] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DbCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]] associated_roles: Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
        :param pulumi.Input[int] backup_retention_period: Specifies the number of days for which automatic DB snapshots are retained.
        :param pulumi.Input[bool] copy_tags_to_snapshot: A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default behaviour is not to copy them.
        :param pulumi.Input[str] db_cluster_identifier: The DB cluster identifier. Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster stored as a lowercase string.
        :param pulumi.Input[str] db_cluster_parameter_group_name: Provides the name of the DB cluster parameter group.
        :param pulumi.Input[str] db_instance_parameter_group_name: The name of the DB parameter group to apply to all instances of the DB cluster. Used only in case of a major EngineVersion upgrade request.
        :param pulumi.Input[int] db_port: The port number on which the DB instances in the DB cluster accept connections. 
               
               If not specified, the default port used is `8182`. 
               
               Note: `Port` property will soon be deprecated from this resource. Please update existing templates to rename it with new property `DBPort` having same functionalities.
        :param pulumi.Input[str] db_subnet_group_name: Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
        :param pulumi.Input[bool] deletion_protection: Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enable_cloudwatch_logs_exports: Specifies a list of log types that are enabled for export to CloudWatch Logs.
        :param pulumi.Input[str] engine_version: Indicates the database engine version.
        :param pulumi.Input[bool] iam_auth_enabled: True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
        :param pulumi.Input[str] kms_key_id: The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default KMS key is used. If you specify this property, you must set the StorageEncrypted property to true.
        :param pulumi.Input[str] preferred_backup_window: Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the BackupRetentionPeriod.
        :param pulumi.Input[str] preferred_maintenance_window: Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
        :param pulumi.Input[str] restore_to_time: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[str] restore_type: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input['DbClusterServerlessScalingConfigurationArgs'] serverless_scaling_configuration: Contains the scaling configuration used by the Neptune Serverless Instances within this DB cluster.
        :param pulumi.Input[str] snapshot_identifier: Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.
               
               After you restore a DB cluster using a SnapshotIdentifier, you must specify the same SnapshotIdentifier for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.
               
               However, if you don't specify the SnapshotIdentifier, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the SnapshotIdentifier, and the original DB cluster is deleted.
        :param pulumi.Input[str] source_db_cluster_identifier: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[bool] storage_encrypted: Indicates whether the DB cluster is encrypted.
               
               If you specify the KmsKeyId property, then you must enable encryption and set this property to true.
               
               If you enable the StorageEncrypted property but don't specify KmsKeyId property, then the default KMS key is used. If you specify KmsKeyId property, then that KMS Key is used to encrypt the database instances in the DB cluster.
               
               If you specify the SourceDBClusterIdentifier property and don't specify this property or disable it. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the KmsKeyId property from the source cluster is used.
               
               If you specify the DBSnapshotIdentifier and don't specify this property or disable it. The value is inherited from the snapshot, and the specified KmsKeyId property from the snapshot is used.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags assigned to this cluster.
        :param pulumi.Input[bool] use_latest_restorable_time: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: Provides a list of VPC security groups that the DB cluster belongs to.
        """
        if associated_roles is not None:
            pulumi.set(__self__, "associated_roles", associated_roles)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if db_cluster_identifier is not None:
            pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if db_cluster_parameter_group_name is not None:
            pulumi.set(__self__, "db_cluster_parameter_group_name", db_cluster_parameter_group_name)
        if db_instance_parameter_group_name is not None:
            pulumi.set(__self__, "db_instance_parameter_group_name", db_instance_parameter_group_name)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enable_cloudwatch_logs_exports", enable_cloudwatch_logs_exports)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if iam_auth_enabled is not None:
            pulumi.set(__self__, "iam_auth_enabled", iam_auth_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if serverless_scaling_configuration is not None:
            pulumi.set(__self__, "serverless_scaling_configuration", serverless_scaling_configuration)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if source_db_cluster_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]]]:
        """
        Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        """
        return pulumi.get(self, "associated_roles")

    @associated_roles.setter
    def associated_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]]]):
        pulumi.set(self, "associated_roles", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days for which automatic DB snapshots are retained.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default behaviour is not to copy them.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The DB cluster identifier. Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster stored as a lowercase string.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Provides the name of the DB cluster parameter group.
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @db_cluster_parameter_group_name.setter
    def db_cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbInstanceParameterGroupName")
    def db_instance_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DB parameter group to apply to all instances of the DB cluster. Used only in case of a major EngineVersion upgrade request.
        """
        return pulumi.get(self, "db_instance_parameter_group_name")

    @db_instance_parameter_group_name.setter
    def db_instance_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which the DB instances in the DB cluster accept connections. 

        If not specified, the default port used is `8182`. 

        Note: `Port` property will soon be deprecated from this resource. Please update existing templates to rename it with new property `DBPort` having same functionalities.
        """
        return pulumi.get(self, "db_port")

    @db_port.setter
    def db_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_port", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies a list of log types that are enabled for export to CloudWatch Logs.
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @enable_cloudwatch_logs_exports.setter
    def enable_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enable_cloudwatch_logs_exports", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the database engine version.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="iamAuthEnabled")
    def iam_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
        """
        return pulumi.get(self, "iam_auth_enabled")

    @iam_auth_enabled.setter
    def iam_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "iam_auth_enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default KMS key is used. If you specify this property, you must set the StorageEncrypted property to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the BackupRetentionPeriod.
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_to_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="serverlessScalingConfiguration")
    def serverless_scaling_configuration(self) -> Optional[pulumi.Input['DbClusterServerlessScalingConfigurationArgs']]:
        """
        Contains the scaling configuration used by the Neptune Serverless Instances within this DB cluster.
        """
        return pulumi.get(self, "serverless_scaling_configuration")

    @serverless_scaling_configuration.setter
    def serverless_scaling_configuration(self, value: Optional[pulumi.Input['DbClusterServerlessScalingConfigurationArgs']]):
        pulumi.set(self, "serverless_scaling_configuration", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.

        After you restore a DB cluster using a SnapshotIdentifier, you must specify the same SnapshotIdentifier for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.

        However, if you don't specify the SnapshotIdentifier, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the SnapshotIdentifier, and the original DB cluster is deleted.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @source_db_cluster_identifier.setter
    def source_db_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_cluster_identifier", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the DB cluster is encrypted.

        If you specify the KmsKeyId property, then you must enable encryption and set this property to true.

        If you enable the StorageEncrypted property but don't specify KmsKeyId property, then the default KMS key is used. If you specify KmsKeyId property, then that KMS Key is used to encrypt the database instances in the DB cluster.

        If you specify the SourceDBClusterIdentifier property and don't specify this property or disable it. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the KmsKeyId property from the source cluster is used.

        If you specify the DBSnapshotIdentifier and don't specify this property or disable it. The value is inherited from the snapshot, and the specified KmsKeyId property from the snapshot is used.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags assigned to this cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Provides a list of VPC security groups that the DB cluster belongs to.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


class DbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterRoleArgs', 'DbClusterDbClusterRoleArgsDict']]]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_instance_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[int]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 serverless_scaling_configuration: Optional[pulumi.Input[Union['DbClusterServerlessScalingConfigurationArgs', 'DbClusterServerlessScalingConfigurationArgsDict']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The AWS::Neptune::DBCluster resource creates an Amazon Neptune DB cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterRoleArgs', 'DbClusterDbClusterRoleArgsDict']]]] associated_roles: Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
        :param pulumi.Input[int] backup_retention_period: Specifies the number of days for which automatic DB snapshots are retained.
        :param pulumi.Input[bool] copy_tags_to_snapshot: A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default behaviour is not to copy them.
        :param pulumi.Input[str] db_cluster_identifier: The DB cluster identifier. Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster stored as a lowercase string.
        :param pulumi.Input[str] db_cluster_parameter_group_name: Provides the name of the DB cluster parameter group.
        :param pulumi.Input[str] db_instance_parameter_group_name: The name of the DB parameter group to apply to all instances of the DB cluster. Used only in case of a major EngineVersion upgrade request.
        :param pulumi.Input[int] db_port: The port number on which the DB instances in the DB cluster accept connections. 
               
               If not specified, the default port used is `8182`. 
               
               Note: `Port` property will soon be deprecated from this resource. Please update existing templates to rename it with new property `DBPort` having same functionalities.
        :param pulumi.Input[str] db_subnet_group_name: Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
        :param pulumi.Input[bool] deletion_protection: Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enable_cloudwatch_logs_exports: Specifies a list of log types that are enabled for export to CloudWatch Logs.
        :param pulumi.Input[str] engine_version: Indicates the database engine version.
        :param pulumi.Input[bool] iam_auth_enabled: True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
        :param pulumi.Input[str] kms_key_id: The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default KMS key is used. If you specify this property, you must set the StorageEncrypted property to true.
        :param pulumi.Input[str] preferred_backup_window: Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the BackupRetentionPeriod.
        :param pulumi.Input[str] preferred_maintenance_window: Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
        :param pulumi.Input[str] restore_to_time: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[str] restore_type: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[Union['DbClusterServerlessScalingConfigurationArgs', 'DbClusterServerlessScalingConfigurationArgsDict']] serverless_scaling_configuration: Contains the scaling configuration used by the Neptune Serverless Instances within this DB cluster.
        :param pulumi.Input[str] snapshot_identifier: Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.
               
               After you restore a DB cluster using a SnapshotIdentifier, you must specify the same SnapshotIdentifier for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.
               
               However, if you don't specify the SnapshotIdentifier, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the SnapshotIdentifier, and the original DB cluster is deleted.
        :param pulumi.Input[str] source_db_cluster_identifier: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[bool] storage_encrypted: Indicates whether the DB cluster is encrypted.
               
               If you specify the KmsKeyId property, then you must enable encryption and set this property to true.
               
               If you enable the StorageEncrypted property but don't specify KmsKeyId property, then the default KMS key is used. If you specify KmsKeyId property, then that KMS Key is used to encrypt the database instances in the DB cluster.
               
               If you specify the SourceDBClusterIdentifier property and don't specify this property or disable it. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the KmsKeyId property from the source cluster is used.
               
               If you specify the DBSnapshotIdentifier and don't specify this property or disable it. The value is inherited from the snapshot, and the specified KmsKeyId property from the snapshot is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags assigned to this cluster.
        :param pulumi.Input[bool] use_latest_restorable_time: Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
               
               If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
               
               If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: Provides a list of VPC security groups that the DB cluster belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DbClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Neptune::DBCluster resource creates an Amazon Neptune DB cluster.

        :param str resource_name: The name of the resource.
        :param DbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterRoleArgs', 'DbClusterDbClusterRoleArgsDict']]]]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_instance_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[int]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 serverless_scaling_configuration: Optional[pulumi.Input[Union['DbClusterServerlessScalingConfigurationArgs', 'DbClusterServerlessScalingConfigurationArgsDict']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbClusterArgs.__new__(DbClusterArgs)

            __props__.__dict__["associated_roles"] = associated_roles
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
            __props__.__dict__["db_cluster_parameter_group_name"] = db_cluster_parameter_group_name
            __props__.__dict__["db_instance_parameter_group_name"] = db_instance_parameter_group_name
            __props__.__dict__["db_port"] = db_port
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_cloudwatch_logs_exports"] = enable_cloudwatch_logs_exports
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["iam_auth_enabled"] = iam_auth_enabled
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["restore_to_time"] = restore_to_time
            __props__.__dict__["restore_type"] = restore_type
            __props__.__dict__["serverless_scaling_configuration"] = serverless_scaling_configuration
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["source_db_cluster_identifier"] = source_db_cluster_identifier
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_latest_restorable_time"] = use_latest_restorable_time
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["cluster_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["read_endpoint"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["availabilityZones[*]", "dbClusterIdentifier", "dbSubnetGroupName", "kmsKeyId", "restoreToTime", "restoreType", "snapshotIdentifier", "sourceDbClusterIdentifier", "storageEncrypted", "useLatestRestorableTime"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DbCluster, __self__).__init__(
            'aws-native:neptune:DbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DbCluster':
        """
        Get an existing DbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DbClusterArgs.__new__(DbClusterArgs)

        __props__.__dict__["associated_roles"] = None
        __props__.__dict__["availability_zones"] = None
        __props__.__dict__["backup_retention_period"] = None
        __props__.__dict__["cluster_resource_id"] = None
        __props__.__dict__["copy_tags_to_snapshot"] = None
        __props__.__dict__["db_cluster_identifier"] = None
        __props__.__dict__["db_cluster_parameter_group_name"] = None
        __props__.__dict__["db_instance_parameter_group_name"] = None
        __props__.__dict__["db_port"] = None
        __props__.__dict__["db_subnet_group_name"] = None
        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["enable_cloudwatch_logs_exports"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["iam_auth_enabled"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["preferred_backup_window"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["read_endpoint"] = None
        __props__.__dict__["restore_to_time"] = None
        __props__.__dict__["restore_type"] = None
        __props__.__dict__["serverless_scaling_configuration"] = None
        __props__.__dict__["snapshot_identifier"] = None
        __props__.__dict__["source_db_cluster_identifier"] = None
        __props__.__dict__["storage_encrypted"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["use_latest_restorable_time"] = None
        __props__.__dict__["vpc_security_group_ids"] = None
        return DbCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> pulumi.Output[Optional[Sequence['outputs.DbClusterDbClusterRole']]]:
        """
        Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        """
        return pulumi.get(self, "associated_roles")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of days for which automatic DB snapshots are retained.
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> pulumi.Output[str]:
        """
        The resource id for the DB cluster. For example: `cluster-ABCD1234EFGH5678IJKL90MNOP`. The cluster ID uniquely identifies the cluster and is used in things like IAM authentication policies.
        """
        return pulumi.get(self, "cluster_resource_id")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default behaviour is not to copy them.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The DB cluster identifier. Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster stored as a lowercase string.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Provides the name of the DB cluster parameter group.
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @property
    @pulumi.getter(name="dbInstanceParameterGroupName")
    def db_instance_parameter_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the DB parameter group to apply to all instances of the DB cluster. Used only in case of a major EngineVersion upgrade request.
        """
        return pulumi.get(self, "db_instance_parameter_group_name")

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port number on which the DB instances in the DB cluster accept connections. 

        If not specified, the default port used is `8182`. 

        Note: `Port` property will soon be deprecated from this resource. Please update existing templates to rename it with new property `DBPort` having same functionalities.
        """
        return pulumi.get(self, "db_port")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a list of log types that are enabled for export to CloudWatch Logs.
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The connection endpoint for the DB cluster. For example: `mystack-mydbcluster-1apw1j4phylrk.cg034hpkmmjt.us-east-2.rds.amazonaws.com`
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates the database engine version.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="iamAuthEnabled")
    def iam_auth_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
        """
        return pulumi.get(self, "iam_auth_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default KMS key is used. If you specify this property, you must set the StorageEncrypted property to true.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        The port number on which the DB cluster accepts connections. For example: `8182`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the BackupRetentionPeriod.
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> pulumi.Output[str]:
        """
        The reader endpoint for the DB cluster. For example: `mystack-mydbcluster-ro-1apw1j4phylrk.cg034hpkmmjt.us-east-2.rds.amazonaws.com`
        """
        return pulumi.get(self, "read_endpoint")

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> pulumi.Output[Optional[str]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "restore_to_time")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[Optional[str]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="serverlessScalingConfiguration")
    def serverless_scaling_configuration(self) -> pulumi.Output[Optional['outputs.DbClusterServerlessScalingConfiguration']]:
        """
        Contains the scaling configuration used by the Neptune Serverless Instances within this DB cluster.
        """
        return pulumi.get(self, "serverless_scaling_configuration")

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the identifier for a DB cluster snapshot. Must match the identifier of an existing snapshot.

        After you restore a DB cluster using a SnapshotIdentifier, you must specify the same SnapshotIdentifier for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed.

        However, if you don't specify the SnapshotIdentifier, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the snapshot specified by the SnapshotIdentifier, and the original DB cluster is deleted.
        """
        return pulumi.get(self, "snapshot_identifier")

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the DB cluster is encrypted.

        If you specify the KmsKeyId property, then you must enable encryption and set this property to true.

        If you enable the StorageEncrypted property but don't specify KmsKeyId property, then the default KMS key is used. If you specify KmsKeyId property, then that KMS Key is used to encrypt the database instances in the DB cluster.

        If you specify the SourceDBClusterIdentifier property and don't specify this property or disable it. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the KmsKeyId property from the source cluster is used.

        If you specify the DBSnapshotIdentifier and don't specify this property or disable it. The value is inherited from the snapshot, and the specified KmsKeyId property from the snapshot is used.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags assigned to this cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> pulumi.Output[Optional[bool]]:
        """
        Creates a new DB cluster from a DB snapshot or DB cluster snapshot.

        If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.

        If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Provides a list of VPC security groups that the DB cluster belongs to.
        """
        return pulumi.get(self, "vpc_security_group_ids")

