# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    def __init__(__self__, airflow_configuration_options=None, airflow_version=None, arn=None, celery_executor_queue=None, dag_s3_path=None, database_vpc_endpoint_service=None, environment_class=None, execution_role_arn=None, logging_configuration=None, max_webservers=None, max_workers=None, min_webservers=None, min_workers=None, network_configuration=None, plugins_s3_object_version=None, plugins_s3_path=None, requirements_s3_object_version=None, requirements_s3_path=None, schedulers=None, source_bucket_arn=None, startup_script_s3_object_version=None, startup_script_s3_path=None, tags=None, webserver_access_mode=None, webserver_url=None, webserver_vpc_endpoint_service=None, weekly_maintenance_window_start=None):
        if airflow_configuration_options and not isinstance(airflow_configuration_options, dict):
            raise TypeError("Expected argument 'airflow_configuration_options' to be a dict")
        pulumi.set(__self__, "airflow_configuration_options", airflow_configuration_options)
        if airflow_version and not isinstance(airflow_version, str):
            raise TypeError("Expected argument 'airflow_version' to be a str")
        pulumi.set(__self__, "airflow_version", airflow_version)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if celery_executor_queue and not isinstance(celery_executor_queue, str):
            raise TypeError("Expected argument 'celery_executor_queue' to be a str")
        pulumi.set(__self__, "celery_executor_queue", celery_executor_queue)
        if dag_s3_path and not isinstance(dag_s3_path, str):
            raise TypeError("Expected argument 'dag_s3_path' to be a str")
        pulumi.set(__self__, "dag_s3_path", dag_s3_path)
        if database_vpc_endpoint_service and not isinstance(database_vpc_endpoint_service, str):
            raise TypeError("Expected argument 'database_vpc_endpoint_service' to be a str")
        pulumi.set(__self__, "database_vpc_endpoint_service", database_vpc_endpoint_service)
        if environment_class and not isinstance(environment_class, str):
            raise TypeError("Expected argument 'environment_class' to be a str")
        pulumi.set(__self__, "environment_class", environment_class)
        if execution_role_arn and not isinstance(execution_role_arn, str):
            raise TypeError("Expected argument 'execution_role_arn' to be a str")
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if logging_configuration and not isinstance(logging_configuration, dict):
            raise TypeError("Expected argument 'logging_configuration' to be a dict")
        pulumi.set(__self__, "logging_configuration", logging_configuration)
        if max_webservers and not isinstance(max_webservers, int):
            raise TypeError("Expected argument 'max_webservers' to be a int")
        pulumi.set(__self__, "max_webservers", max_webservers)
        if max_workers and not isinstance(max_workers, int):
            raise TypeError("Expected argument 'max_workers' to be a int")
        pulumi.set(__self__, "max_workers", max_workers)
        if min_webservers and not isinstance(min_webservers, int):
            raise TypeError("Expected argument 'min_webservers' to be a int")
        pulumi.set(__self__, "min_webservers", min_webservers)
        if min_workers and not isinstance(min_workers, int):
            raise TypeError("Expected argument 'min_workers' to be a int")
        pulumi.set(__self__, "min_workers", min_workers)
        if network_configuration and not isinstance(network_configuration, dict):
            raise TypeError("Expected argument 'network_configuration' to be a dict")
        pulumi.set(__self__, "network_configuration", network_configuration)
        if plugins_s3_object_version and not isinstance(plugins_s3_object_version, str):
            raise TypeError("Expected argument 'plugins_s3_object_version' to be a str")
        pulumi.set(__self__, "plugins_s3_object_version", plugins_s3_object_version)
        if plugins_s3_path and not isinstance(plugins_s3_path, str):
            raise TypeError("Expected argument 'plugins_s3_path' to be a str")
        pulumi.set(__self__, "plugins_s3_path", plugins_s3_path)
        if requirements_s3_object_version and not isinstance(requirements_s3_object_version, str):
            raise TypeError("Expected argument 'requirements_s3_object_version' to be a str")
        pulumi.set(__self__, "requirements_s3_object_version", requirements_s3_object_version)
        if requirements_s3_path and not isinstance(requirements_s3_path, str):
            raise TypeError("Expected argument 'requirements_s3_path' to be a str")
        pulumi.set(__self__, "requirements_s3_path", requirements_s3_path)
        if schedulers and not isinstance(schedulers, int):
            raise TypeError("Expected argument 'schedulers' to be a int")
        pulumi.set(__self__, "schedulers", schedulers)
        if source_bucket_arn and not isinstance(source_bucket_arn, str):
            raise TypeError("Expected argument 'source_bucket_arn' to be a str")
        pulumi.set(__self__, "source_bucket_arn", source_bucket_arn)
        if startup_script_s3_object_version and not isinstance(startup_script_s3_object_version, str):
            raise TypeError("Expected argument 'startup_script_s3_object_version' to be a str")
        pulumi.set(__self__, "startup_script_s3_object_version", startup_script_s3_object_version)
        if startup_script_s3_path and not isinstance(startup_script_s3_path, str):
            raise TypeError("Expected argument 'startup_script_s3_path' to be a str")
        pulumi.set(__self__, "startup_script_s3_path", startup_script_s3_path)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if webserver_access_mode and not isinstance(webserver_access_mode, str):
            raise TypeError("Expected argument 'webserver_access_mode' to be a str")
        pulumi.set(__self__, "webserver_access_mode", webserver_access_mode)
        if webserver_url and not isinstance(webserver_url, str):
            raise TypeError("Expected argument 'webserver_url' to be a str")
        pulumi.set(__self__, "webserver_url", webserver_url)
        if webserver_vpc_endpoint_service and not isinstance(webserver_vpc_endpoint_service, str):
            raise TypeError("Expected argument 'webserver_vpc_endpoint_service' to be a str")
        pulumi.set(__self__, "webserver_vpc_endpoint_service", webserver_vpc_endpoint_service)
        if weekly_maintenance_window_start and not isinstance(weekly_maintenance_window_start, str):
            raise TypeError("Expected argument 'weekly_maintenance_window_start' to be a str")
        pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="airflowConfigurationOptions")
    def airflow_configuration_options(self) -> Optional[Any]:
        """
        Key/value pairs representing Airflow configuration variables.
            Keys are prefixed by their section:

            [core]
            dags_folder={AIRFLOW_HOME}/dags

            Would be represented as

            "core.dags_folder": "{AIRFLOW_HOME}/dags"

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "airflow_configuration_options")

    @property
    @pulumi.getter(name="airflowVersion")
    def airflow_version(self) -> Optional[str]:
        """
        The version of Apache Airflow to use for the environment. If no value is specified, defaults to the latest version.

        If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.

        *Allowed Values* : `1.10.12` | `2.0.2` | `2.2.2` | `2.4.3` | `2.5.1` | `2.6.3` | `2.7.2` | `2.8.1` | `2.9.2` (latest)
        """
        return pulumi.get(self, "airflow_version")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN for the Amazon MWAA environment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="celeryExecutorQueue")
    def celery_executor_queue(self) -> Optional[str]:
        """
        The queue ARN for the environment's [Celery Executor](https://docs.aws.amazon.com/https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html) . Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
        """
        return pulumi.get(self, "celery_executor_queue")

    @property
    @pulumi.getter(name="dagS3Path")
    def dag_s3_path(self) -> Optional[str]:
        """
        The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags` . To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html) .
        """
        return pulumi.get(self, "dag_s3_path")

    @property
    @pulumi.getter(name="databaseVpcEndpointService")
    def database_vpc_endpoint_service(self) -> Optional[str]:
        """
        The VPC endpoint for the environment's Amazon RDS database.
        """
        return pulumi.get(self, "database_vpc_endpoint_service")

    @property
    @pulumi.getter(name="environmentClass")
    def environment_class(self) -> Optional[str]:
        """
        The environment class type. Valid values: `mw1.small` , `mw1.medium` , `mw1.large` . To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html) .
        """
        return pulumi.get(self, "environment_class")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role` . To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html) .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional['outputs.EnvironmentLoggingConfiguration']:
        """
        The Apache Airflow logs being sent to CloudWatch Logs: `DagProcessingLogs` , `SchedulerLogs` , `TaskLogs` , `WebserverLogs` , `WorkerLogs` .
        """
        return pulumi.get(self, "logging_configuration")

    @property
    @pulumi.getter(name="maxWebservers")
    def max_webservers(self) -> Optional[int]:
        """
        The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers` . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .

        Valid values: Accepts between `2` and `5` . Defaults to `2` .
        """
        return pulumi.get(self, "max_webservers")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[int]:
        """
        The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20` . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers` .
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter(name="minWebservers")
    def min_webservers(self) -> Optional[int]:
        """
        The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .

        Valid values: Accepts between `2` and `5` . Defaults to `2` .
        """
        return pulumi.get(self, "min_webservers")

    @property
    @pulumi.getter(name="minWorkers")
    def min_workers(self) -> Optional[int]:
        """
        The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2` .
        """
        return pulumi.get(self, "min_workers")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.EnvironmentNetworkConfiguration']:
        """
        The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html) .
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="pluginsS3ObjectVersion")
    def plugins_s3_object_version(self) -> Optional[str]:
        """
        The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        """
        return pulumi.get(self, "plugins_s3_object_version")

    @property
    @pulumi.getter(name="pluginsS3Path")
    def plugins_s3_path(self) -> Optional[str]:
        """
        The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip` . To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        """
        return pulumi.get(self, "plugins_s3_path")

    @property
    @pulumi.getter(name="requirementsS3ObjectVersion")
    def requirements_s3_object_version(self) -> Optional[str]:
        """
        The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        """
        return pulumi.get(self, "requirements_s3_object_version")

    @property
    @pulumi.getter(name="requirementsS3Path")
    def requirements_s3_path(self) -> Optional[str]:
        """
        The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt` . To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        """
        return pulumi.get(self, "requirements_s3_path")

    @property
    @pulumi.getter
    def schedulers(self) -> Optional[int]:
        """
        The number of schedulers that you want to run in your environment. Valid values:

        - *v2* - Accepts between 2 to 5. Defaults to 2.
        - *v1* - Accepts 1.
        """
        return pulumi.get(self, "schedulers")

    @property
    @pulumi.getter(name="sourceBucketArn")
    def source_bucket_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name` . To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html) .
        """
        return pulumi.get(self, "source_bucket_arn")

    @property
    @pulumi.getter(name="startupScriptS3ObjectVersion")
    def startup_script_s3_object_version(self) -> Optional[str]:
        """
        The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.

        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:

        `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`

        For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        """
        return pulumi.get(self, "startup_script_s3_object_version")

    @property
    @pulumi.getter(name="startupScriptS3Path")
    def startup_script_s3_path(self) -> Optional[str]:
        """
        The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh` .

        Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        """
        return pulumi.get(self, "startup_script_s3_path")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        A map of tags for the environment.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="webserverAccessMode")
    def webserver_access_mode(self) -> Optional['EnvironmentWebserverAccessMode']:
        """
        The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html) . Valid values: `PRIVATE_ONLY` or `PUBLIC_ONLY` .
        """
        return pulumi.get(self, "webserver_access_mode")

    @property
    @pulumi.getter(name="webserverUrl")
    def webserver_url(self) -> Optional[str]:
        """
        The URL of your Apache Airflow UI.
        """
        return pulumi.get(self, "webserver_url")

    @property
    @pulumi.getter(name="webserverVpcEndpointService")
    def webserver_vpc_endpoint_service(self) -> Optional[str]:
        """
        The VPC endpoint for the environment's web server.
        """
        return pulumi.get(self, "webserver_vpc_endpoint_service")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[str]:
        """
        The day and time of the week to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM` . For example: `TUE:03:30` . You can specify a start time in 30 minute increments only. Supported input includes the following:

        - MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)
        """
        return pulumi.get(self, "weekly_maintenance_window_start")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            airflow_configuration_options=self.airflow_configuration_options,
            airflow_version=self.airflow_version,
            arn=self.arn,
            celery_executor_queue=self.celery_executor_queue,
            dag_s3_path=self.dag_s3_path,
            database_vpc_endpoint_service=self.database_vpc_endpoint_service,
            environment_class=self.environment_class,
            execution_role_arn=self.execution_role_arn,
            logging_configuration=self.logging_configuration,
            max_webservers=self.max_webservers,
            max_workers=self.max_workers,
            min_webservers=self.min_webservers,
            min_workers=self.min_workers,
            network_configuration=self.network_configuration,
            plugins_s3_object_version=self.plugins_s3_object_version,
            plugins_s3_path=self.plugins_s3_path,
            requirements_s3_object_version=self.requirements_s3_object_version,
            requirements_s3_path=self.requirements_s3_path,
            schedulers=self.schedulers,
            source_bucket_arn=self.source_bucket_arn,
            startup_script_s3_object_version=self.startup_script_s3_object_version,
            startup_script_s3_path=self.startup_script_s3_path,
            tags=self.tags,
            webserver_access_mode=self.webserver_access_mode,
            webserver_url=self.webserver_url,
            webserver_vpc_endpoint_service=self.webserver_vpc_endpoint_service,
            weekly_maintenance_window_start=self.weekly_maintenance_window_start)


def get_environment(name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Resource schema for AWS::MWAA::Environment


    :param str name: The name of your Amazon MWAA environment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:mwaa:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        airflow_configuration_options=pulumi.get(__ret__, 'airflow_configuration_options'),
        airflow_version=pulumi.get(__ret__, 'airflow_version'),
        arn=pulumi.get(__ret__, 'arn'),
        celery_executor_queue=pulumi.get(__ret__, 'celery_executor_queue'),
        dag_s3_path=pulumi.get(__ret__, 'dag_s3_path'),
        database_vpc_endpoint_service=pulumi.get(__ret__, 'database_vpc_endpoint_service'),
        environment_class=pulumi.get(__ret__, 'environment_class'),
        execution_role_arn=pulumi.get(__ret__, 'execution_role_arn'),
        logging_configuration=pulumi.get(__ret__, 'logging_configuration'),
        max_webservers=pulumi.get(__ret__, 'max_webservers'),
        max_workers=pulumi.get(__ret__, 'max_workers'),
        min_webservers=pulumi.get(__ret__, 'min_webservers'),
        min_workers=pulumi.get(__ret__, 'min_workers'),
        network_configuration=pulumi.get(__ret__, 'network_configuration'),
        plugins_s3_object_version=pulumi.get(__ret__, 'plugins_s3_object_version'),
        plugins_s3_path=pulumi.get(__ret__, 'plugins_s3_path'),
        requirements_s3_object_version=pulumi.get(__ret__, 'requirements_s3_object_version'),
        requirements_s3_path=pulumi.get(__ret__, 'requirements_s3_path'),
        schedulers=pulumi.get(__ret__, 'schedulers'),
        source_bucket_arn=pulumi.get(__ret__, 'source_bucket_arn'),
        startup_script_s3_object_version=pulumi.get(__ret__, 'startup_script_s3_object_version'),
        startup_script_s3_path=pulumi.get(__ret__, 'startup_script_s3_path'),
        tags=pulumi.get(__ret__, 'tags'),
        webserver_access_mode=pulumi.get(__ret__, 'webserver_access_mode'),
        webserver_url=pulumi.get(__ret__, 'webserver_url'),
        webserver_vpc_endpoint_service=pulumi.get(__ret__, 'webserver_vpc_endpoint_service'),
        weekly_maintenance_window_start=pulumi.get(__ret__, 'weekly_maintenance_window_start'))
def get_environment_output(name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Resource schema for AWS::MWAA::Environment


    :param str name: The name of your Amazon MWAA environment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:mwaa:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult)
    return __ret__.apply(lambda __response__: GetEnvironmentResult(
        airflow_configuration_options=pulumi.get(__response__, 'airflow_configuration_options'),
        airflow_version=pulumi.get(__response__, 'airflow_version'),
        arn=pulumi.get(__response__, 'arn'),
        celery_executor_queue=pulumi.get(__response__, 'celery_executor_queue'),
        dag_s3_path=pulumi.get(__response__, 'dag_s3_path'),
        database_vpc_endpoint_service=pulumi.get(__response__, 'database_vpc_endpoint_service'),
        environment_class=pulumi.get(__response__, 'environment_class'),
        execution_role_arn=pulumi.get(__response__, 'execution_role_arn'),
        logging_configuration=pulumi.get(__response__, 'logging_configuration'),
        max_webservers=pulumi.get(__response__, 'max_webservers'),
        max_workers=pulumi.get(__response__, 'max_workers'),
        min_webservers=pulumi.get(__response__, 'min_webservers'),
        min_workers=pulumi.get(__response__, 'min_workers'),
        network_configuration=pulumi.get(__response__, 'network_configuration'),
        plugins_s3_object_version=pulumi.get(__response__, 'plugins_s3_object_version'),
        plugins_s3_path=pulumi.get(__response__, 'plugins_s3_path'),
        requirements_s3_object_version=pulumi.get(__response__, 'requirements_s3_object_version'),
        requirements_s3_path=pulumi.get(__response__, 'requirements_s3_path'),
        schedulers=pulumi.get(__response__, 'schedulers'),
        source_bucket_arn=pulumi.get(__response__, 'source_bucket_arn'),
        startup_script_s3_object_version=pulumi.get(__response__, 'startup_script_s3_object_version'),
        startup_script_s3_path=pulumi.get(__response__, 'startup_script_s3_path'),
        tags=pulumi.get(__response__, 'tags'),
        webserver_access_mode=pulumi.get(__response__, 'webserver_access_mode'),
        webserver_url=pulumi.get(__response__, 'webserver_url'),
        webserver_vpc_endpoint_service=pulumi.get(__response__, 'webserver_vpc_endpoint_service'),
        weekly_maintenance_window_start=pulumi.get(__response__, 'weekly_maintenance_window_start')))
