# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'EnvironmentLoggingConfigurationArgs',
    'EnvironmentLoggingConfigurationArgsDict',
    'EnvironmentModuleLoggingConfigurationArgs',
    'EnvironmentModuleLoggingConfigurationArgsDict',
    'EnvironmentNetworkConfigurationArgs',
    'EnvironmentNetworkConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class EnvironmentLoggingConfigurationArgsDict(TypedDict):
        """
        Logging configuration for the environment.
        """
        dag_processing_logs: NotRequired[pulumi.Input['EnvironmentModuleLoggingConfigurationArgsDict']]
        """
        Defines the processing logs sent to CloudWatch Logs and the logging level to send.
        """
        scheduler_logs: NotRequired[pulumi.Input['EnvironmentModuleLoggingConfigurationArgsDict']]
        """
        Defines the scheduler logs sent to CloudWatch Logs and the logging level to send.
        """
        task_logs: NotRequired[pulumi.Input['EnvironmentModuleLoggingConfigurationArgsDict']]
        """
        Defines the task logs sent to CloudWatch Logs and the logging level to send.
        """
        webserver_logs: NotRequired[pulumi.Input['EnvironmentModuleLoggingConfigurationArgsDict']]
        """
        Defines the web server logs sent to CloudWatch Logs and the logging level to send.
        """
        worker_logs: NotRequired[pulumi.Input['EnvironmentModuleLoggingConfigurationArgsDict']]
        """
        Defines the worker logs sent to CloudWatch Logs and the logging level to send.
        """
elif False:
    EnvironmentLoggingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentLoggingConfigurationArgs:
    def __init__(__self__, *,
                 dag_processing_logs: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']] = None,
                 scheduler_logs: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']] = None,
                 task_logs: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']] = None,
                 webserver_logs: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']] = None,
                 worker_logs: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']] = None):
        """
        Logging configuration for the environment.
        :param pulumi.Input['EnvironmentModuleLoggingConfigurationArgs'] dag_processing_logs: Defines the processing logs sent to CloudWatch Logs and the logging level to send.
        :param pulumi.Input['EnvironmentModuleLoggingConfigurationArgs'] scheduler_logs: Defines the scheduler logs sent to CloudWatch Logs and the logging level to send.
        :param pulumi.Input['EnvironmentModuleLoggingConfigurationArgs'] task_logs: Defines the task logs sent to CloudWatch Logs and the logging level to send.
        :param pulumi.Input['EnvironmentModuleLoggingConfigurationArgs'] webserver_logs: Defines the web server logs sent to CloudWatch Logs and the logging level to send.
        :param pulumi.Input['EnvironmentModuleLoggingConfigurationArgs'] worker_logs: Defines the worker logs sent to CloudWatch Logs and the logging level to send.
        """
        if dag_processing_logs is not None:
            pulumi.set(__self__, "dag_processing_logs", dag_processing_logs)
        if scheduler_logs is not None:
            pulumi.set(__self__, "scheduler_logs", scheduler_logs)
        if task_logs is not None:
            pulumi.set(__self__, "task_logs", task_logs)
        if webserver_logs is not None:
            pulumi.set(__self__, "webserver_logs", webserver_logs)
        if worker_logs is not None:
            pulumi.set(__self__, "worker_logs", worker_logs)

    @property
    @pulumi.getter(name="dagProcessingLogs")
    def dag_processing_logs(self) -> Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]:
        """
        Defines the processing logs sent to CloudWatch Logs and the logging level to send.
        """
        return pulumi.get(self, "dag_processing_logs")

    @dag_processing_logs.setter
    def dag_processing_logs(self, value: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]):
        pulumi.set(self, "dag_processing_logs", value)

    @property
    @pulumi.getter(name="schedulerLogs")
    def scheduler_logs(self) -> Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]:
        """
        Defines the scheduler logs sent to CloudWatch Logs and the logging level to send.
        """
        return pulumi.get(self, "scheduler_logs")

    @scheduler_logs.setter
    def scheduler_logs(self, value: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]):
        pulumi.set(self, "scheduler_logs", value)

    @property
    @pulumi.getter(name="taskLogs")
    def task_logs(self) -> Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]:
        """
        Defines the task logs sent to CloudWatch Logs and the logging level to send.
        """
        return pulumi.get(self, "task_logs")

    @task_logs.setter
    def task_logs(self, value: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]):
        pulumi.set(self, "task_logs", value)

    @property
    @pulumi.getter(name="webserverLogs")
    def webserver_logs(self) -> Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]:
        """
        Defines the web server logs sent to CloudWatch Logs and the logging level to send.
        """
        return pulumi.get(self, "webserver_logs")

    @webserver_logs.setter
    def webserver_logs(self, value: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]):
        pulumi.set(self, "webserver_logs", value)

    @property
    @pulumi.getter(name="workerLogs")
    def worker_logs(self) -> Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]:
        """
        Defines the worker logs sent to CloudWatch Logs and the logging level to send.
        """
        return pulumi.get(self, "worker_logs")

    @worker_logs.setter
    def worker_logs(self, value: Optional[pulumi.Input['EnvironmentModuleLoggingConfigurationArgs']]):
        pulumi.set(self, "worker_logs", value)


if not MYPY:
    class EnvironmentModuleLoggingConfigurationArgsDict(TypedDict):
        """
        Logging configuration for a specific airflow component.
        """
        cloud_watch_log_group_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the CloudWatch Logs log group for each type of Apache Airflow log type that you have enabled.

        > `CloudWatchLogGroupArn` is available only as a return value, accessible when specified as an attribute in the [`Fn:GetAtt`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#aws-resource-mwaa-environment-return-values) intrinsic function. Any value you provide for `CloudWatchLogGroupArn` is discarded by Amazon MWAA.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to enable the Apache Airflow log type (e.g. `DagProcessingLogs` ) in CloudWatch Logs.
        """
        log_level: NotRequired[pulumi.Input['EnvironmentLoggingLevel']]
        """
        Defines the Apache Airflow logs to send for the log type (e.g. `DagProcessingLogs` ) to CloudWatch Logs. Valid values: `CRITICAL` , `ERROR` , `WARNING` , `INFO` .
        """
elif False:
    EnvironmentModuleLoggingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentModuleLoggingConfigurationArgs:
    def __init__(__self__, *,
                 cloud_watch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 log_level: Optional[pulumi.Input['EnvironmentLoggingLevel']] = None):
        """
        Logging configuration for a specific airflow component.
        :param pulumi.Input[str] cloud_watch_log_group_arn: The ARN of the CloudWatch Logs log group for each type of Apache Airflow log type that you have enabled.
               
               > `CloudWatchLogGroupArn` is available only as a return value, accessible when specified as an attribute in the [`Fn:GetAtt`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#aws-resource-mwaa-environment-return-values) intrinsic function. Any value you provide for `CloudWatchLogGroupArn` is discarded by Amazon MWAA.
        :param pulumi.Input[bool] enabled: Indicates whether to enable the Apache Airflow log type (e.g. `DagProcessingLogs` ) in CloudWatch Logs.
        :param pulumi.Input['EnvironmentLoggingLevel'] log_level: Defines the Apache Airflow logs to send for the log type (e.g. `DagProcessingLogs` ) to CloudWatch Logs. Valid values: `CRITICAL` , `ERROR` , `WARNING` , `INFO` .
        """
        if cloud_watch_log_group_arn is not None:
            pulumi.set(__self__, "cloud_watch_log_group_arn", cloud_watch_log_group_arn)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the CloudWatch Logs log group for each type of Apache Airflow log type that you have enabled.

        > `CloudWatchLogGroupArn` is available only as a return value, accessible when specified as an attribute in the [`Fn:GetAtt`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#aws-resource-mwaa-environment-return-values) intrinsic function. Any value you provide for `CloudWatchLogGroupArn` is discarded by Amazon MWAA.
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @cloud_watch_log_group_arn.setter
    def cloud_watch_log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_watch_log_group_arn", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable the Apache Airflow log type (e.g. `DagProcessingLogs` ) in CloudWatch Logs.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input['EnvironmentLoggingLevel']]:
        """
        Defines the Apache Airflow logs to send for the log type (e.g. `DagProcessingLogs` ) to CloudWatch Logs. Valid values: `CRITICAL` , `ERROR` , `WARNING` , `INFO` .
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input['EnvironmentLoggingLevel']]):
        pulumi.set(self, "log_level", value)


if not MYPY:
    class EnvironmentNetworkConfigurationArgsDict(TypedDict):
        """
        Configures the network resources of the environment.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of security groups to use for the environment.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of subnets to use for the environment. These must be private subnets, in the same VPC, in two different availability zones.
        """
elif False:
    EnvironmentNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentNetworkConfigurationArgs:
    def __init__(__self__, *,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Configures the network resources of the environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security groups to use for the environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnets to use for the environment. These must be private subnets, in the same VPC, in two different availability zones.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security groups to use for the environment.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnets to use for the environment. These must be private subnets, in the same VPC, in two different availability zones.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


