# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['VpcConnectionArgs', 'VpcConnection']

@pulumi.input_type
class VpcConnectionArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['VpcConnectionAuthentication'],
                 client_subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 security_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 target_cluster_arn: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a VpcConnection resource.
        :param pulumi.Input['VpcConnectionAuthentication'] authentication: The type of private link authentication.
        :param pulumi.Input[str] target_cluster_arn: The Amazon Resource Name (ARN) of the target cluster
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "target_cluster_arn", target_cluster_arn)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['VpcConnectionAuthentication']:
        """
        The type of private link authentication.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['VpcConnectionAuthentication']):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "client_subnets")

    @client_subnets.setter
    def client_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "client_subnets", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="targetClusterArn")
    def target_cluster_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the target cluster
        """
        return pulumi.get(self, "target_cluster_arn")

    @target_cluster_arn.setter
    def target_cluster_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_cluster_arn", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class VpcConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input['VpcConnectionAuthentication']] = None,
                 client_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_cluster_arn: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::MSK::VpcConnection

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['VpcConnectionAuthentication'] authentication: The type of private link authentication.
        :param pulumi.Input[str] target_cluster_arn: The Amazon Resource Name (ARN) of the target cluster
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::MSK::VpcConnection

        :param str resource_name: The name of the resource.
        :param VpcConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input['VpcConnectionAuthentication']] = None,
                 client_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_cluster_arn: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcConnectionArgs.__new__(VpcConnectionArgs)

            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            if client_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'client_subnets'")
            __props__.__dict__["client_subnets"] = client_subnets
            if security_groups is None and not opts.urn:
                raise TypeError("Missing required property 'security_groups'")
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["tags"] = tags
            if target_cluster_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_cluster_arn'")
            __props__.__dict__["target_cluster_arn"] = target_cluster_arn
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["authentication", "clientSubnets[*]", "securityGroups[*]", "targetClusterArn", "vpcId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(VpcConnection, __self__).__init__(
            'aws-native:msk:VpcConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcConnection':
        """
        Get an existing VpcConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcConnectionArgs.__new__(VpcConnectionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["authentication"] = None
        __props__.__dict__["client_subnets"] = None
        __props__.__dict__["security_groups"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_cluster_arn"] = None
        __props__.__dict__["vpc_id"] = None
        return VpcConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the VPC connection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['VpcConnectionAuthentication']:
        """
        The type of private link authentication.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "client_subnets")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetClusterArn")
    def target_cluster_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the target cluster
        """
        return pulumi.get(self, "target_cluster_arn")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpc_id")

