# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['ChannelGroupArgs', 'ChannelGroup']

@pulumi.input_type
class ChannelGroupArgs:
    def __init__(__self__, *,
                 channel_group_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ChannelGroup resource.
        :param pulumi.Input[str] channel_group_name: The name of the channel group.
        :param pulumi.Input[str] description: <p>Enter any descriptive text that helps you to identify the channel group.</p>
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags associated with the channel group.
        """
        if channel_group_name is not None:
            pulumi.set(__self__, "channel_group_name", channel_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="channelGroupName")
    def channel_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel group.
        """
        return pulumi.get(self, "channel_group_name")

    @channel_group_name.setter
    def channel_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_group_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        <p>Enter any descriptive text that helps you to identify the channel group.</p>
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags associated with the channel group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class ChannelGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_group_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        <p>Represents a channel group that facilitates the grouping of multiple channels.</p>

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_group_name: The name of the channel group.
        :param pulumi.Input[str] description: <p>Enter any descriptive text that helps you to identify the channel group.</p>
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags associated with the channel group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ChannelGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <p>Represents a channel group that facilitates the grouping of multiple channels.</p>

        :param str resource_name: The name of the resource.
        :param ChannelGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_group_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelGroupArgs.__new__(ChannelGroupArgs)

            __props__.__dict__["channel_group_name"] = channel_group_name
            __props__.__dict__["description"] = description
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["egress_domain"] = None
            __props__.__dict__["modified_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["channelGroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ChannelGroup, __self__).__init__(
            'aws-native:mediapackagev2:ChannelGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ChannelGroup':
        """
        Get an existing ChannelGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChannelGroupArgs.__new__(ChannelGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["channel_group_name"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["egress_domain"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["tags"] = None
        return ChannelGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        <p>The Amazon Resource Name (ARN) associated with the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="channelGroupName")
    def channel_group_name(self) -> pulumi.Output[str]:
        """
        The name of the channel group.
        """
        return pulumi.get(self, "channel_group_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        <p>The date and time the channel group was created.</p>
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        <p>Enter any descriptive text that helps you to identify the channel group.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressDomain")
    def egress_domain(self) -> pulumi.Output[str]:
        """
        <p>The output domain where the source stream should be sent. Integrate the domain with a downstream CDN (such as Amazon CloudFront) or playback device.</p>
        """
        return pulumi.get(self, "egress_domain")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        """
        <p>The date and time the channel group was modified.</p>
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags associated with the channel group.
        """
        return pulumi.get(self, "tags")

