# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterInterfaceMapping',
    'ClusterNetworkSettings',
    'EventBridgeRuleTemplateTarget',
    'MultiplexOutputDestination',
    'MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties',
    'MultiplexSettings',
    'MultiplexprogramMultiplexProgramPacketIdentifiersMap',
    'MultiplexprogramMultiplexProgramPipelineDetail',
    'MultiplexprogramMultiplexProgramServiceDescriptor',
    'MultiplexprogramMultiplexProgramSettings',
    'MultiplexprogramMultiplexVideoSettings',
    'NetworkIpPool',
    'NetworkRoute',
    'SignalMapMediaResource',
    'SignalMapMediaResourceNeighbor',
    'SignalMapMonitorDeployment',
    'SignalMapSuccessfulMonitorDeployment',
]

@pulumi.output_type
class ClusterInterfaceMapping(dict):
    """
    Network mappings for the cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicalInterfaceName":
            suggest = "logical_interface_name"
        elif key == "networkId":
            suggest = "network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterInterfaceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterInterfaceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterInterfaceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logical_interface_name: Optional[str] = None,
                 network_id: Optional[str] = None):
        """
        Network mappings for the cluster
        :param str logical_interface_name: logical interface name, unique in the list
        :param str network_id: Network Id to be associated with the logical interface name, can be duplicated in list
        """
        if logical_interface_name is not None:
            pulumi.set(__self__, "logical_interface_name", logical_interface_name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter(name="logicalInterfaceName")
    def logical_interface_name(self) -> Optional[str]:
        """
        logical interface name, unique in the list
        """
        return pulumi.get(self, "logical_interface_name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[str]:
        """
        Network Id to be associated with the logical interface name, can be duplicated in list
        """
        return pulumi.get(self, "network_id")


@pulumi.output_type
class ClusterNetworkSettings(dict):
    """
    On premises settings which will have the interface network mappings and default Output logical interface
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRoute":
            suggest = "default_route"
        elif key == "interfaceMappings":
            suggest = "interface_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworkSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworkSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworkSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_route: Optional[str] = None,
                 interface_mappings: Optional[Sequence['outputs.ClusterInterfaceMapping']] = None):
        """
        On premises settings which will have the interface network mappings and default Output logical interface
        :param str default_route: Default value if the customer does not define it in channel Output API
        :param Sequence['ClusterInterfaceMapping'] interface_mappings: Network mappings for the cluster
        """
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)
        if interface_mappings is not None:
            pulumi.set(__self__, "interface_mappings", interface_mappings)

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[str]:
        """
        Default value if the customer does not define it in channel Output API
        """
        return pulumi.get(self, "default_route")

    @property
    @pulumi.getter(name="interfaceMappings")
    def interface_mappings(self) -> Optional[Sequence['outputs.ClusterInterfaceMapping']]:
        """
        Network mappings for the cluster
        """
        return pulumi.get(self, "interface_mappings")


@pulumi.output_type
class EventBridgeRuleTemplateTarget(dict):
    """
    The target to which to send matching events.
    """
    def __init__(__self__, *,
                 arn: str):
        """
        The target to which to send matching events.
        :param str arn: Target ARNs must be either an SNS topic or CloudWatch log group.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Target ARNs must be either an SNS topic or CloudWatch log group.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class MultiplexOutputDestination(dict):
    """
    Multiplex MediaConnect output destination settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multiplexMediaConnectOutputDestinationSettings":
            suggest = "multiplex_media_connect_output_destination_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexOutputDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexOutputDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexOutputDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multiplex_media_connect_output_destination_settings: Optional['outputs.MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties'] = None):
        """
        Multiplex MediaConnect output destination settings.
        :param 'MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties' multiplex_media_connect_output_destination_settings: Multiplex MediaConnect output destination settings.
        """
        if multiplex_media_connect_output_destination_settings is not None:
            pulumi.set(__self__, "multiplex_media_connect_output_destination_settings", multiplex_media_connect_output_destination_settings)

    @property
    @pulumi.getter(name="multiplexMediaConnectOutputDestinationSettings")
    def multiplex_media_connect_output_destination_settings(self) -> Optional['outputs.MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties']:
        """
        Multiplex MediaConnect output destination settings.
        """
        return pulumi.get(self, "multiplex_media_connect_output_destination_settings")


@pulumi.output_type
class MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties(dict):
    """
    Multiplex MediaConnect output destination settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entitlementArn":
            suggest = "entitlement_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexOutputDestinationMultiplexMediaConnectOutputDestinationSettingsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entitlement_arn: Optional[str] = None):
        """
        Multiplex MediaConnect output destination settings.
        :param str entitlement_arn: The MediaConnect entitlement ARN available as a Flow source.
        """
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[str]:
        """
        The MediaConnect entitlement ARN available as a Flow source.
        """
        return pulumi.get(self, "entitlement_arn")


@pulumi.output_type
class MultiplexSettings(dict):
    """
    A key-value pair to associate with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transportStreamBitrate":
            suggest = "transport_stream_bitrate"
        elif key == "transportStreamId":
            suggest = "transport_stream_id"
        elif key == "maximumVideoBufferDelayMilliseconds":
            suggest = "maximum_video_buffer_delay_milliseconds"
        elif key == "transportStreamReservedBitrate":
            suggest = "transport_stream_reserved_bitrate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transport_stream_bitrate: int,
                 transport_stream_id: int,
                 maximum_video_buffer_delay_milliseconds: Optional[int] = None,
                 transport_stream_reserved_bitrate: Optional[int] = None):
        """
        A key-value pair to associate with a resource.
        :param int transport_stream_bitrate: Transport stream bit rate.
        :param int transport_stream_id: Transport stream ID.
        :param int maximum_video_buffer_delay_milliseconds: Maximum video buffer delay in milliseconds.
        :param int transport_stream_reserved_bitrate: Transport stream reserved bit rate.
        """
        pulumi.set(__self__, "transport_stream_bitrate", transport_stream_bitrate)
        pulumi.set(__self__, "transport_stream_id", transport_stream_id)
        if maximum_video_buffer_delay_milliseconds is not None:
            pulumi.set(__self__, "maximum_video_buffer_delay_milliseconds", maximum_video_buffer_delay_milliseconds)
        if transport_stream_reserved_bitrate is not None:
            pulumi.set(__self__, "transport_stream_reserved_bitrate", transport_stream_reserved_bitrate)

    @property
    @pulumi.getter(name="transportStreamBitrate")
    def transport_stream_bitrate(self) -> int:
        """
        Transport stream bit rate.
        """
        return pulumi.get(self, "transport_stream_bitrate")

    @property
    @pulumi.getter(name="transportStreamId")
    def transport_stream_id(self) -> int:
        """
        Transport stream ID.
        """
        return pulumi.get(self, "transport_stream_id")

    @property
    @pulumi.getter(name="maximumVideoBufferDelayMilliseconds")
    def maximum_video_buffer_delay_milliseconds(self) -> Optional[int]:
        """
        Maximum video buffer delay in milliseconds.
        """
        return pulumi.get(self, "maximum_video_buffer_delay_milliseconds")

    @property
    @pulumi.getter(name="transportStreamReservedBitrate")
    def transport_stream_reserved_bitrate(self) -> Optional[int]:
        """
        Transport stream reserved bit rate.
        """
        return pulumi.get(self, "transport_stream_reserved_bitrate")


@pulumi.output_type
class MultiplexprogramMultiplexProgramPacketIdentifiersMap(dict):
    """
    Packet identifiers map for a given Multiplex program.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioPids":
            suggest = "audio_pids"
        elif key == "dvbSubPids":
            suggest = "dvb_sub_pids"
        elif key == "dvbTeletextPid":
            suggest = "dvb_teletext_pid"
        elif key == "etvPlatformPid":
            suggest = "etv_platform_pid"
        elif key == "etvSignalPid":
            suggest = "etv_signal_pid"
        elif key == "klvDataPids":
            suggest = "klv_data_pids"
        elif key == "pcrPid":
            suggest = "pcr_pid"
        elif key == "pmtPid":
            suggest = "pmt_pid"
        elif key == "privateMetadataPid":
            suggest = "private_metadata_pid"
        elif key == "scte27Pids":
            suggest = "scte27_pids"
        elif key == "scte35Pid":
            suggest = "scte35_pid"
        elif key == "timedMetadataPid":
            suggest = "timed_metadata_pid"
        elif key == "videoPid":
            suggest = "video_pid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexprogramMultiplexProgramPacketIdentifiersMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexprogramMultiplexProgramPacketIdentifiersMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexprogramMultiplexProgramPacketIdentifiersMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_pids: Optional[Sequence[int]] = None,
                 dvb_sub_pids: Optional[Sequence[int]] = None,
                 dvb_teletext_pid: Optional[int] = None,
                 etv_platform_pid: Optional[int] = None,
                 etv_signal_pid: Optional[int] = None,
                 klv_data_pids: Optional[Sequence[int]] = None,
                 pcr_pid: Optional[int] = None,
                 pmt_pid: Optional[int] = None,
                 private_metadata_pid: Optional[int] = None,
                 scte27_pids: Optional[Sequence[int]] = None,
                 scte35_pid: Optional[int] = None,
                 timed_metadata_pid: Optional[int] = None,
                 video_pid: Optional[int] = None):
        """
        Packet identifiers map for a given Multiplex program.
        """
        if audio_pids is not None:
            pulumi.set(__self__, "audio_pids", audio_pids)
        if dvb_sub_pids is not None:
            pulumi.set(__self__, "dvb_sub_pids", dvb_sub_pids)
        if dvb_teletext_pid is not None:
            pulumi.set(__self__, "dvb_teletext_pid", dvb_teletext_pid)
        if etv_platform_pid is not None:
            pulumi.set(__self__, "etv_platform_pid", etv_platform_pid)
        if etv_signal_pid is not None:
            pulumi.set(__self__, "etv_signal_pid", etv_signal_pid)
        if klv_data_pids is not None:
            pulumi.set(__self__, "klv_data_pids", klv_data_pids)
        if pcr_pid is not None:
            pulumi.set(__self__, "pcr_pid", pcr_pid)
        if pmt_pid is not None:
            pulumi.set(__self__, "pmt_pid", pmt_pid)
        if private_metadata_pid is not None:
            pulumi.set(__self__, "private_metadata_pid", private_metadata_pid)
        if scte27_pids is not None:
            pulumi.set(__self__, "scte27_pids", scte27_pids)
        if scte35_pid is not None:
            pulumi.set(__self__, "scte35_pid", scte35_pid)
        if timed_metadata_pid is not None:
            pulumi.set(__self__, "timed_metadata_pid", timed_metadata_pid)
        if video_pid is not None:
            pulumi.set(__self__, "video_pid", video_pid)

    @property
    @pulumi.getter(name="audioPids")
    def audio_pids(self) -> Optional[Sequence[int]]:
        return pulumi.get(self, "audio_pids")

    @property
    @pulumi.getter(name="dvbSubPids")
    def dvb_sub_pids(self) -> Optional[Sequence[int]]:
        return pulumi.get(self, "dvb_sub_pids")

    @property
    @pulumi.getter(name="dvbTeletextPid")
    def dvb_teletext_pid(self) -> Optional[int]:
        return pulumi.get(self, "dvb_teletext_pid")

    @property
    @pulumi.getter(name="etvPlatformPid")
    def etv_platform_pid(self) -> Optional[int]:
        return pulumi.get(self, "etv_platform_pid")

    @property
    @pulumi.getter(name="etvSignalPid")
    def etv_signal_pid(self) -> Optional[int]:
        return pulumi.get(self, "etv_signal_pid")

    @property
    @pulumi.getter(name="klvDataPids")
    def klv_data_pids(self) -> Optional[Sequence[int]]:
        return pulumi.get(self, "klv_data_pids")

    @property
    @pulumi.getter(name="pcrPid")
    def pcr_pid(self) -> Optional[int]:
        return pulumi.get(self, "pcr_pid")

    @property
    @pulumi.getter(name="pmtPid")
    def pmt_pid(self) -> Optional[int]:
        return pulumi.get(self, "pmt_pid")

    @property
    @pulumi.getter(name="privateMetadataPid")
    def private_metadata_pid(self) -> Optional[int]:
        return pulumi.get(self, "private_metadata_pid")

    @property
    @pulumi.getter(name="scte27Pids")
    def scte27_pids(self) -> Optional[Sequence[int]]:
        return pulumi.get(self, "scte27_pids")

    @property
    @pulumi.getter(name="scte35Pid")
    def scte35_pid(self) -> Optional[int]:
        return pulumi.get(self, "scte35_pid")

    @property
    @pulumi.getter(name="timedMetadataPid")
    def timed_metadata_pid(self) -> Optional[int]:
        return pulumi.get(self, "timed_metadata_pid")

    @property
    @pulumi.getter(name="videoPid")
    def video_pid(self) -> Optional[int]:
        return pulumi.get(self, "video_pid")


@pulumi.output_type
class MultiplexprogramMultiplexProgramPipelineDetail(dict):
    """
    The current source for one of the pipelines in the multiplex.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeChannelPipeline":
            suggest = "active_channel_pipeline"
        elif key == "pipelineId":
            suggest = "pipeline_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexprogramMultiplexProgramPipelineDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexprogramMultiplexProgramPipelineDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexprogramMultiplexProgramPipelineDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_channel_pipeline: Optional[str] = None,
                 pipeline_id: Optional[str] = None):
        """
        The current source for one of the pipelines in the multiplex.
        :param str active_channel_pipeline: Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
        :param str pipeline_id: Identifies a specific pipeline in the multiplex.
        """
        if active_channel_pipeline is not None:
            pulumi.set(__self__, "active_channel_pipeline", active_channel_pipeline)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)

    @property
    @pulumi.getter(name="activeChannelPipeline")
    def active_channel_pipeline(self) -> Optional[str]:
        """
        Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
        """
        return pulumi.get(self, "active_channel_pipeline")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[str]:
        """
        Identifies a specific pipeline in the multiplex.
        """
        return pulumi.get(self, "pipeline_id")


@pulumi.output_type
class MultiplexprogramMultiplexProgramServiceDescriptor(dict):
    """
    Transport stream service descriptor configuration for the Multiplex program.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerName":
            suggest = "provider_name"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexprogramMultiplexProgramServiceDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexprogramMultiplexProgramServiceDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexprogramMultiplexProgramServiceDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_name: str,
                 service_name: str):
        """
        Transport stream service descriptor configuration for the Multiplex program.
        :param str provider_name: Name of the provider.
        :param str service_name: Name of the service.
        """
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> str:
        """
        Name of the provider.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Name of the service.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class MultiplexprogramMultiplexProgramSettings(dict):
    """
    Multiplex Program settings configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "programNumber":
            suggest = "program_number"
        elif key == "preferredChannelPipeline":
            suggest = "preferred_channel_pipeline"
        elif key == "serviceDescriptor":
            suggest = "service_descriptor"
        elif key == "videoSettings":
            suggest = "video_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiplexprogramMultiplexProgramSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiplexprogramMultiplexProgramSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiplexprogramMultiplexProgramSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 program_number: int,
                 preferred_channel_pipeline: Optional['MultiplexprogramPreferredChannelPipeline'] = None,
                 service_descriptor: Optional['outputs.MultiplexprogramMultiplexProgramServiceDescriptor'] = None,
                 video_settings: Optional['outputs.MultiplexprogramMultiplexVideoSettings'] = None):
        """
        Multiplex Program settings configuration.
        :param int program_number: Unique program number.
        :param 'MultiplexprogramPreferredChannelPipeline' preferred_channel_pipeline: Indicates which pipeline is preferred by the multiplex for program ingest.
        :param 'MultiplexprogramMultiplexProgramServiceDescriptor' service_descriptor: Transport stream service descriptor configuration for the Multiplex program.
        :param 'MultiplexprogramMultiplexVideoSettings' video_settings: Program video settings configuration.
        """
        pulumi.set(__self__, "program_number", program_number)
        if preferred_channel_pipeline is not None:
            pulumi.set(__self__, "preferred_channel_pipeline", preferred_channel_pipeline)
        if service_descriptor is not None:
            pulumi.set(__self__, "service_descriptor", service_descriptor)
        if video_settings is not None:
            pulumi.set(__self__, "video_settings", video_settings)

    @property
    @pulumi.getter(name="programNumber")
    def program_number(self) -> int:
        """
        Unique program number.
        """
        return pulumi.get(self, "program_number")

    @property
    @pulumi.getter(name="preferredChannelPipeline")
    def preferred_channel_pipeline(self) -> Optional['MultiplexprogramPreferredChannelPipeline']:
        """
        Indicates which pipeline is preferred by the multiplex for program ingest.
        """
        return pulumi.get(self, "preferred_channel_pipeline")

    @property
    @pulumi.getter(name="serviceDescriptor")
    def service_descriptor(self) -> Optional['outputs.MultiplexprogramMultiplexProgramServiceDescriptor']:
        """
        Transport stream service descriptor configuration for the Multiplex program.
        """
        return pulumi.get(self, "service_descriptor")

    @property
    @pulumi.getter(name="videoSettings")
    def video_settings(self) -> Optional['outputs.MultiplexprogramMultiplexVideoSettings']:
        """
        Program video settings configuration.
        """
        return pulumi.get(self, "video_settings")


@pulumi.output_type
class MultiplexprogramMultiplexVideoSettings(dict):
    """
    The video configuration for each program in a multiplex.
    """
    def __init__(__self__):
        """
        The video configuration for each program in a multiplex.
        """
        pass


@pulumi.output_type
class NetworkIpPool(dict):
    """
    IP address cidr pool
    """
    def __init__(__self__, *,
                 cidr: Optional[str] = None):
        """
        IP address cidr pool
        :param str cidr: IP address cidr pool
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[str]:
        """
        IP address cidr pool
        """
        return pulumi.get(self, "cidr")


@pulumi.output_type
class NetworkRoute(dict):
    def __init__(__self__, *,
                 cidr: Optional[str] = None,
                 gateway: Optional[str] = None):
        """
        :param str cidr: Ip address cidr
        :param str gateway: IP address for the route packet paths
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[str]:
        """
        Ip address cidr
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        IP address for the route packet paths
        """
        return pulumi.get(self, "gateway")


@pulumi.output_type
class SignalMapMediaResource(dict):
    """
    An AWS resource used in media workflows.
    """
    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.SignalMapMediaResourceNeighbor']] = None,
                 name: Optional[str] = None,
                 sources: Optional[Sequence['outputs.SignalMapMediaResourceNeighbor']] = None):
        """
        An AWS resource used in media workflows.
        :param Sequence['SignalMapMediaResourceNeighbor'] destinations: A direct destination neighbor to an Amazon Web Services media resource.
        :param str name: The logical name of an AWS media resource.
        :param Sequence['SignalMapMediaResourceNeighbor'] sources: A direct source neighbor to an Amazon Web Services media resource.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.SignalMapMediaResourceNeighbor']]:
        """
        A direct destination neighbor to an Amazon Web Services media resource.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The logical name of an AWS media resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.SignalMapMediaResourceNeighbor']]:
        """
        A direct source neighbor to an Amazon Web Services media resource.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class SignalMapMediaResourceNeighbor(dict):
    """
    A direct source or destination neighbor to an AWS media resource.
    """
    def __init__(__self__, *,
                 arn: str,
                 name: Optional[str] = None):
        """
        A direct source or destination neighbor to an AWS media resource.
        :param str arn: The ARN of a resource used in AWS media workflows.
        :param str name: The logical name of an AWS media resource.
        """
        pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of a resource used in AWS media workflows.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The logical name of an AWS media resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SignalMapMonitorDeployment(dict):
    """
    Represents the latest monitor deployment of a signal map.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailsUri":
            suggest = "details_uri"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignalMapMonitorDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignalMapMonitorDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignalMapMonitorDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'SignalMapMonitorDeploymentStatus',
                 details_uri: Optional[str] = None,
                 error_message: Optional[str] = None):
        """
        Represents the latest monitor deployment of a signal map.
        :param 'SignalMapMonitorDeploymentStatus' status: The signal map monitor deployment status.
        :param str details_uri: URI associated with a signal map's monitor deployment.
        :param str error_message: Error message associated with a failed monitor deployment of a signal map.
        """
        pulumi.set(__self__, "status", status)
        if details_uri is not None:
            pulumi.set(__self__, "details_uri", details_uri)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter
    def status(self) -> 'SignalMapMonitorDeploymentStatus':
        """
        The signal map monitor deployment status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="detailsUri")
    def details_uri(self) -> Optional[str]:
        """
        URI associated with a signal map's monitor deployment.
        """
        return pulumi.get(self, "details_uri")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message associated with a failed monitor deployment of a signal map.
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class SignalMapSuccessfulMonitorDeployment(dict):
    """
    Represents the latest successful monitor deployment of a signal map.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailsUri":
            suggest = "details_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignalMapSuccessfulMonitorDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignalMapSuccessfulMonitorDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignalMapSuccessfulMonitorDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details_uri: str,
                 status: 'SignalMapMonitorDeploymentStatus'):
        """
        Represents the latest successful monitor deployment of a signal map.
        :param str details_uri: URI associated with a signal map's monitor deployment.
        :param 'SignalMapMonitorDeploymentStatus' status: A signal map's monitor deployment status.
        """
        pulumi.set(__self__, "details_uri", details_uri)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="detailsUri")
    def details_uri(self) -> str:
        """
        URI associated with a signal map's monitor deployment.
        """
        return pulumi.get(self, "details_uri")

    @property
    @pulumi.getter
    def status(self) -> 'SignalMapMonitorDeploymentStatus':
        """
        A signal map's monitor deployment status.
        """
        return pulumi.get(self, "status")


