# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['MultiplexArgs', 'Multiplex']

@pulumi.input_type
class MultiplexArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 multiplex_settings: pulumi.Input['MultiplexSettingsArgs'],
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['MultiplexOutputDestinationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Multiplex resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of availability zones for the multiplex.
        :param pulumi.Input['MultiplexSettingsArgs'] multiplex_settings: Configuration for a multiplex event.
        :param pulumi.Input[Sequence[pulumi.Input['MultiplexOutputDestinationArgs']]] destinations: A list of the multiplex output destinations.
        :param pulumi.Input[str] name: Name of multiplex.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A collection of key-value pairs.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "multiplex_settings", multiplex_settings)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of availability zones for the multiplex.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="multiplexSettings")
    def multiplex_settings(self) -> pulumi.Input['MultiplexSettingsArgs']:
        """
        Configuration for a multiplex event.
        """
        return pulumi.get(self, "multiplex_settings")

    @multiplex_settings.setter
    def multiplex_settings(self, value: pulumi.Input['MultiplexSettingsArgs']):
        pulumi.set(self, "multiplex_settings", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MultiplexOutputDestinationArgs']]]]:
        """
        A list of the multiplex output destinations.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MultiplexOutputDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of multiplex.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A collection of key-value pairs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Multiplex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MultiplexOutputDestinationArgs', 'MultiplexOutputDestinationArgsDict']]]]] = None,
                 multiplex_settings: Optional[pulumi.Input[Union['MultiplexSettingsArgs', 'MultiplexSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaLive::Multiplex

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of availability zones for the multiplex.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MultiplexOutputDestinationArgs', 'MultiplexOutputDestinationArgsDict']]]] destinations: A list of the multiplex output destinations.
        :param pulumi.Input[Union['MultiplexSettingsArgs', 'MultiplexSettingsArgsDict']] multiplex_settings: Configuration for a multiplex event.
        :param pulumi.Input[str] name: Name of multiplex.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A collection of key-value pairs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MultiplexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaLive::Multiplex

        :param str resource_name: The name of the resource.
        :param MultiplexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MultiplexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MultiplexOutputDestinationArgs', 'MultiplexOutputDestinationArgsDict']]]]] = None,
                 multiplex_settings: Optional[pulumi.Input[Union['MultiplexSettingsArgs', 'MultiplexSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MultiplexArgs.__new__(MultiplexArgs)

            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["destinations"] = destinations
            if multiplex_settings is None and not opts.urn:
                raise TypeError("Missing required property 'multiplex_settings'")
            __props__.__dict__["multiplex_settings"] = multiplex_settings
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["pipelines_running_count"] = None
            __props__.__dict__["program_count"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["availabilityZones[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Multiplex, __self__).__init__(
            'aws-native:medialive:Multiplex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Multiplex':
        """
        Get an existing Multiplex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MultiplexArgs.__new__(MultiplexArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["availability_zones"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["destinations"] = None
        __props__.__dict__["multiplex_settings"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["pipelines_running_count"] = None
        __props__.__dict__["program_count"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        return Multiplex(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The unique arn of the multiplex.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of availability zones for the multiplex.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        The unique id of the multiplex.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.MultiplexOutputDestination']]]:
        """
        A list of the multiplex output destinations.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="multiplexSettings")
    def multiplex_settings(self) -> pulumi.Output['outputs.MultiplexSettings']:
        """
        Configuration for a multiplex event.
        """
        return pulumi.get(self, "multiplex_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of multiplex.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelinesRunningCount")
    def pipelines_running_count(self) -> pulumi.Output[int]:
        """
        The number of currently healthy pipelines.
        """
        return pulumi.get(self, "pipelines_running_count")

    @property
    @pulumi.getter(name="programCount")
    def program_count(self) -> pulumi.Output[int]:
        """
        The number of programs in the multiplex.
        """
        return pulumi.get(self, "program_count")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['MultiplexState']:
        """
        The current state of the multiplex.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A collection of key-value pairs.
        """
        return pulumi.get(self, "tags")

