# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetSignalMapResult',
    'AwaitableGetSignalMapResult',
    'get_signal_map',
    'get_signal_map_output',
]

@pulumi.output_type
class GetSignalMapResult:
    def __init__(__self__, arn=None, cloud_watch_alarm_template_group_ids=None, created_at=None, description=None, discovery_entry_point_arn=None, error_message=None, event_bridge_rule_template_group_ids=None, failed_media_resource_map=None, id=None, identifier=None, last_discovered_at=None, last_successful_monitor_deployment=None, media_resource_map=None, modified_at=None, monitor_changes_pending_deployment=None, monitor_deployment=None, name=None, status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cloud_watch_alarm_template_group_ids and not isinstance(cloud_watch_alarm_template_group_ids, list):
            raise TypeError("Expected argument 'cloud_watch_alarm_template_group_ids' to be a list")
        pulumi.set(__self__, "cloud_watch_alarm_template_group_ids", cloud_watch_alarm_template_group_ids)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if discovery_entry_point_arn and not isinstance(discovery_entry_point_arn, str):
            raise TypeError("Expected argument 'discovery_entry_point_arn' to be a str")
        pulumi.set(__self__, "discovery_entry_point_arn", discovery_entry_point_arn)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if event_bridge_rule_template_group_ids and not isinstance(event_bridge_rule_template_group_ids, list):
            raise TypeError("Expected argument 'event_bridge_rule_template_group_ids' to be a list")
        pulumi.set(__self__, "event_bridge_rule_template_group_ids", event_bridge_rule_template_group_ids)
        if failed_media_resource_map and not isinstance(failed_media_resource_map, dict):
            raise TypeError("Expected argument 'failed_media_resource_map' to be a dict")
        pulumi.set(__self__, "failed_media_resource_map", failed_media_resource_map)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if last_discovered_at and not isinstance(last_discovered_at, str):
            raise TypeError("Expected argument 'last_discovered_at' to be a str")
        pulumi.set(__self__, "last_discovered_at", last_discovered_at)
        if last_successful_monitor_deployment and not isinstance(last_successful_monitor_deployment, dict):
            raise TypeError("Expected argument 'last_successful_monitor_deployment' to be a dict")
        pulumi.set(__self__, "last_successful_monitor_deployment", last_successful_monitor_deployment)
        if media_resource_map and not isinstance(media_resource_map, dict):
            raise TypeError("Expected argument 'media_resource_map' to be a dict")
        pulumi.set(__self__, "media_resource_map", media_resource_map)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if monitor_changes_pending_deployment and not isinstance(monitor_changes_pending_deployment, bool):
            raise TypeError("Expected argument 'monitor_changes_pending_deployment' to be a bool")
        pulumi.set(__self__, "monitor_changes_pending_deployment", monitor_changes_pending_deployment)
        if monitor_deployment and not isinstance(monitor_deployment, dict):
            raise TypeError("Expected argument 'monitor_deployment' to be a dict")
        pulumi.set(__self__, "monitor_deployment", monitor_deployment)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        A signal map's ARN (Amazon Resource Name)
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudWatchAlarmTemplateGroupIds")
    def cloud_watch_alarm_template_group_ids(self) -> Optional[Sequence[str]]:
        """
        An alarm template group's id.
        """
        return pulumi.get(self, "cloud_watch_alarm_template_group_ids")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time of resource creation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoveryEntryPointArn")
    def discovery_entry_point_arn(self) -> Optional[str]:
        """
        A top-level supported AWS resource ARN to discovery a signal map from.
        """
        return pulumi.get(self, "discovery_entry_point_arn")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error message associated with a failed creation or failed update attempt of a signal map.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="eventBridgeRuleTemplateGroupIds")
    def event_bridge_rule_template_group_ids(self) -> Optional[Sequence[str]]:
        """
        An eventbridge rule template group's id.
        """
        return pulumi.get(self, "event_bridge_rule_template_group_ids")

    @property
    @pulumi.getter(name="failedMediaResourceMap")
    def failed_media_resource_map(self) -> Optional[Mapping[str, 'outputs.SignalMapMediaResource']]:
        return pulumi.get(self, "failed_media_resource_map")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A signal map's id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lastDiscoveredAt")
    def last_discovered_at(self) -> Optional[str]:
        """
        The date and time of latest discovery.
        """
        return pulumi.get(self, "last_discovered_at")

    @property
    @pulumi.getter(name="lastSuccessfulMonitorDeployment")
    def last_successful_monitor_deployment(self) -> Optional['outputs.SignalMapSuccessfulMonitorDeployment']:
        return pulumi.get(self, "last_successful_monitor_deployment")

    @property
    @pulumi.getter(name="mediaResourceMap")
    def media_resource_map(self) -> Optional[Mapping[str, 'outputs.SignalMapMediaResource']]:
        return pulumi.get(self, "media_resource_map")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[str]:
        """
        The date and time of latest resource modification.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="monitorChangesPendingDeployment")
    def monitor_changes_pending_deployment(self) -> Optional[bool]:
        """
        If true, there are pending monitor changes for this signal map that can be deployed.
        """
        return pulumi.get(self, "monitor_changes_pending_deployment")

    @property
    @pulumi.getter(name="monitorDeployment")
    def monitor_deployment(self) -> Optional['outputs.SignalMapMonitorDeployment']:
        return pulumi.get(self, "monitor_deployment")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['SignalMapStatus']:
        """
        A signal map's current status, which is dependent on its lifecycle actions or associated jobs.
        """
        return pulumi.get(self, "status")


class AwaitableGetSignalMapResult(GetSignalMapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSignalMapResult(
            arn=self.arn,
            cloud_watch_alarm_template_group_ids=self.cloud_watch_alarm_template_group_ids,
            created_at=self.created_at,
            description=self.description,
            discovery_entry_point_arn=self.discovery_entry_point_arn,
            error_message=self.error_message,
            event_bridge_rule_template_group_ids=self.event_bridge_rule_template_group_ids,
            failed_media_resource_map=self.failed_media_resource_map,
            id=self.id,
            identifier=self.identifier,
            last_discovered_at=self.last_discovered_at,
            last_successful_monitor_deployment=self.last_successful_monitor_deployment,
            media_resource_map=self.media_resource_map,
            modified_at=self.modified_at,
            monitor_changes_pending_deployment=self.monitor_changes_pending_deployment,
            monitor_deployment=self.monitor_deployment,
            name=self.name,
            status=self.status)


def get_signal_map(identifier: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSignalMapResult:
    """
    Definition of AWS::MediaLive::SignalMap Resource Type
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:medialive:getSignalMap', __args__, opts=opts, typ=GetSignalMapResult).value

    return AwaitableGetSignalMapResult(
        arn=pulumi.get(__ret__, 'arn'),
        cloud_watch_alarm_template_group_ids=pulumi.get(__ret__, 'cloud_watch_alarm_template_group_ids'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        discovery_entry_point_arn=pulumi.get(__ret__, 'discovery_entry_point_arn'),
        error_message=pulumi.get(__ret__, 'error_message'),
        event_bridge_rule_template_group_ids=pulumi.get(__ret__, 'event_bridge_rule_template_group_ids'),
        failed_media_resource_map=pulumi.get(__ret__, 'failed_media_resource_map'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        last_discovered_at=pulumi.get(__ret__, 'last_discovered_at'),
        last_successful_monitor_deployment=pulumi.get(__ret__, 'last_successful_monitor_deployment'),
        media_resource_map=pulumi.get(__ret__, 'media_resource_map'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        monitor_changes_pending_deployment=pulumi.get(__ret__, 'monitor_changes_pending_deployment'),
        monitor_deployment=pulumi.get(__ret__, 'monitor_deployment'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'))
def get_signal_map_output(identifier: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSignalMapResult]:
    """
    Definition of AWS::MediaLive::SignalMap Resource Type
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:medialive:getSignalMap', __args__, opts=opts, typ=GetSignalMapResult)
    return __ret__.apply(lambda __response__: GetSignalMapResult(
        arn=pulumi.get(__response__, 'arn'),
        cloud_watch_alarm_template_group_ids=pulumi.get(__response__, 'cloud_watch_alarm_template_group_ids'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        discovery_entry_point_arn=pulumi.get(__response__, 'discovery_entry_point_arn'),
        error_message=pulumi.get(__response__, 'error_message'),
        event_bridge_rule_template_group_ids=pulumi.get(__response__, 'event_bridge_rule_template_group_ids'),
        failed_media_resource_map=pulumi.get(__response__, 'failed_media_resource_map'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        last_discovered_at=pulumi.get(__response__, 'last_discovered_at'),
        last_successful_monitor_deployment=pulumi.get(__response__, 'last_successful_monitor_deployment'),
        media_resource_map=pulumi.get(__response__, 'media_resource_map'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        monitor_changes_pending_deployment=pulumi.get(__response__, 'monitor_changes_pending_deployment'),
        monitor_deployment=pulumi.get(__response__, 'monitor_deployment'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status')))
