# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    def __init__(__self__, arn=None, associated_cluster_ids=None, id=None, ip_pools=None, name=None, routes=None, state=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if associated_cluster_ids and not isinstance(associated_cluster_ids, list):
            raise TypeError("Expected argument 'associated_cluster_ids' to be a list")
        pulumi.set(__self__, "associated_cluster_ids", associated_cluster_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_pools and not isinstance(ip_pools, list):
            raise TypeError("Expected argument 'ip_pools' to be a list")
        pulumi.set(__self__, "ip_pools", ip_pools)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the Network.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associatedClusterIds")
    def associated_cluster_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "associated_cluster_ids")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique ID of the Network.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[Sequence['outputs.NetworkIpPool']]:
        """
        The list of IP address cidr pools for the network
        """
        return pulumi.get(self, "ip_pools")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The user-specified name of the Network to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.NetworkRoute']]:
        """
        The routes for the network
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def state(self) -> Optional['NetworkState']:
        """
        The current state of the Network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A collection of key-value pairs.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            arn=self.arn,
            associated_cluster_ids=self.associated_cluster_ids,
            id=self.id,
            ip_pools=self.ip_pools,
            name=self.name,
            routes=self.routes,
            state=self.state,
            tags=self.tags)


def get_network(id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    Resource schema for AWS::MediaLive::Network.


    :param str id: The unique ID of the Network.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:medialive:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        arn=pulumi.get(__ret__, 'arn'),
        associated_cluster_ids=pulumi.get(__ret__, 'associated_cluster_ids'),
        id=pulumi.get(__ret__, 'id'),
        ip_pools=pulumi.get(__ret__, 'ip_pools'),
        name=pulumi.get(__ret__, 'name'),
        routes=pulumi.get(__ret__, 'routes'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_output(id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkResult]:
    """
    Resource schema for AWS::MediaLive::Network.


    :param str id: The unique ID of the Network.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:medialive:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        arn=pulumi.get(__response__, 'arn'),
        associated_cluster_ids=pulumi.get(__response__, 'associated_cluster_ids'),
        id=pulumi.get(__response__, 'id'),
        ip_pools=pulumi.get(__response__, 'ip_pools'),
        name=pulumi.get(__response__, 'name'),
        routes=pulumi.get(__response__, 'routes'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
