# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EventBridgeRuleTemplateArgs', 'EventBridgeRuleTemplate']

@pulumi.input_type
class EventBridgeRuleTemplateArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input['EventBridgeRuleTemplateEventType'],
                 group_identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 event_targets: Optional[pulumi.Input[Sequence[pulumi.Input['EventBridgeRuleTemplateTargetArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a EventBridgeRuleTemplate resource.
        :param pulumi.Input['EventBridgeRuleTemplateEventType'] event_type: The type of event to match with the rule.
        :param pulumi.Input[str] group_identifier: An eventbridge rule template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[str] description: A resource's optional description.
        :param pulumi.Input[Sequence[pulumi.Input['EventBridgeRuleTemplateTargetArgs']]] event_targets: Placeholder documentation for __listOfEventBridgeRuleTemplateTarget
        :param pulumi.Input[str] name: A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "group_identifier", group_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_targets is not None:
            pulumi.set(__self__, "event_targets", event_targets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input['EventBridgeRuleTemplateEventType']:
        """
        The type of event to match with the rule.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input['EventBridgeRuleTemplateEventType']):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="groupIdentifier")
    def group_identifier(self) -> pulumi.Input[str]:
        """
        An eventbridge rule template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "group_identifier")

    @group_identifier.setter
    def group_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventTargets")
    def event_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventBridgeRuleTemplateTargetArgs']]]]:
        """
        Placeholder documentation for __listOfEventBridgeRuleTemplateTarget
        """
        return pulumi.get(self, "event_targets")

    @event_targets.setter
    def event_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventBridgeRuleTemplateTargetArgs']]]]):
        pulumi.set(self, "event_targets", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class EventBridgeRuleTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventBridgeRuleTemplateTargetArgs', 'EventBridgeRuleTemplateTargetArgsDict']]]]] = None,
                 event_type: Optional[pulumi.Input['EventBridgeRuleTemplateEventType']] = None,
                 group_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::MediaLive::EventBridgeRuleTemplate Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A resource's optional description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventBridgeRuleTemplateTargetArgs', 'EventBridgeRuleTemplateTargetArgsDict']]]] event_targets: Placeholder documentation for __listOfEventBridgeRuleTemplateTarget
        :param pulumi.Input['EventBridgeRuleTemplateEventType'] event_type: The type of event to match with the rule.
        :param pulumi.Input[str] group_identifier: An eventbridge rule template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[str] name: A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventBridgeRuleTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::MediaLive::EventBridgeRuleTemplate Resource Type

        :param str resource_name: The name of the resource.
        :param EventBridgeRuleTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventBridgeRuleTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventBridgeRuleTemplateTargetArgs', 'EventBridgeRuleTemplateTargetArgsDict']]]]] = None,
                 event_type: Optional[pulumi.Input['EventBridgeRuleTemplateEventType']] = None,
                 group_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventBridgeRuleTemplateArgs.__new__(EventBridgeRuleTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["event_targets"] = event_targets
            if event_type is None and not opts.urn:
                raise TypeError("Missing required property 'event_type'")
            __props__.__dict__["event_type"] = event_type
            if group_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'group_identifier'")
            __props__.__dict__["group_identifier"] = group_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["group_id"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["modified_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tags.*"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EventBridgeRuleTemplate, __self__).__init__(
            'aws-native:medialive:EventBridgeRuleTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EventBridgeRuleTemplate':
        """
        Get an existing EventBridgeRuleTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventBridgeRuleTemplateArgs.__new__(EventBridgeRuleTemplateArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["event_targets"] = None
        __props__.__dict__["event_type"] = None
        __props__.__dict__["group_id"] = None
        __props__.__dict__["group_identifier"] = None
        __props__.__dict__["identifier"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return EventBridgeRuleTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        An eventbridge rule template's ARN (Amazon Resource Name)
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        An eventbridge rule template's id. AWS provided templates have ids that start with `aws-`
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Placeholder documentation for __timestampIso8601
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTargets")
    def event_targets(self) -> pulumi.Output[Optional[Sequence['outputs.EventBridgeRuleTemplateTarget']]]:
        """
        Placeholder documentation for __listOfEventBridgeRuleTemplateTarget
        """
        return pulumi.get(self, "event_targets")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Output['EventBridgeRuleTemplateEventType']:
        """
        The type of event to match with the rule.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        An eventbridge rule template group's id. AWS provided template groups have ids that start with `aws-`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupIdentifier")
    def group_identifier(self) -> pulumi.Output[str]:
        """
        An eventbridge rule template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "group_identifier")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Placeholder documentation for __string
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        """
        Placeholder documentation for __timestampIso8601
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

