# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['CloudWatchAlarmTemplateArgs', 'CloudWatchAlarmTemplate']

@pulumi.input_type
class CloudWatchAlarmTemplateArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input['CloudWatchAlarmTemplateComparisonOperator'],
                 evaluation_periods: pulumi.Input[float],
                 group_identifier: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 period: pulumi.Input[float],
                 statistic: pulumi.Input['CloudWatchAlarmTemplateStatistic'],
                 target_resource_type: pulumi.Input['CloudWatchAlarmTemplateTargetResourceType'],
                 threshold: pulumi.Input[float],
                 treat_missing_data: pulumi.Input['CloudWatchAlarmTemplateTreatMissingData'],
                 datapoints_to_alarm: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CloudWatchAlarmTemplate resource.
        :param pulumi.Input['CloudWatchAlarmTemplateComparisonOperator'] comparison_operator: The comparison operator used to compare the specified statistic and the threshold.
        :param pulumi.Input[float] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[str] group_identifier: A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[str] metric_name: The name of the metric associated with the alarm. Must be compatible with targetResourceType.
        :param pulumi.Input[float] period: The period, in seconds, over which the specified statistic is applied.
        :param pulumi.Input['CloudWatchAlarmTemplateStatistic'] statistic: The statistic to apply to the alarm's metric data.
        :param pulumi.Input['CloudWatchAlarmTemplateTargetResourceType'] target_resource_type: The resource type this template should dynamically generate CloudWatch metric alarms for.
        :param pulumi.Input[float] threshold: The threshold value to compare with the specified statistic.
        :param pulumi.Input['CloudWatchAlarmTemplateTreatMissingData'] treat_missing_data: Specifies how missing data points are treated when evaluating the alarm's condition.
        :param pulumi.Input[float] datapoints_to_alarm: The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
        :param pulumi.Input[str] description: A resource's optional description.
        :param pulumi.Input[str] name: A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        pulumi.set(__self__, "group_identifier", group_identifier)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "target_resource_type", target_resource_type)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "treat_missing_data", treat_missing_data)
        if datapoints_to_alarm is not None:
            pulumi.set(__self__, "datapoints_to_alarm", datapoints_to_alarm)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input['CloudWatchAlarmTemplateComparisonOperator']:
        """
        The comparison operator used to compare the specified statistic and the threshold.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input['CloudWatchAlarmTemplateComparisonOperator']):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Input[float]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: pulumi.Input[float]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="groupIdentifier")
    def group_identifier(self) -> pulumi.Input[str]:
        """
        A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "group_identifier")

    @group_identifier.setter
    def group_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_identifier", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric associated with the alarm. Must be compatible with targetResourceType.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[float]:
        """
        The period, in seconds, over which the specified statistic is applied.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[float]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input['CloudWatchAlarmTemplateStatistic']:
        """
        The statistic to apply to the alarm's metric data.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input['CloudWatchAlarmTemplateStatistic']):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Input['CloudWatchAlarmTemplateTargetResourceType']:
        """
        The resource type this template should dynamically generate CloudWatch metric alarms for.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: pulumi.Input['CloudWatchAlarmTemplateTargetResourceType']):
        pulumi.set(self, "target_resource_type", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        The threshold value to compare with the specified statistic.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> pulumi.Input['CloudWatchAlarmTemplateTreatMissingData']:
        """
        Specifies how missing data points are treated when evaluating the alarm's condition.
        """
        return pulumi.get(self, "treat_missing_data")

    @treat_missing_data.setter
    def treat_missing_data(self, value: pulumi.Input['CloudWatchAlarmTemplateTreatMissingData']):
        pulumi.set(self, "treat_missing_data", value)

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> Optional[pulumi.Input[float]]:
        """
        The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @datapoints_to_alarm.setter
    def datapoints_to_alarm(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "datapoints_to_alarm", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class CloudWatchAlarmTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison_operator: Optional[pulumi.Input['CloudWatchAlarmTemplateComparisonOperator']] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_periods: Optional[pulumi.Input[float]] = None,
                 group_identifier: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[float]] = None,
                 statistic: Optional[pulumi.Input['CloudWatchAlarmTemplateStatistic']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_resource_type: Optional[pulumi.Input['CloudWatchAlarmTemplateTargetResourceType']] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 treat_missing_data: Optional[pulumi.Input['CloudWatchAlarmTemplateTreatMissingData']] = None,
                 __props__=None):
        """
        Definition of AWS::MediaLive::CloudWatchAlarmTemplate Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['CloudWatchAlarmTemplateComparisonOperator'] comparison_operator: The comparison operator used to compare the specified statistic and the threshold.
        :param pulumi.Input[float] datapoints_to_alarm: The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
        :param pulumi.Input[str] description: A resource's optional description.
        :param pulumi.Input[float] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[str] group_identifier: A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[str] metric_name: The name of the metric associated with the alarm. Must be compatible with targetResourceType.
        :param pulumi.Input[str] name: A resource's name. Names must be unique within the scope of a resource type in a specific region.
        :param pulumi.Input[float] period: The period, in seconds, over which the specified statistic is applied.
        :param pulumi.Input['CloudWatchAlarmTemplateStatistic'] statistic: The statistic to apply to the alarm's metric data.
        :param pulumi.Input['CloudWatchAlarmTemplateTargetResourceType'] target_resource_type: The resource type this template should dynamically generate CloudWatch metric alarms for.
        :param pulumi.Input[float] threshold: The threshold value to compare with the specified statistic.
        :param pulumi.Input['CloudWatchAlarmTemplateTreatMissingData'] treat_missing_data: Specifies how missing data points are treated when evaluating the alarm's condition.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudWatchAlarmTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::MediaLive::CloudWatchAlarmTemplate Resource Type

        :param str resource_name: The name of the resource.
        :param CloudWatchAlarmTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudWatchAlarmTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison_operator: Optional[pulumi.Input['CloudWatchAlarmTemplateComparisonOperator']] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 evaluation_periods: Optional[pulumi.Input[float]] = None,
                 group_identifier: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[float]] = None,
                 statistic: Optional[pulumi.Input['CloudWatchAlarmTemplateStatistic']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_resource_type: Optional[pulumi.Input['CloudWatchAlarmTemplateTargetResourceType']] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 treat_missing_data: Optional[pulumi.Input['CloudWatchAlarmTemplateTreatMissingData']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudWatchAlarmTemplateArgs.__new__(CloudWatchAlarmTemplateArgs)

            if comparison_operator is None and not opts.urn:
                raise TypeError("Missing required property 'comparison_operator'")
            __props__.__dict__["comparison_operator"] = comparison_operator
            __props__.__dict__["datapoints_to_alarm"] = datapoints_to_alarm
            __props__.__dict__["description"] = description
            if evaluation_periods is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_periods'")
            __props__.__dict__["evaluation_periods"] = evaluation_periods
            if group_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'group_identifier'")
            __props__.__dict__["group_identifier"] = group_identifier
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["name"] = name
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            if statistic is None and not opts.urn:
                raise TypeError("Missing required property 'statistic'")
            __props__.__dict__["statistic"] = statistic
            __props__.__dict__["tags"] = tags
            if target_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_type'")
            __props__.__dict__["target_resource_type"] = target_resource_type
            if threshold is None and not opts.urn:
                raise TypeError("Missing required property 'threshold'")
            __props__.__dict__["threshold"] = threshold
            if treat_missing_data is None and not opts.urn:
                raise TypeError("Missing required property 'treat_missing_data'")
            __props__.__dict__["treat_missing_data"] = treat_missing_data
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["group_id"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["modified_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tags.*"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CloudWatchAlarmTemplate, __self__).__init__(
            'aws-native:medialive:CloudWatchAlarmTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CloudWatchAlarmTemplate':
        """
        Get an existing CloudWatchAlarmTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CloudWatchAlarmTemplateArgs.__new__(CloudWatchAlarmTemplateArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["comparison_operator"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["datapoints_to_alarm"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["evaluation_periods"] = None
        __props__.__dict__["group_id"] = None
        __props__.__dict__["group_identifier"] = None
        __props__.__dict__["identifier"] = None
        __props__.__dict__["metric_name"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["period"] = None
        __props__.__dict__["statistic"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_resource_type"] = None
        __props__.__dict__["threshold"] = None
        __props__.__dict__["treat_missing_data"] = None
        return CloudWatchAlarmTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        A cloudwatch alarm template's ARN (Amazon Resource Name)
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        A cloudwatch alarm template's id. AWS provided templates have ids that start with `aws-`
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Output['CloudWatchAlarmTemplateComparisonOperator']:
        """
        The comparison operator used to compare the specified statistic and the threshold.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of resource creation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> pulumi.Output[Optional[float]]:
        """
        The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Output[float]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        A cloudwatch alarm template group's id. AWS provided template groups have ids that start with `aws-`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupIdentifier")
    def group_identifier(self) -> pulumi.Output[str]:
        """
        A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "group_identifier")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[str]:
        """
        The name of the metric associated with the alarm. Must be compatible with targetResourceType.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        """
        The date and time of latest resource modification.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[float]:
        """
        The period, in seconds, over which the specified statistic is applied.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Output['CloudWatchAlarmTemplateStatistic']:
        """
        The statistic to apply to the alarm's metric data.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Output['CloudWatchAlarmTemplateTargetResourceType']:
        """
        The resource type this template should dynamically generate CloudWatch metric alarms for.
        """
        return pulumi.get(self, "target_resource_type")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[float]:
        """
        The threshold value to compare with the specified statistic.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> pulumi.Output['CloudWatchAlarmTemplateTreatMissingData']:
        """
        Specifies how missing data points are treated when evaluating the alarm's condition.
        """
        return pulumi.get(self, "treat_missing_data")

